<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
$data = $displayData;
?>
var ulElement = jQuery("<?php echo $data->selector; ?>");
var perPage = <?php echo $data->length; ?>; 
var numItems = ulElement.children().size();
var numPages = Math.ceil(numItems/perPage);
jQuery('#<?php echo $data->selectorPager; ?>').data("curr",0);
jQuery('#<?php echo $data->selectorPager; ?>').data("perPage",perPage);
jQuery('#<?php echo $data->selectorPager; ?>').data("numPages",numPages);

var curr = 0;
jQuery('#<?php echo $data->selectorPager; ?>').data("curr", curr);
<?php 
if ($data->style=="pages") {?>
jQuery('<li><a href="#" class="page_previous">Prev</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
  
while(numPages > curr){
  jQuery('<li class="page_link"><a href="#">'+(curr+1)+'</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
  curr++;
}
jQuery('<li><a href="#" class="page_next">Next</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
<?php 
}
else
if ($data->style=="navigation") {?>
  jQuery('<li><a href="#" class="page_previous">«</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
  jQuery('<li ><span class="navigation_page_number_<?php echo $data->id; ?>">1/'+numPages+'</span></li>').appendTo('#<?php echo $data->selectorPager; ?>');
  jQuery('<li><a href="#" class="page_next">»</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
<?php 
}
else
if ($data->style=="previousnext") {?>
  jQuery('<li><a href="#" class="page_previous">Prev</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
  jQuery('<li><a href="#" class="page_next">Next</a></li>').appendTo('#<?php echo $data->selectorPager; ?>');
<?php 
}
else
if (($data->style=="square") || ($data->style=="round")){?>
while(numPages > curr){
  jQuery('<li><a href="#" class="page_link"></a></li>').appendTo('#<?php echo $data->selectorPager; ?>t');
  curr++;
}
<?php 
}
?>

/* active first link on page numbers navigation */
jQuery('#<?php echo $data->selectorPager; ?> .page_link:first').addClass('active');

/* mask all items in list */
ulElement.children().css('display', 'none');
/* display only items of the first page */
ulElement.children().slice(0, perPage).css('display', 'list-item');

/**
* click on li>a link response
*/
jQuery('#<?php echo $data->selectorPager; ?> li a').click(function(){
	/* previous button link */
	if (jQuery(this).hasClass('page_previous')){
	    previous_pager_<?php echo $data->id; ?>();
	}
	else
	/* next button link */
	if (jQuery(this).hasClass('page_next')){
	    next_pager_<?php echo $data->id; ?>();
	}
	else{
		/* page button link */
	    var clickedPage = jQuery(this).html().valueOf() - 1;
	    goTo(clickedPage,perPage);
	    /* remove active class on previous page link */
		jQuery('#<?php echo $data->selectorPager; ?> .page_link').removeClass('active');
		/* active page number button */
		jQuery(this).parent().addClass('active');
	  }
});

/*
* previous page button click
*/
function previous_pager_<?php echo $data->id; ?>(){
  var goToPage = parseInt(jQuery('#<?php echo $data->selectorPager; ?>').data("curr"));
  goToPage = goToPage -1;
  if(goToPage>=0) {
    goTo(goToPage);
    /* change active page number if pager style = page */
	jQuery('#<?php echo $data->selectorPager; ?> .active').removeClass('active').prev('.page_link').addClass('active');
  }

}

/*
* next page button click
*/
function next_pager_<?php echo $data->id; ?>(){
  var numPages = jQuery('#<?php echo $data->selectorPager; ?>').data("numPages"); 
  var goToPage = jQuery('#<?php echo $data->selectorPager; ?>').data("curr");
  goToPage = parseInt(goToPage) + 1
  if(goToPage<=numPages-1) {
    goTo(goToPage);
    /* change active page number if pager style = page */
	jQuery('#<?php echo $data->selectorPager; ?> .active').removeClass('active').next('.page_link').addClass('active');
    
  }

}

/*
* Go to page
*/
function goTo(page){
    var perPage = jQuery('#<?php echo $data->selectorPager; ?>').data("perPage"); 
    var numPages = jQuery('#<?php echo $data->selectorPager; ?>').data("numPages"); 
    var startAt = page * perPage,
    endOn = startAt + perPage; 
    ulElement.children().css('display','none').slice(startAt, endOn).css('display','block');
    jQuery('#<?php echo $data->selectorPager; ?>').data("curr",page);
    jQuery('.navigation_page_number_<?php echo $data->id; ?>').html(page+1 + '/' + numPages);
}