<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
?>
<?php
$data = $displayData;

require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');

//Notice use .btn to override general border radius
echo $data->selector .'{';
//echo 'background-image:none;';
echo 'text-shadow:none;';

if ($data->height->mode == 'custom')
    echo 'height : '.$data->height->value. 'px;';	    

switch ($data->shape){
	case 'square' :
		echo 'padding : '.$data->padding->default . 'px;';
		break;
	case 'circle' :
		echo 'border-radius: 50%;';
		echo 'padding: '.$data->padding->default . 'px;';
		break;
	case 'ellipse' :
		echo 'border-radius: 50%;';
		echo 'padding : '.$data->padding->top . 'px '.$data->padding->left . 'px;';
		break;
	default :
		if(isset($data->padding->default) && ($data->padding->default != ""))
		    echo 'padding: '.$data->padding->default . 'px;';
		if(isset($data->padding->left) && ($data->padding->left != ""))
		    echo 	'padding-left: '.$data->padding->left . 'px;';
		if(isset($data->padding->top) && ($data->padding->top != ""))
		    echo 	'padding-top: '.$data->padding->top . 'px;';
		if(isset($data->padding->right) && ($data->padding->right != ""))
		    echo 	'padding-right: '.$data->padding->right . 'px;';
		if(isset($data->padding->bottom) && ($data->padding->bottom != ""))
		    echo 	'padding-bottom: '.$data->padding->bottom . 'px;';
		break;
}

echo '}';

if ($data->style == 'bootstrap' || $data->style == 'badge'){
	if($data->style == 'badge'){
		echo $data->selector.'{
		 	text-align: center;
		  	text-shadow: inherit;
			        
		    -webkit-border-radius: 50%;
			   -moz-border-radius: 50%;
				 -o-border-radius: 50%;
			        border-radius: 50%;
		}';
	}
	if($data->theme == 'custom'){
		$btn_custom_hex = CssHelper::getButtonCustomColorHex($data->color);
		
		echo $data->selector.'{
			background-color: '.$btn_custom_hex['normal'].';
		    background-image: linear-gradient(to bottom, '.$btn_custom_hex['light'].', '.$btn_custom_hex['dark'].');
		    background-repeat: repeat-x;
		    border-color: rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.25);
		    color: #fff;
		    text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.25);
		}';
		
		echo $data->selector.':hover,
		 '.$data->selector.':focus
		 '.$data->selector.':active
		 '.$data->selector.'.active
		 '.$data->selector.'.disabled
		 '.$data->selector.'[disabled]{
			color: #ffffff;
			background-color: '.$btn_custom_hex['dark'].';
		}';
	}
}