<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

//Using part class for warning rendering messages
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/part.php');

$data = $displayData;
$data->selector = '#part-'.$data->id;
$html = array();

$part = new LayoutPart($data);

$items = array();
$activeClass = array();
$urls = array();
$hasGlyph = false;


if ($data->content->source == 'database'){
    if ($data->content->source == 'query' && $data->content->query != ''){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	
	$query = $data->content->query;
	if ($data->content->count != '' && $data->content->count != '0')
		$query .= ' LIMIT 0,'.$data->content->count;
	$contentData = NgeDatabaseDriver::loadAssocList($query);
                $rowsCount = count($contentData);
		
                switch ($data->renderer->mode){
                    case 'default' :
			foreach ($contentData as $contentRow) {
			    $htmlRow = '<a href="#">';
			    $firstField = true;
			    foreach ($contentRow as $key=>$value) {
				if ($firstField == true){
				    $htmlRow .= $value ;
				    $firstField = false;
				}
			    }
			    $htmlRow .= '</a>';

			    $items[] = $htmlRow;
			}
                        break;
                    case 'php' :
                        break;
                    case 'template' :
	    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
                        foreach ($contentData as $contentRow) {
	
		if ($data->renderer->template->source == 'html')
			$items[] = SmartyRenderer::renderString($contentRow, $data->renderer->template->html->body);
		else
		if ($data->renderer->template->source == 'file')
			$items[] = SmartyRenderer::render($contentRow, $data->renderer->template->file);		
		}		                        
                        break;                    
                }
    }
}else
    if ($data->content->source == 'custom')     
    {//Custom content : input
    $rowsCount = 		count($data->content->items);
    //$rowsCount = count($data->labels);
	
    for ($i=0;$i <$rowsCount; $i++){
	
	$item = new stdClass();
	$item->label = "";
	$item->link = "";
	
	$activeClass[$i] = '';
	//Url link
	    $url = '';
	    switch ($data->content->items[$i]->link->type){
		case 'url' :		    
		    if ($data->content->items[$i]->link->url != '')
			$item->link = $data->content->items[$i]->link->url;
		    else
			$part->warnings[] = NGE::translate('COM_NGE_WARNING_URLLINK_MISSING') . ' (' . (string) ($i+1) . ')';
		    break;
		case 'article' :
		    if($data->content->items[$i]->link->article != ''){
			$item->link = NGEURL_ROOT . 'index.php?option=com_content&view=article&id='.$data->content->items[$i]->link->article;
			// Set to active if link is in current page
			$jinput = JFactory::getApplication()->input;
			$option = $jinput->get('option','');
			$view = $jinput->get('view','');
			$idarticle = $jinput->get('id','');
			if ($idarticle != ''){
			    if($option=='com_content' && $view=='article') {
				if($data->content->items[$i]->link->article == $idarticle)
				    $activeClass[$i]=' active';
			    }			
			}
		    }
		    else
			$part->warnings[] = NGE::translate('COM_NGE_WARNING_ARTICLELINK_MISSING') . ' (' . (string) ($i+1) . ')';
		    break;
		case 'menu' :
			require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
			$menu = NgeJoomlaMenuDriver::loadItem($data->content->items[$i]->link->menu);
			if (isset($menu)){
			    $link = $menu->route;
			    $item->link = NGE::url('root').'index.php/'.$link;        			    
			}
			else{
			    $part->warnings[] = NGE::translate('COM_NGE_WARNING_MENULINK_MISSING') . ' (' . (string) ($i+1) . ')';
			}				
			// active menu?
			if (NgeJoomlaMenuDriver::isActiveItem($data->content->items[$i]->link->menu))
			    $activeClass[$i]=' active';
		    break;
		case 'image' :
		    $item->link = NGE::url('root').$data->content->items[$i]->link->image;
		    break;
		case 'file' :
		    $item->link = NGE::url('root').$data->content->items[$i]->link->file;
		    break;
		case 'javascript' :
		    $item->link = $data->link_javascripts[$i];
		    break;
		case 'submit' :
		    $item->link = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
		    break;        
		default :
		    $item->link = '';
	    }

	//Only if not in preview mode
	//if (isset($data->rendering->mode) && ($data->rendering->mode != 'preview' && $data->rendering->mode != 'edit')){
	if (isset($data->rendering->mode) && ($data->rendering->mode != 'preview')){
		$data->selector = ".part-".$data->id."-".$i;
		$data->url = $url;
		$data->type = $data->content->items[$i]->link->type;
		$data->target = $data->content->items[$i]->link->target;
		$part->script[] = NGE::layout('nge.parts.navigation.js.buttonbar_js', $data);
	}		
	
	if ($data->rendering->mode == 'edit' && isset($data->content->source) && ($data->content->source == 'custom')){
		$attributesLabel = 'class="button-label custom-label ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Label", "type": "text", "source":"content:content.items.'.$i.'.label"}\'';
		$attributesSublabel = 'class="button-sublabel custom-label ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Sublabel", "type": "text", "source":"content:content.items.'.$i.'.sublabel"}\'';
		$glyphEditableClass = ' ngeelement ngeinlineeditable ngeinlineglyph';
		$glyph_name = (isset($data->content->items[$i]->glyph->name) && $data->content->items[$i]->glyph->name != '') ? $data->content->items[$i]->glyph->name : '';
		$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:content.items.'.$i.'.glyph.name", "value":"'.$glyph_name.'"}\' ';
	}
	else {
		$attributesLabel = 'class="button-label custom-label"';
		$attributesSublabel = 'class="button-sublabel custom-label"';
		$glyphEditableClass = '';
		$glyphEditableAttributes = '';
	}
	$data->content->items[$i]->sublabel = $data->content->items[$i]->sublabel != '' ? '<br><small>'.$data->content->items[$i]->sublabel.'</small>' : '';
	if(isset($data->content->items[$i]->glyph->name) && $data->content->items[$i]->glyph->name !='') {        
	    $hasGlyph = true;
	    if ($data->buttons->style == 'custom'){		
		switch ($data->buttons->glyph->background->shape){
			case 'circle' :
				$glyphBackgroundPadding = $data->buttons->glyph->background->padding;
				$glyphBackgroundColor = $data->buttons->glyph->background->color;
				$glyphVertical =  '<span style="table"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';			
				$glyphLeft =  '<span style="table;display:table-cell; vertical-align:middle; padding-right:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphRight =  '<span style="table;display:table-cell; vertical-align:middle; padding-left:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';
			break;
			case 'square' :
				$glyphBackgroundPadding = $data->buttons->glyph->background->padding;
				$glyphBackgroundColor = $data->buttons->glyph->background->color;
				$glyphVertical =  '<span style="table"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphLeft =  '<span style="table;display:table-cell; vertical-align:middle; padding-right:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphRight =  '<span style="table;display:table-cell; vertical-align:middle; padding-left:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span></span></span>';
			break;
			default :
				$glyphVertical =  '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '"></span>';
				$glyphLeft = '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';							
				$glyphRight = '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-left:8px"></span>';							
		}

		switch ($data->buttons->glyph->position){
			case 'top':				
				$label = '<span '.$attributesLabel.'>'.$data->content->items[$i]->label .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel.'</span>';				
				$item->label = $glyphVertical . '<br/>' . $label;
				break;
			case 'bottom':
				$label = '<span '.$attributesLabel.'>'.$data->content->items[$i]->label .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel.'</span>';
				$item->label = $label . '<br/>' . $glyphVertical;
				break;
			case 'right':
				$label = '<span style="display:table-cell;vertical-align:middle;"><span '.$attributesLabel.'>'.$data->content->items[$i]->label .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel.'</span></span>';
				$item->label = $label . $glyphRight;
				break;
			default :
				$label = '<span style="display:table-cell;vertical-align:middle;"><span '.$attributesLabel.'>'.$data->content->items[$i]->label .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel.'</span></span>';
				$item->label = $glyphLeft . $label;
		}	
	    }
	    else {
		$label = '<span style="display:table-cell"><span '.$attributesLabel.'>'.$data->content->items[$i]->label .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel.'</span></span>';
		$glyphleft = '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->content->items[$i]->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';			
		$item->label = $glyphleft . $label;
	    }
	}
	else
		$item->label = '<span '.$attributesLabel.'>'.$data->content->items[$i]->label  .'</span><span '.$attributesSublabel.'>'.$data->content->items[$i]->sublabel .'</span>';	
	
	$items[] = $item;	
    }
		
}
else{
        //Loading plugin contents
    $dataSourceFilename = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $data->content->source) . '/content.php';
    if (file_exists($dataSourceFilename)){			
	require_once $dataSourceFilename;
	$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $data->content->source))) . 'Content';
	$source = str_replace('.', '/', $data->content->source);
	//WARNING : $data contains properties from the config screen. 
	//All content properties are not known because they can come from external content plugins
	//So we transmit unchanged all these properties as parameter of the loadList method (params)
	$items = $className::getListData($data);
    }
}

//Button group attributes
	$class = array();
	$class[] = "part";	
	
        //Part display options
            $part->style[] = NGE::layout('nge.parts.parts.display_style', $data);
            $class[] = NGE::layout('nge.parts.parts.display_class', $data);
	$part->script[] = NGE::layout('nge.parts.parts.display_script', $data);

	    
            $attributes = array();
	$attributes[] = ' id="part-'.$data->id.'"';
	$attributes[] = ' data-part="'.$data->name.'"';
	$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
	$attributes[] = ' class="'.implode(' ', $class).'"';
	
	//Buttons attributes
	$btnclass = array();	
	$btnclass[] = 'btn full-width';
/*	$btnclass[] = $data->buttons->font->style == 'class' ? $data->buttons->font->class : '';
	$btnclass[] = $data->buttons->size != '' ? ' '.$data->buttons->size : '';
	$btnclass[] = $data->buttons->theme != '' ? ' btn-'.$data->buttons->theme : ''; //Default for bootstrap3
*/		
	if(isset($data->buttons->bootstrap->size) && ($data->buttons->bootstrap->size != "btn-default")){
		$btnclass[] = $data->buttons->bootstrap->size != '' ? ' '.$data->buttons->bootstrap->size : '';
	}
	if($data->buttons->style == "bootstrap"){
		$btnclass[] = $data->buttons->bootstrap->theme != '' ? ' btn-'.$data->buttons->bootstrap->theme : '';
	}
	$btnclass[] = $data->buttons->style == 'class' ? $data->buttons->class : '';
	
	if ($data->rendering->mode == 'edit'){
	    $btnclass[] = 'ngeelement';
	    $btnclass[] = 'ngeelement-image_search';
	    $btnclass[] = 'ngeelement-link_search';
	}	
	
	//Modal box
	if(isset($popover_content)){
		$config = new stdClass();
		$config->id = 'modal-'.$data->id;
		//$config->title = $part->part;
		$config->header = new stdClass();
		$config->header->display = True;
		$config->header->label = 'Overview';
		$config->header->glyph = new StdClass();
		$config->header->glyph->name = 'icon-book';
		
		$config->body = $popover_content;
		$config->width="90%";
		$config->confirmbutton = array("show"=>"false");
		$config->cancelbutton = array("label"=>"Close");
		echo NGE::layout('nge.parts.navigation.modal', $config);
	}

	
//Cache
if ($data->cache->css != ''){
    $part->style[] = $data->cache->css;
}
else {
	
	
	//General CSS
	$dataBar = $data->bar;
	$dataBar->selector = '#part-'.$data->id;
	$part->style[] = NGE::layout('nge.parts.navigation.css.buttonbar_css', $dataBar);
	
	//Buttons
	if($data->buttons->style == 'custom'){
		$dataButtons = $data->buttons;
		$dataButtons->selector = '#part-'.$data->id . ' >div';
		$dataButtons->orientation = $data->bar->orientation;
		$dataButtons->count = count($data->content->items);
		$part->style[] = NGE::layout('nge.parts.navigation.css.buttons_css', $dataButtons);
	
		//List Main CSS (padding)
		/*
		$dataButtons = $data->buttons->padding;
		$dataButtons->selector = '#part-'.$data->id.' >div';
		$part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataButtons);
		*/
		// Font CSS
		if ($data->buttons->font->style != "default") {
		    $dataFont = $data->buttons->font;
		    $dataFont->selector = '#part-'.$data->id.' a';
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
		}
	
		//Border
		if ($data->buttons->border->style != "default") {
		    $dataBorder = $data->buttons->border;
		    $dataBorder->selector = '#part-'.$data->id.' .btn';
		    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
		}
		
		//Button CSS. After border to override border-radius (circle)
		$dataButtons = $data->buttons;
		$dataButtons->selector = '#part-'.$data->id . ' .btn';
		$part->style[] = NGE::layout('nge.parts.navigation.css.button_css', $dataButtons);

		
		//Background CSS		
		if ($data->buttons->background->style != "default") {
		    //Reset current template styles
		    $part->style[] = '#part-'.$data->id.' .btn{background-color: transparent;background-image:none;}';
		    //Apply custom background
		    $dataBackground = $data->buttons->background;
		    $dataBackground->selector = '#part-'.$data->id.' .btn';
		    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
		}
	
		//Shadow
		if($data->buttons->shadow->style != 'none'){
		    $dataShadow = $data->buttons->shadow;
		    $dataShadow->selector = '#part-'.$data->id.' .btn';
		    $part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
		}
		
		// label hover css if case
/*		if($data->label->trigger=='hover') {
			$part->style[] = 	'#part-'.$data->id . ' .button-label {visibility : hidden;}';	
			$part->style[] = 	'#part-'.$data->id . ':hover .button-label {visibility : visible;}';	
		}
	
		// sublabel hover css if case
		if($data->sublabel->trigger=='hover') {
			$part->style[] = 	'#part-'.$data->id . ' .button-sublabel {visibility : hidden;}';	
			$part->style[] = 	'#part-'.$data->id . ':hover .button-sublabel {visibility : visible;}';	
		}
*/					
	}
	//Icomoon CSS
	if (($hasGlyph == true) && (isset($data->buttons->glyph))){
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
		$dataButtonsGlyph = $data->buttons->glyph;
		$dataButtonsGlyph->id = $data->id;
		//$dataHeaderIcomoon->position = "unknown";
		//$dataHeaderIcomoon->color_hover = null; //Because is already define above
		$dataButtonsGlyph->selector = '#part-'.$data->id.' span.icomoon';
		$dataButtonsGlyph->selector_hover = '#part-'.$data->id.' .btn:hover .icomoon';
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataButtonsGlyph);
	}

}//if cache
	
/******** JS ********************************************************************/
//Cache
if ($data->cache->js != ''){
    $part->script[] = $data->cache->js;
}
else {
    	if($data->buttons->style == 'custom'){		
		//Height in javascript
		switch ($data->buttons->shape) {
			case 'square' :
			case 'circle' :
				$part->script[] = '
				var $selector = jQuery("#part-' . $data->id . ' .btn");
				var buttonWidth = 0;
				var buttonHeight = 0;
				$selector.each (function(){
				    buttonWidth = Math.max(buttonWidth, $selector.outerWidth());
				    buttonHeight = Math.max(buttonHeight, $selector.outerHeight());
				    });
    				if (buttonWidth > buttonHeight){
				    $selector.outerWidth(buttonWidth);
				    $selector.outerHeight(buttonWidth);
				    }
				else{    
				    $selector.outerWidth(buttonHeight);
				    $selector.outerHeight(buttonHeight);
				    }
				';
			break;
		}		
	}
    
} //if cache	
	
//Writing cache    
/*if (($data->cache->css == '' && count($style) >0) || ($data->cache->js == '' && count($script) >0)){
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($style), implode($script));    		
}
*/	
	
    //Buttons list is editable if custom and edit mode
    $addableAttributes = '';
    $class_list = '';
    if ($data->rendering->mode == 'edit'){
	//Removable and sortable items
	if (isset($data->content->source) && (in_array($data->content->source, array('custom', 'joomla.articles', 'joomla.menu')))){
	    $class_list .= ' ngeaddableitems ngeitemsremovable';
	    if ($data->content->source == 'custom' || ($data->content->source == 'joomla.articles' && $data->content->articles->ordering == 'ordering') || ($data->content->source == 'joomla.menu')){
		$class_list .= ' ngeitemssortable';
	    }
	    $addableAttributes .= 'data-nge=\'{"itemsmode": "link_' . str_replace('.', '_', $data->content->source) . '", "itemstype": "list"}\'';
	}	
    }
    
    if ($data->bar->orientation == "vertical"){
        $class_list = "btn-group btn-group-vertical";
    }
    
    $addableAttributes .= 'class="'.$class_list.'"';

$html[] =  '<div '.implode($attributes).'>';
$html[] = '<div '.$addableAttributes.'>';

for ($i=0;$i <count($items);$i++){

	$btnattributes = array();
	$btnattributes[] = 'role="button"';
	//$btnattributes[] = ' class="'.implode(' ',$btnclass).' '.$id_current_button . $activeClass[$i] . '"';
	$active = (isset($items[$i]->active) && ($items[$i]->active ==true)) ? ' active' : '';
	$btnattributes[] = ' class="' . implode(' ', $btnclass) . ' ' . $active . '"';
	if (isset($items[$i]->color) && ($items[$i]->color != ''))
	    $btnattributes[] = ' style="background-color:' . $items[$i]->color . '"';
	$btnattributes[] = ' id="part-' . $data->id . '-' . $i . '"';
	//$html[] = '<div ' . implode($btnattributes) . '><span class="button_content">'.$items[$i]->title.'</span></div>';
	if (isset($data->rendering->mode) && ($data->rendering->mode != 'preview'))
	    $html[] = '<div ' . implode($btnattributes) . '><a href="'.$items[$i]->link.'">'.$items[$i]->label.'</a></div>';
	else
	    $html[] = '<div ' . implode($btnattributes) . '><a href="#">'.$items[$i]->label.'</a></div>';
	//$html[] = '<a '.implode($btnattributes).'>'.$items[$i].'</a>';
}

//Addable
    if (isset($data->rendering->mode) && ($data->rendering->mode == 'edit'))
	$html[] = '<div role="button" class="btn ngeaddableitem"> + </div>';

$html[] = '</div>';
$html[] = $part->renderScripts();
$html[] = '</div>';

echo $part->renderMessages();
echo implode($html);