<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

//Using part class for warning rendering messages
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/part.php');

$data = $displayData;

$html = array();

$part = new LayoutPart($data);

//Part usage is unique or multiple (in data reports)
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $data->selector = '.part-'.$data->id;
else
    $data->selector = '#part-'.$data->id;

//Label content
if ($data->label->source == 'html') {
	$label = $data->label->html;
}else if($data->label->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$label = UrlDriver::getContents($data->label->url);
/*}else if($data->label->label->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$label = NgeDatabaseDriver::loadSingle($data->label->query);
 */
}else if ($data->label->source == 'data') {
    $label = $data->label->data != '' ? '{{item.' . $data->label->data . '}}' : '';
}
else
	$label = $data->label->html;

//Sublabel content
if ($data->sublabel->source == 'html') {
	$sublabel = $data->sublabel->html;
}else if($data->sublabel->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$sublabel = UrlDriver::getContents($data->sublabel->url);
	/*
}else if($data->label->sublabel->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$sublabel = NgeDatabaseDriver::loadSingle($data->sublabel->query);
	 * 
	 */
}else if ($data->sublabel->source == 'data') {
	$sublabel = $data->sublabel->data != '' ? '{{item.' . $data->sublabel->data . '}}' : '';
}
else 
	$sublabel = $data->sublabel->html;

//Tooltip
if ($data->tooltip->trigger != "none"){
	$tooltip_content = '';
	if ($data->tooltip->source == 'html'){
		$tooltip_content = $data->tooltip->html;
	}else if ($data->tooltip->source == 'url'){
		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
		$tooltip_content = UrlDriver::getContents($data->tooltip->url);
	}else if ($data->tooltip->source == 'query') {
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
		$tooltip_content = NgeDatabaseDriver::loadSingle($data->tooltip->query);
	}else if ($data->tooltip->source == 'article') {
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$article = NgeJoomlaArticleDriver::load($data->tooltip->article);
		$tooltip_content = $article->introtext;
	}else if ($data->tooltip->source == 'file') {
		require_once (NGEPATH_HELPERS . '/data/file/filedriver.php');
		$tooltip_content = NgeFileDriver::getContents($data->tooltip->file);
	}
}

	//Attributes
	$class = array();
	$class[] = "part";
	$class[] = 'btn';
	//If part usage is multiple (in data reports), using class instead of unique selector
	if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	    $class[] = 'part-'.$data->id;
	
	if(isset($data->button->bootstrap->size) && ($data->button->bootstrap->size != "btn-default")){
		$class[] = $data->button->bootstrap->size != '' ? ' '.$data->button->bootstrap->size : '';
	}
	if($data->button->style == "bootstrap"){
		$class[] = $data->button->bootstrap->theme != '' ? ' btn-'.$data->button->bootstrap->theme : '';
	}
	$class[] = $data->button->style == 'class' ? $data->button->class : '';
			

        //Part display options
            $part->style[] = NGE::layout('nge.parts.parts.display_style', $data);
            $class[] = NGE::layout('nge.parts.parts.display_class', $data);
	$part->script[] = NGE::layout('nge.parts.parts.display_script', $data);

	$attributes = array();
	$attributes[] = ' id="part-'.$data->id.'"';
	$attributes[] = ' data-part="'.$data->name.'"';
	$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
	$attributes[] = ' type="button"';
	$attributes[] = ' class="'.implode(' ', $class).'"';
	
	//Edit mode, inline editing enabled
	if ($data->rendering->mode == 'edit'){
		$attributesLabel = 'class="button-label ngeelement ngeinlineeditable ngeinlinetext"  data-nge = \'{"title": "Label", "type": "text", "source":"content:label.html"}\'';
		$attributesSublabel = 'class="button-sublabel ngeinlineeditable ngeinlinetext"  data-nge = \'{"title": "Sublabel", "type": "text", "source":"content:sublabel.html"}\'';
		$glyphEditableClass = ' ngeelement ngeinlineeditable ngeinlineglyph';
		$glyph_name = (isset($data->glyph->name) && $data->glyph->name != '') ? $data->glyph->name : '';
		$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:glyph.name", "value":"'.$glyph_name.'"}\' ';
	}
	else {
		$attributesLabel = 'class="button-label"';
		$attributesSublabel = 'class="button-sublabel"';
		$glyphEditableClass = '';
		$glyphEditableAttributes = '';
	}		

	$sublabel = $sublabel != '' ? '<br><small>'.$sublabel.'</small>' : '';
   
    if(isset($data->glyph->name) && $data->glyph->name!='') {        
	if ($data->button->style == 'custom'){
	    	switch ($data->glyph->background->shape){
			case 'circle' :
				$glyphBackgroundPadding = $data->glyph->background->padding;
				$glyphBackgroundColor = $data->glyph->background->color;
				$glyphVertical =  '<span style="table"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphLeft =  '<span style="table;display:table-cell; vertical-align:middle; padding-right:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphRight =  '<span style="table;display:table-cell; vertical-align:middle; padding-left:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;border-radius:50%;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
			break;
			case 'square' :
				$glyphBackgroundPadding = $data->glyph->background->padding;
				$glyphBackgroundColor = $data->glyph->background->color;
				$glyphVertical =  '<span style="table"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphLeft =  '<span style="table;display:table-cell; vertical-align:middle; padding-right:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
				$glyphRight =  '<span style="table;display:table-cell; vertical-align:middle; padding-left:8px"><span style="border:transparent;background-color:'.$glyphBackgroundColor.';display:table-cell;padding:'.$glyphBackgroundPadding.'px;"><span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span></span></span>';
			break;
			default :
				$glyphVertical =  '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '"></span>';
				$glyphLeft = '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';
				$glyphRight = '<span ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-left:8px"></span>';
		}

		switch ($data->glyph->position){
			case 'top':
				$label = '<span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span>';
				$content = $glyphVertical . '<br/>' . $label;
				break;
			case 'bottom':
				$label = '<span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span>';
				$content = $label . '<br/>' . $glyphVertical;
				break;
			case 'right':
				$label = '<span style="display:table-cell;vertical-align:middle;text-align:' . $data->button->align . '"><span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span></span>';
				$content = $label . $glyphRight;
				break;
			default :
				$label = '<span style="display:table-cell;vertical-align:middle;text-align:' . $data->button->align . '"><span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span></span>';
				$content = $glyphLeft . $label;
		}	
	}
	else {
		$label = '<span style="display:table-cell"><span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span></span>';
		$glyphleft = '<span  ' . $glyphEditableAttributes . ' class="icomoon '.$data->glyph->name . $glyphEditableClass . '" style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';			
		$content = $glyphleft . $label;		
	}
    }
	else
		$content = '<span '.$attributesLabel.'>'.$label .'</span><span '.$attributesSublabel.'>'.$sublabel.'</span>';
	

	//Url link
	$url = '';
	if (isset($data->link->type)){
	    switch ($data->link->type){
		case 'url' :
		    if ($data->link->url != '')
			$url = $data->link->url;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_URLLINK_MISSING';
		    break;
		case 'article' :
		    if ($data->link->article != '')
			$url = NGEURL_ROOT . 'index.php?option=com_content&view=article&id='.$data->link->article;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_ARTICLELINK_MISSING';
		    break;
		case 'file' : 
		    $url = NGE::url('root').$data->link->file;
		    break;		
		case 'menu' :
		    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
		    $menu = NgeJoomlaMenuDriver::loadItem($data->link->menu);
		    if (isset($menu)){
			$link = $menu->route;
			$url = NGE::url('root').'index.php/'.$link;        			    
		    }
		    else{
			$part->warnings[] = 'COM_NGE_WARNING_MENULINK_MISSING';		    }	
		    break;
		case 'javascript' :
		    $url = $data->link->javascript;		    
		    break;
		
	    }
	} 

	//Url link for MODAL
	if ($data->link->target == 'modal'){
		if ($data->link->type == 'url'){
			require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
			$modal_content = UrlDriver::getContents($data->content->link_url);
		}else if ($data->link->type == 'menu') {
			require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
			$modal_content = UrlDriver::getContents($url);
		}else if ($data->link->type == 'query') {
			require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
			$modal_content = NgeDatabaseDriver::loadSingle($data->link->query);
		}
		else if ($data->content->link_type == 'article') {
			require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
			$article = NgeJoomlaArticleDriver::load($data->link->article);
			$modal_content = $article->introtext;
		}
	}

	//Modal box
	if(isset($modal_content)){
		$config = new stdClass();
		$config->id = 'modal-'.$data->id;
		//$config->title = $part->part;
		$config->header = new stdClass();
		$config->header->display = True;
		$config->header->label = 'Overview';
		$config->header->glyph = new StdClass();
		$config->header->glyph->name = 'icon-book';
		$config->body = $modal_content;
		$config->width="90%";
		$config->confirmbutton = array("show"=>"false");
		$config->cancelbutton = array("label"=>"Close");
		$html[] = NGE::layout('nge.parts.navigation.modal', $config);
	}
	

	    //Popover
	    if($data->popover->trigger != "none"){
	    	$popover_content = '';
	    	if ($data->popover->source == 'html')
	    		$popover_content = $data->popover->html;
	    	else if ($data->popover->source == 'url'){
	    		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	    		$popover_content = UrlDriver::getContents($data->popover->url);
	    	}
	    	else if ($data->popover->source == 'query') {
	    		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	    		$popover_content = NgeDatabaseDriver::loadSingle($data->popover->query);
	    	}
	    	else if ($data->popover->source == 'article') {
	    		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	    		$article = NgeJoomlaArticleDriver::load($data->popover->article);
	    		$popover_content = $article->introtext;
	    	}
	    	else
	    		if ($data->popover->source == 'module') {
	    			require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	    			$popover_content = NgeJoomlaModuleDriver::load($data->popover->module);
	    		}
	    	else
	    		if($data->popover->source == 'image'){
	    		if($data->popover->image == ""){
	    			$data->popover->image = "components/com_nge/assets/images/default_bigthumb.png";
	    		}
	    		$popover_content = '<img src="'.$data->popover->image.'" />';
	    	}
	    }else{
			$popover_content = "";
		}
	    
	    if ($popover_content != "" || $data->popover->caption!=""){
	    	$dataPopover = $data->popover;
	    	$dataPopover->selector = $data->selector;
	    	$dataPopover->id = $data->id;
	    	$dataPopover->content = $popover_content;
		$dataPopover->rendering_mode = $data->rendering->mode;
	    	$htmlPopover = NGE::layout('nge.parts.text.html.popover_html', $dataPopover);
	    	$classPopover = ' trigger';	    
	    }else{
	    	$htmlPopover = '';
	    	$classPopover = '';
	    }
	
	
/******** CSS *******************************************************************/

//Cache
if ($data->cache->css != ''){
    $part->style[] = $data->cache->css;
}
else {
	
	//Loading glyph library if needed
	if ($data->glyph->name != "")
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
    
	if($data->button->style == 'custom'){
		
		// label hover css if case
		if($data->label->trigger=='hover') {
			$part->style[] = 	$data->selector . ' .button-label {visibility : hidden;}';	
			$part->style[] = 	$data->selector . ':hover .button-label {visibility : visible;}';	
		}
	
		// sublabel hover css if case
		if($data->sublabel->trigger=='hover') {
			$part->style[] = 	$data->selector . ' .button-sublabel {visibility : hidden;}';	
			$part->style[] = 	$data->selector . ':hover .button-sublabel {visibility : visible;}';	
		}
				
		// Font CSS
		if ($data->label->font->style != "default") {
		    $dataFont = $data->label->font;
		    $dataFont->selector = $data->selector;
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
		}
		
		//Border
		if ($data->button->border->style != "default") {
		    $dataBorder = $data->button->border;
		    $dataBorder->selector = $data->selector . '.btn';
		    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
		}
		
		//Background CSS		
		if ($data->button->background->style != "default") {
		    //Reset current template styles
		    $part->style[] = $data->selector.'.btn{background-color: transparent; background-image:none;}';
		    //Apply custom background
		    $dataBackground = $data->button->background;
		    $dataBackground->selector = $data->selector. '.btn';
		    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
		}
		
		//Button CSS. After border to override border-radius (circle)
		$dataButton = $data->button;
		$dataButton->selector = $data->selector;
		$part->style[] = NGE::layout('nge.parts.navigation.css.button_css', $dataButton);

		
		//Header Icomoon CSS
		if ($data->glyph->name != ""){
		    $dataGlyph = $data->glyph;
		    $dataGlyph->id = $data->id;
		    $dataGlyph->selector = $data->selector . ' .icomoon';
		    $part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataGlyph);
		}	
	
		//Shadow
		if($data->button->shadow->style != 'none'){
		    $dataShadow = $data->button->shadow;
		    $dataShadow->selector = $data->selector;
		    $part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
		}
		
		// button content align, always, even if left
		if( isset($data->button->align)){
			$databuttonalign = $data->button;
			$databuttonalign->selector = $data->selector . ' .button_content';
		    $part->style[] = NGE::layout('nge.parts.navigation.css.button_align_css', $databuttonalign);
		}
	}
	
	//Transform
	   /* if (isset($data->transform) && $data->transform->trigger != 'none') {
		$dataTransform = $data->transform;
		$dataTransform->selector = $data->selector;
		$part->style[] = NGE::layout('nge.parts.panels.css.animation_transform_css', $dataTransform);
	    }*/
	    
	    //Effects
	if (isset($data->effects) && count($data->effects) > 0){
	    foreach ($data->effects as $effect){
		$dataEffect = $effect;
		$dataEffect->selector = $data->selector;
		if ($effect->type == 'background')
		    $part->style[] = NGE::layout('nge.parts.parts.effects.css.effects_background_css', $dataEffect);
	    }
	}


	    if ($popover_content != "" || $data->popover->caption!=""){
	    	$dataPopover = $data->popover;
	    	$dataPopover->selector = $data->selector;
	    	$dataPopover->id = $data->id;
		$dataPopover->rendering_mode = $data->rendering->mode;
	    
	    	$part->style[] = NGE::layout('nge.parts.text.css.popover_css', $dataPopover);
	    
	    	//Popover header
	    	//Header Font CSS
	    	if($data->popover->header->font->style == 'custom'){
	    		$dataHeaderFont = $data->popover->header->font;
	    		$dataHeaderFont->selector = '#popover-'.$data->id.' .popover > .popover-title';
	    		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
	    	}
	    
	    	//Header Background CSS
	    	if ($data->popover->header->background->style != "default") {
	    		$dataHeaderBackground = $data->popover->header->background;
	    		$dataHeaderBackground->selector = '#popover-'.$data->id.' .popover > .popover-title';
	    		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);
	    	}
	    
	    	//Popover border
	    	if ($data->popover->border->style != "default") {
	    		$dataGeneralBorder = $data->popover->border;
	    		$dataGeneralBorder->selector = '#popover-'.$data->id.' .popover';
	    		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataGeneralBorder);
	    	}
	    
	    	//Background
	    	if ($data->popover->background->style != "default") {
	    		$dataPanelBackground = $data->popover->background;
	    		$dataPanelBackground->selector =  '#popover-'.$data->id.' .popover';
	    		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataPanelBackground);
	    	}
	    }
	    
	
}//if cache

/******** JS ********************************************************************/

//Cache
if ($data->cache->js != ''){
    $part->script[] = $data->cache->js;
}
else {

    	if($data->button->style == 'custom'){		
		//Height in javascript
		switch ($data->button->shape) {
			case 'square' :
			case 'circle' :
				$part->script[] = '
				var selector = jQuery("' . $data->selector . '");
				var buttonWidth = selector.outerWidth();
				var buttonHeight = selector.outerHeight();
				if (buttonWidth > buttonHeight)
				    selector.outerHeight(buttonWidth);
				else    
				    selector.outerWidth(buttonHeight);
				';
			break;
		}
	}

    
    	//Only if not in preview mode
	if (isset($data->rendering->mode) && ($data->rendering->mode != 'preview')){
		$data->url = $url;
		$data->type = $data->link->type;
		$data->target = $data->link->target;
		$part->script[] = NGE::layout('nge.parts.panels.js.button_js', $data);
	}
	
	//BoostrapColor JS
	if ($data->button->style == 'outline' || $data->button->style == 'transparent'){
		$dataBootstrapColor = $data->button;
		$dataBootstrapColor->selector = $data->selector;
		$dataBootstrapColor->id = $data->id;
		$part->script[] = NGE::layout('nge.parts.navigation.js.getBootstrapColor_js', $dataBootstrapColor);
	}
	
	if (($data->tooltip->trigger != "none") && ($tooltip_content != "")){
		$data->tooltip_content = $tooltip_content;
		$part->style[] = NGE::layout('nge.parts.text.css.tooltip_css', $data);
		$part->script[] = NGE::layout('nge.parts.text.js.tooltip_js', $data);
	}
	
	//Animate
/*	if(isset($data->effect) && ($data->effect->trigger != "none") && ($data->effect->style != "")){
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate_teatis.css');
		$dataAnimate = $data->effect;
		$dataAnimate->selector = '#part-'.$data->id;
		$dataAnimate->id = $data->id;
		$part->style[] = NGE::layout('nge.parts.panels.css.animation_css', $dataAnimate);
		$part->script[] = NGE::layout('nge.parts.panels.js.animation_js', $dataAnimate);
	}*/

	
	    if ($popover_content != "" || $data->popover->caption!=""){
	    	$dataPopover = $data->popover;
	    	$dataPopover->selector = $data->selector;
	    	$dataPopover->id = $data->id;
		$dataPopover->rendering_mode = $data->rendering->mode;
	    	    
	    	$part->script[] = NGE::layout('nge.parts.text.js.popover_js', $dataPopover);
	    }
	
    
} //if cache	
	
//Writing cache    
/*if (($data->cache->css == '' && count($style) >0) || ($data->cache->js == '' && count($script) >0)){
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($style), implode($script));    		
}*/
	//One more div, because vertical-align in table-cell can not work with float property (float for general part align)
	if (($data->button->height->mode == 'custom') || ($data->button->shape == 'square') || ($data->button->shape == 'circle')){
		$maindivStyle = ' style="display:table-cell;vertical-align:' . $data->button->valign . ';';
		
		//If height defined, we apply it
		if ($data->button->height->mode == 'custom'){
		    if (($data->button->shape != 'square') && ($data->button->shape != 'circle'))
			$maindivStyle .= 'height:' . intval($data->button->height->value - $data->button->padding->top - $data->button->padding->bottom) . 'px;';
		    else
			$maindivStyle .= 'height:' . intval($data->button->height->value) . 'px;';
		}
		$maindivStyle .= '"';
	}
	else
	    $maindivStyle = '';
	
	    $html[] =  '<div '.implode($attributes).'><div'.$maindivStyle.'><div class="button_content'.$classPopover.'">'.$content.'</div>';
	    $html[] = $htmlPopover;
	    $html[] = $part->renderScripts();
	    $html[] = '</div></div>';

echo $part->renderMessages();
echo implode($html);