<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

$data = 			$displayData;
//Content

$attributes = array();
$attributesiframe = array();
$warnings = array();
$errorMessage = '';
$iframeContent = '';
switch ($data->content->source){
	case 'youtube' :
		$attributesiframe[] = 'height="100%"';
		$attributesiframe[] = 'width="100%"'; 
		$attributesiframe[] = 'frameborder="0"'; 
		$attributesiframe[] = 'allowfullscreen=""';
		if (in_array(substr($data->content->reference, 0, 4), array('http', 'www.', 'yout')))
			$warnings[] = NGE::translate('COM_NGE_WARNING_VIDEO_YOUTUBE_CODE');
		/*else
			$attributesiframe[] = 'src="//www.youtube.com/embed/'.$data->content->reference.'"';*/
		break;
	case 'vimeo' :
		$attributesiframe[] = 'height="300"';
		$attributesiframe[] = 'frameborder="0"';
		$attributesiframe[] = 'allowfullscreen=""';
		$attributesiframe[] = 'webkitallowfullscreen=""';
		$attributesiframe[] = 'mozallowfullscreen=""';
		if (in_array(substr($data->content->reference, 0, 4), array('http', 'www.', 'vime')))
			$warnings[] = NGE::translate('COM_NGE_WARNING_VIDEO_VIMEO_CODE');
		else
			$attributesiframe[] = 'src="http://player.vimeo.com/video/'.$data->content->reference.'"';
		break;
	case  'dailymotion' :
		$attributesiframe[] = 'height="270"';
		$attributesiframe[] = 'frameborder="0"';
		$attributesiframe[] = 'allowfullscreen=""';				
		if (in_array(substr($data->content->reference, 0, 4), array('http', 'www.')))
			$warnings[] = NGE::translate('COM_NGE_WARNING_VIDEO_DAILYMOTION_CODE');
		else
		$attributesiframe[] = 'src="http://www.dailymotion.com/embed/video/'.$data->content->reference.'"';
		break;
	case 'file':
		if (isset($data->content->reference)){
			$attributes[] = 'src="'.$data->content->reference.'" style="width:100%;height:100%;" width="100%" height="100%"';
		}

}	
	//print_r($data);
 $options = array();
 if (isset($data->playing)){
     $options[] = 'volume : ' . $data->playing->volume;
     if ($data->playing->auto == true)
	$options[] = 'autoplay : true';
 }
 else
     $options[] = 'volume : 8';

 if (isset($data->controls)){
     if ($data->controls->display == 'always')
	$options[] = 'hideControls : false';     
 }
$plyrOptions = 'data-plyr=\'{ ' . implode(',', $options) . ' }\' ';
//echo $plyrOptions;
//$plyrOptions = 'data-plyr=\'{ title: "testing" }\'';
//$plyrOptions = '';

if ($data->content->source == 'file'){
	$videoContent = '<video '. implode(' ', $attributes) . '>';
	$videoContent .= '</video>';
}
else
if ($data->content->source == 'youtube'){
	$videoContent = '<div style="position:relative" id="part-' . $data->id . '-video" data-type="youtube" ' . $plyrOptions . 'data-video-id="' . $data->content->reference . '" class="js-player">';
	if (($data->playing->auto == false) || ($data->rendering->mode == 'fastview')){
	    //Lazy loading
	    if (($data->content->preview->mode == "custom") && ($data->content->preview->image != ""))
		$videoContent .= '<img src="' . NGEURL_ROOT . '/' . $data->content->preview->image . '" />';
	    else
		$videoContent .= '<img src="https://img.youtube.com/vi/'.$data->content->reference.'/maxresdefault.jpg" />';
	    $videoContent .= '<button style="display:block;" type="button" data-plyr="play" class="plyr__play-large" aria-label="Play, Daniel Bernard"><svg id="plyr-play" viewBox="0 0 18 18" width="100%" height="100%"><path d="M15.562 8.1L3.87.225C3.052-.337 2 .225 2 1.125v15.75c0 .9 1.052 1.462 1.87.9L15.563 9.9c.584-.45.584-1.35 0-1.8z"></path></svg><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#plyr-play"></use></svg><span class="plyr__sr-only">Play</span></button>';
	}
	$videoContent .= '</div>';
}
else
if ($data->content->source == 'vimeo'){
	$videoContent = '<div data-type="vimeo" ' . $plyrOptions . 'data-video-id="' . $data->content->reference . '" class="js-player"></div>';
}
else {
	$videoContent = '	 <div class="videowrapper">';
	$videoContent .= '        <iframe '.implode(' ', $attributesiframe).'></iframe>';
	$videoContent .= '  </div>';
	
}

//Rendering
if ($errorMessage != ''){
    if  ($data->rendering->mode == 'preview')
	echo  '<div class="alert alert-error"><b>Warning</b>, '.$errorMessage.'</div>';
}
if (count($warnings) >0){
foreach ($warnings as $warning){
                    echo '<div class="ngePreviewWarning">
		    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <h4><span class="icomoon icomoon-warning"></span>&nbsp;' . NGE::translate('COM_NGE_WARNING').'</h4>'.
		    $warning. '</div>';
		}

}
else	
    echo $videoContent;
