

<script src="https://code.jquery.com/jquery-3.1.1.min.js"></script>
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/maps/modules/map.js"></script>
<script src="https://code.highcharts.com/maps/modules/data.js"></script>
<script src="https://code.highcharts.com/mapdata/countries/us/us-all.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>

<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');

$data = $displayData;
$part = new LayoutPanel($data);
/*    $part->script[] = '
jQuery(function () {
    ngetools.loadScripts(';
        $part->script[] = '[
            {
                path : "'.NGEURL_MEDIA.'highmaps/modules/maps.js",
                path : "'.NGEURL_MEDIA.'highmaps/modules/data.js",
                path : "https://code.highcharts.com/mapdata/countries/us/us-all.js",		
	path : "https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js",
                requires : [
                    {path : "'.NGEURL_MEDIA.'nge/ngehighcharts.js"}';
                $part->script[] = ']
            }
        ], function(){
            loadMap();
        }
    );
});';
*/

// Load the data from a Google Spreadsheet
// https://docs.google.com/a/highsoft.com/spreadsheet/pub?hl=en_GB&hl=en_GB&key=0AoIaUO7wH1HwdDFXSlpjN2J4aGg5MkVHWVhsYmtyVWc&output=html
		
    $part->script[] = 
"jQuery(function () {
		
Highcharts.data({

    googleSpreadsheetKey: '0AoIaUO7wH1HwdDFXSlpjN2J4aGg5MkVHWVhsYmtyVWc',

    // custom handler for columns
    parsed: function (columns) {

        /**
         * Event handler for clicking points. Use jQuery UI to pop up
         * a pie chart showing the details for each state.
         */
        function pointClick() {
            var row = this.options.row,
                div = jQuery('<div></div>')
                    .dialog({
                        title: this.name,
                        width: 400,
                        height: 300
                    });

            window.chart = new Highcharts.Chart({
                chart: {
                    renderTo: div[0],
                    type: 'pie',
                    width: 370,
                    height: 240
                },
                title: {
                    text: null
                },
                series: [{
                    name: 'Votes',
                    data: [{
                        name: 'Obama',
                        color: '#89A4CC',
                        y: parseInt(columns[3][row], 10)
                    }, {
                        name: 'Romney',
                        color: '#F55F53',
                        y: parseInt(columns[4][row], 10)
                    }],
                    dataLabels: {
                        format: '<b>{point.name}</b> {point.percentage:.1f}%'
                    }
                }]
            });
        }

        // Make the columns easier to read

        var keys = columns[0],
            names = columns[1],
            percent = columns[7],
            // Build the chart options
            options = {
                chart: {
                    renderTo: 'part-" . $data->id . "-body',
                    type: 'map',
                    borderWidth: 1
                },

                title: {
                    text: 'US presidential election 2012 results'
                },
                subtitle: {
                    text: 'Source: <a href=\"http://en.wikipedia.org/wiki/United_States_presidential_election,' +
                        '_2012\">Wikipedia</a>'
                },

                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    x: -100,
                    y: 70,
                    floating: true,
                    layout: 'vertical',
                    valueDecimals: 0,
                    backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || 'rgba(255, 255, 255, 0.85)'
                },

                mapNavigation: {
                    enabled: true,
                    enableButtons: false
                },

                colorAxis: {

                    dataClasses: [{
                        from: -100,
                        to: 0,
                        color: '#F55F53',
                        name: 'Romney'
                    }, {
                        from: 0,
                        to: 100,
                        color: '#89A4CC',
                        name: 'Obama'
                    }]
                },

                series: [{
                    data: [],
                    mapData: Highcharts.maps['countries/us/us-all'],
                    joinBy: 'postal-code',
                    dataLabels: {
                        enabled: true,
                        color: '#FFFFFF',
                        format: '{point.postal-code}',
                        style: {
                            textTransform: 'uppercase'
                        }
                    },
                    name: 'Democrats margin',
                    point: {
                        events: {
                            click: pointClick
                        }
                    },
                    tooltip: {
                        ySuffix: ' %'
                    },
                    cursor: 'pointer'
                }, {
                    name: 'Separators',
                    type: 'mapline',
                    data: Highcharts.geojson(Highcharts.maps['countries/us/us-all'], 'mapline'),
                    color: 'silver',
                    showInLegend: false,
                    enableMouseTracking: false
                }]
            };
        keys = keys.map(function (key) {
            return key.toUpperCase();
        });
        Highcharts.each(options.series[0].mapData.features, function (mapPoint) {
            if (mapPoint.properties['postal-code']) {
                var postalCode = mapPoint.properties['postal-code'],
                    i = $.inArray(postalCode, keys);
                options.series[0].data.push(Highcharts.extend({
                    value: parseFloat(percent[i]),
                    name: names[i],
                    'postal-code': postalCode,
                    row: i
                }, mapPoint));
            }
        });

        // Initiate the chart

        window.chart = new Highcharts.Map(options);
    },

    error: function () {
        jQuery('#container').html('<div class=\"loading\">' +
            '<i class=\"icon-frown icon-large\"></i> ' +
            '<p>Error loading data from Google Spreadsheets</p>' +
            '</div>');
    }
});
});";

//HTML
$part->content = '<div id="part-' . $data->id . '-body"></div>';

//Start rendering
echo $part->render();