<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');

$data = $displayData;
$part = new LayoutPanel($data);

$mapParams = $data->params->get('map');
$stylesParams = $data->params->get('styles');
$controlsParams = $data->params->get('controls');
$markersParams = $data->params->get('markers');


//************* DATA *********************//


$content = $data->params->get('content');
//print_r($content->input->values);
$markets = array();

foreach ($content->input->values as $value){
    $row = array();
    $row['title'] = $value[1];
    $row['adresse1'] = $value[2];
    $row['adresse2'] = $value[3];
    $row['codepostal'] = $value[4];
    $row['ville'] = $value[5];
    $markers[] = $row;
}

//echo json_encode($data);

$part->script[] = 'var data' . $data->id . ' = {
        "rows": [
            {
                "title": "Aberystwyth University",
                "website": "www.aber.ac.uk",
                "phone": "+44 (0)1970 623 111",
                "lat": 52.415524,
                "lng": -4.063066,
	"type": "parking"},
            {
                "title": "Bangor University",
                "website": "www.bangor.ac.uk",
                "phone": "+44 (0)1248 351 151",
                "lat": 53.229520,
                "lng": -4.129987,
	"type": "library"},
            {
                "title": "Cardiff Metropolitan University",
                "website": "www.cardiffmet.ac.uk",
                "phone": "+44 (0)2920 416 138",
                "lat": 51.482708,
                "lng": -3.165881,
	"type": "info"}
        ]
    };
';    

$part->script[] = 'var icons' . $data->id . ' = {
          parking: {icon: "https://maps.google.com/mapfiles/kml/shapes/parking_lot_maps.png"},
          library: {icon: "https://maps.google.com/mapfiles/kml/shapes/library_maps.png"},
          info: {icon: "https://maps.google.com/mapfiles/kml/shapes/info-i_maps.png"}
        };
';


/************* OPTIONS ********************/

$options = array();

$options['center']['lat'] = (float) $mapParams->center->lat;
$options['center']['lng'] = (float) $mapParams->center->lng;
$options['zoom'] = (int) $mapParams->zoom->value;


/************* Controls *******************/
if ($controlsParams->type->display == '0')
    $options['mapTypeControl'] = false;

if ($controlsParams->type->style != 'default'){
    switch($controlsParams->type->style){
	case 'dropdown_menu' :
	    //google.maps.MapTypeControlStyle = HORIZONTAL_BAR
	//	style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
		
	    break;
	case 'horizontal_bar' :
	  //  style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR
	    break;
    }
    
}


//print_r(json_encode($options));

    $part->script[] = '
jQuery(function () {
    ngetools.loadScripts([{path : "http://maps.googleapis.com/maps/api/js?key=AIzaSyBWDKTjWgvmzG74PMPDCzECkg9gQMg7kec"}], 
	function(){	
	    var map' . $data->id . ' = new google.maps.Map(document.getElementById("part-' . $data->id . '-body"), ' . json_encode($options) . ');
		
	jQuery.each(data' . $data->id . '.rows, function (key, data) {
	    var latLng = new google.maps.LatLng(data.lat, data.lng);
	    var marker = new google.maps.Marker({
		position: latLng,
		map: map' . $data->id . ',
		icon: icons' . $data->id . '[data.type].icon,
		title: data.title
	    });
	    /*var details = data.website + ", " + data.phone + ".";*/
	});



	});
});';

    
    
$part->style[] = '/* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #part-' . $data->id . '-body {
        height: 400px;
      }
      
.overlay{
  display:block;
  text-align:center;
  color:#fff;
  font-size:30px;
  line-height:40px;
  opacity:0.8;
  background:#4477aa;
  border:solid 3px #336699;
  border-radius:4px;
  box-shadow:2px 2px 10px #333;
  text-shadow:1px 1px 1px #666;
  padding:0 4px;
}

.overlay_arrow{
  left:50%;
  margin-left:-16px;
  width:0;
  height:0;
  position:absolute;
}
.overlay_arrow.above{
  bottom:-15px;
  border-left:16px solid transparent;
  border-right:16px solid transparent;
  border-top:16px solid #336699;
}
.overlay_arrow.below{
  top:-15px;
  border-left:16px solid transparent;
  border-right:16px solid transparent;
  border-bottom:16px solid #336699;
}
';

//HTML
$part->content = '<div id="part-' . $data->id . '-body"></div>';

//Start rendering
echo $part->render();
