<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
$data = $displayData;
$options = array();

switch ($data->style){
    case 'inner' :
	$options[] = 'zoomType : "inner"';
	$options[] = 'cursor : "' . $data->cursor . '"';
	$options[] = 'easing : true';
	break;
    case 'lens' : 
	if ($data->lens->shape == 'circle')
		$data->lens->shape = 'round';
	$options[] = 'zoomType : "lens"';
	$options[] = 'lensShape : "' . $data->lens->shape . '"'; 
	$options[] = 'lensSize : ' . $data->lens->size;
	if ($data->lens->border->width != 4)
	    $options[] = 'borderSize : '.$data->lens->border->width;
	$options[] = 'borderColour : "' . $data->lens->border->color . '"';
	break;
    default : //window
	$positions = array();
	$positions['rightinnertop'] = 1;
	//$positions['rightmiddle'] = 2; //Bug
	$positions['rightinnerbottom'] = 3;
	$positions['rightouterbottom'] = 4;
	$positions['bottomouterright'] = 4;
	$positions['bottominnerright'] = 5;
	//$positions['bottomcenter'] = 6; //Bug
	$positions['bottominnerleft'] = 7;
	$positions['bottomouterleft'] = 8;
	$positions['leftouterbottom'] = 8;
	$positions['leftinnerbottom'] = 9;
	//$positions['leftmiddle'] = 10; //Bug
	$positions['leftinnertop'] = 11;
	$positions['leftoutertop'] = 12;
	$positions['topouterleft'] = 12;
	$positions['topinnerleft'] = 13;
	//$positions['topcenter'] = 14; //Bug
	$positions['topinnerright'] = 15;
	$positions['topouterright'] = 16;
	$positions['rightoutertop'] = 16;	
	$options[] = 'zoomWindowPosition : ' . $positions[$data->window->position];
	if ($data->window->margin != 0){
	    switch(substr($data->window->position, 0, 3)){
		case 'lef' :
		    $options[] = 'zoomWindowOffetx : ' . (-1*$data->window->margin);
		    break;
		case 'top' :
		    $options[] = 'zoomWindowOffety : ' . (-1*$data->window->margin);
		    break;
		case 'bot' :
		    $options[] = 'zoomWindowOffety : '.$data->window->margin;
		    break;
		default :
		    $options[] = 'zoomWindowOffetx : '.$data->window->margin;
		    break;
	    }
	}
	//Size
	$options[] = 'zoomWindowWidth : ' . $data->window->width;
	if ($data->window->shape == 'rectangle')
	    $options[] = 'zoomWindowHeight : ' . $data->window->height;
	else
	    $options[] = 'zoomWindowHeight : ' . $data->window->width; //square
	//Border
	if ($data->window->border->width != 4)
	    $options[] = 'borderSize : '.$data->window->border->width;
	$options[] = 'borderColour : "' . $data->window->border->color . '"';
	//Background
	if ($data->background->display == true){
	    $options[] = 'tint : true';
	    $options[] = 'tintColour : "' . $data->background->color . '"';
	    $opacity = str_replace(',', '.', $data->background->opacity / 100);
	    $options[] = 'tintOpacity : '.$opacity;
	    $options[] = 'zoomTintFadeIn : 300';
	    $options[] = 'zoomTintFadeOut : 300';
	}
	//Effects
	$options[] = 'zoomWindowFadeIn : 500';
	$options[] = 'zoomWindowFadeOut : 300';
	$options[] = 'easing : true';
}
$optionsStr = '{' . implode(', ', $options) . '}';
?>
jQuery( document ).ready(function() {
    var currentElevateZoom = jQuery("<?php echo $data->selector; ?>");
    currentElevateZoom.elevateZoom(<?php echo $optionsStr; ?>);
    /*While Nge editing disable Zoom to show the part toolbar */
    jQuery(document).on( "ngeStartEdition", function() {
        currentElevateZoom.elevateZoom({zoomEnabled:false});
        setTimeout(function(){ 
            jQuery('.zoomContainer').remove();
            currentElevateZoom.removeData('elevateZoom');
            currentElevateZoom.removeData('zoomImage'); 
        }, 2000);
    });
    
    jQuery(document).on( "ngeDisableEdition", function() {
        currentElevateZoom.elevateZoom(<?php echo $optionsStr; ?>);
    });
});