<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	ini_set('display_errors',0);
?>

<?php 
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$style = 			array();
$script = 			array();

/***** INITIALIZING DATA *****/
if (!isset($data->id) || $data->id == 0){
	$data->id = rand();
}

if (!isset($data->rendering)) {
	$data->rendering = new StdClass();
	$data->rendering->mode = 'view';
}

if (!isset($data->size)) {
	$data->size = new StdClass();
	$data->size->type = '';
}

//Manually (manually / template / article)
if (!isset($data->content)) {
	$data->content = new StdClass();
	$data->content->type = "manually";
	$data->content->count = "5";
}

//Body
$contentBodys = 	array();
$labels = 			array();

//Attributes
$class = array();
$class[] = "part";
$class[] = 'tabbable';
$class[] = isset($data->tabs->position) && $data->tabs->position == 'left' ? 		'tabs-left' : '';
$class[] = isset($data->tabs->position) && $data->tabs->position == 'right' ? 		'tabs-right' : '';
$class[] = isset($data->tabs->position) && $data->tabs->position == 'below' ? 		'tabs-below' : '';

//Part display options
$style[] = NGE::layout('nge.parts.parts.display_style', $data);
$class[] = NGE::layout('nge.parts.parts.display_class', $data);

$attributes = array();
$attributes[] = 'id="part-'.$data->id.'"';
$attributes[] = ' class="'.implode(' ', $class).'"';


// ******** Body *************************************
//Body
if(isset($data->body->padding) && ($data->body->padding != ""))
  $style[] = '#part-'.$data->id.' .tab-pane {padding:'.$data->body->padding.'px;}';

//Body Border
if ($data->body->border != "none"){
	$dataBorder = $data->body->border;
	$dataBorder->selector = '#part-'.$data->id.' >img';
	$style[] = JLayoutHelper::render('nge.parts.panels.css.border_css', $dataBorder);
}

//Body Background
if ($data->body->background != "none"){
	$dataBackground = $data->body->background;
	$dataBackground->selector = '#part-'.$data->id.' >img';
	$style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataBackground);
}

//body Shadow
if ($data->body->shadow->style != "none") {
	$dataShadow = $data->body->shadow;
	$dataShadow->selector = '#part-'.$data->id.' >img';
	$style[] = JLayoutHelper::render ( 'nge.parts.panels.css.shadow_css', $dataShadow);
}


//***** Header and outside panel *******************

	//Header CSS
	$dataHeader = $data->header;
	$dataHeader->selector = '#part-'.$data->id.' .part_header';
	$style[] = JLayoutHelper::render('nge.parts.panels.css.header_css', $dataHeader);

	//Header Font CSS
	$dataHeaderFont = $data->header->font;
	$dataHeaderFont->selector = '#part-'.$data->id.' .header_title';
	$style[] = JLayoutHelper::render('nge.parts.text.css.font_css', $dataHeaderFont);

	//Header Background CSS
	$dataHeaderBackground = $data->header->background;
	$dataHeaderBackground->selector = '#part-'.$data->id.' .part_header';
	$style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataHeaderBackground);

	//Header Icomoon CSS
	$dataHeaderIcomoon = $data->header->glyph;
	$dataHeaderIcomoon->selector = '#part-'.$data->id.' .part_header .icomoon';
	$style[] = JLayoutHelper::render('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);


// //Badge CSS
// $dataBadge = $data->badge;
// $dataBadge->selector = '#part-'.$data->id.' .textarea_badge';
// $style[] = JLayoutHelper::render('nge.parts.panels.css.badge_css', $dataBadge);

// //Badge Font CSS
// $dataBadgefont = $data->badge->font;
// $dataBadgefont->selector = '#part-'.$data->id.' .textarea_badge span';
// $style[] = JLayoutHelper::render('nge.parts.text.css.font_css', $dataBadgefont);

//Border
if (isset($data->border)) {
	$dataGeneralBorder = $data->border;
	$dataGeneralBorder->selector = '#part-'.$data->id;
	$style[] = JLayoutHelper::render('nge.parts.panels.css.border_css', $dataGeneralBorder);
}

//Background
if (isset($data->background)) {
	$dataPanelBackground = $data->background;
	$dataPanelBackground->selector = '#part-'.$data->id;
	$style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataPanelBackground);
}
	
//Shadow
if(isset($data->shadow) && ($data->shadow->style != 'none')){
	$dataShadow = $data->shadow;
	$dataShadow->selector = '#part-'.$data->id;
	$dataShadow->background = $data->background;
	$style[] = JLayoutHelper::render('nge.parts.panels.css.shadow_css', $dataShadow);
}


//Images

$style[] = '
#part-' . $data->id . ' {
	position:relative;
	min-height:'.$data->height->height_absolute.'px;
}
#part-'.$data->id.'> img{
	position:absolute;
	-webkit-transform-origin : 0 0;
	-moz-transform-origin : 0 0;
	-ms-transform-origin : 0 0;
	-o-transform-origin : 0 0;
	transform-origin: 0 0;
}';

//each image positionning
for ($i=0;$i <$data->count; $i++){
	$style[] = '#part-'.$data->id . '-'.$i.' {';
	if ($data->width_values[$i] != '') 
		$style[] = 'width: '.$data->width_values[$i].'%;';

	$style[] = 'left: '.$data->positions_x[$i].'%;';
	$style[] = 'top: '.$data->positions_y[$i].'%;';
	
	if ($data->rotations[$i] != 0) {
		$style[] = 'transform:  rotate('.$data->rotations[$i].'deg);';
		$style[] = '-webkit-transform:  rotate('.$data->rotations[$i].'deg);';
		$style[] = '-moz-transform:  rotate('.$data->rotations[$i].'deg);';
		$style[] = '-o-transform:  rotate('.$data->rotations[$i].'deg);';
		$style[] = '-ms-transform: rotate('.$data->rotations[$i].'deg);';
	}

	$style[] = '}';
} 

if ($data->rendering->mode == 'preview' || $data->rendering->mode == 'edit'){
	$style[] = '#part-'.$data->id.':hover{
		border: 1px dashed #999999;
	}
	#part-'.$data->id.' >img:hover{
		border: 1px dashed #999999;
	}';
}


$tabsOutput = array();
$tabsTheme = isset($data->tabs->style) && (($data->tabs->style == 'pills') || ($data->tabs->style == 'flat') || ($data->tabs->style == 'box')) ? 'nav-tabs nav-pills' : 'nav-tabs';
$tabsOutput[] = '<ul class="nav '.$tabsTheme.'" data-toggle="tab-hover">';

/**********************************************************************************************************
* create or preview mode, add script and styles
*/
if( $data->rendering->mode == 'preview' || $data->rendering->mode == 'edit') {

	$style[] = '
	.part-'.$part->id.'-draggable:hover{
	border: 1px dotted #999999;
	}';

	$doc = JFactory::getDocument();
	$doc->addScript(NGEURL_ROOT . 'media/com_nge/interact.js/interact.min.js');

	$script_interact = '
	interact(\'.part-'.$data->id.'-draggable\')
	.draggable({
	    onmove: function (event) {

	       var target = event.target,
		layoutWidth = target.parentElement.offsetWidth,			
		deltaX = parseFloat(event.dx / layoutWidth*100),
		deltaY = parseFloat(event.dy / layoutWidth*100),       
		x = parseFloat(target.getAttribute(\'data-x\') || 0) + deltaX,
	       y = parseFloat(target.getAttribute(\'data-y\') || 0) + deltaY;
	        /*target.style.webkitTransform =*/
	       /* target.style.transform =
	            \'rotate(\' + rotate + \'deg) scale(\' + scale + \')\';*/
		target.style.left = x+\'%\';
		target.style.top = y+\'%\';
	        target.setAttribute(\'data-x\', x);
	        target.setAttribute(\'data-y\', y);
	    },
	    onend: function (event) {

	    	var target = event.target,
	        x = parseFloat(target.getAttribute(\'data-x\'));
	    	y = parseFloat(target.getAttribute(\'data-y\'));

	    	index = parseFloat(target.getAttribute(\'data-index\'));
	 ';
     
     if($data->rendering->mode == 'preview') {
        $script_interact .= '/* in preview mode */
	    	parent.imagewall_setImagePosition(index,x,y);';
     }  	
     else {
        $script_interact .= '/* in edit mode */
			if (storePartProperty('.$data->id.', \'content\', \'positions_x.\'+index, x) && storePartProperty('.$data->id.', \'content\', \'positions_y.\'+index, y)){
			    displaySavedStatus(jQuery("#part-toolbar-status"), \'Saved\');
			};';
     }
            
     $script_interact .= '       
			
	    }
	})
	.inertia(true)
	.restrict({
	    drag: "parent",
	    endOnly: true,
	    elementRect: { top: 0, left: 0, bottom: 1, right: 1 }
	});

	interact(\'.part-'.$data->id.'-draggable\')
	.resizable(true)
	.on(\'resizemove\', function (event) {
	  var target = event.target,
		layoutWidth = target.parentElement.offsetWidth,			
		deltaX = parseFloat(event.dx / layoutWidth*100),
		deltaY = parseFloat(event.dy / layoutWidth*100),  	
		dataWidth = target.getAttribute(\'data-width\'),
		index = parseFloat(target.getAttribute(\'data-index\'));
		if (dataWidth == \'\')
			dataWidth = parseFloat( target.offsetWidth / layoutWidth*100);
		var xWidth = parseFloat(dataWidth) + parseFloat(deltaX);
	       /*y = parseFloat(target.getAttribute(\'data-y\') || 0) + deltaY,*/
	  
 ';
     
     if($data->rendering->mode == 'preview') {
        $script_interact .= '/* add the change in coords to the previous width of the target element*/
		parent.imagewall_setImageWidth(index,xWidth);';
     }  	
     else {
        $script_interact .= '/* in edit mode */
			if (storePartProperty('.$data->id.', \'content\', \'width_values.\'+index, xWidth)){
			    displaySavedStatus(jQuery("#part-toolbar-status"), \'Saved\');
			};';
     }
            
     $script_interact .= ' 
     	
		/* update the element\'s style*/
		target.setAttribute(\'data-width\',xWidth );
		target.style.width  = xWidth + \'%\';

	});';
	
	$script[] = $script_interact;
};


/**********************************************************************************************************
* Generate HTML 
*/      
if ($data->rendering->mode == 'preview'){
	echo '<div style="text-align:right;color:#999999;"><span class="icomoon icomoon-info"></span>&nbsp;<i>Move, resize and rotate the images by mouse drag.</i></div>';
}
$html[] = '<div '.implode($attributes).' >';
//Import style CSS & script JS
if (count($style) != 0)
	$html[] = '<style>'.implode($style).'</style>';
if (count($script) != 0)
	$html[] = '<script>'.implode($script).'</script>';

//Header
if (($data->header->label != '' || $data->header->glyph != '')){
	$dataHeader = $data;
	$dataHeader->selector = '#part-'.$data->id.' .part_header';	
	$html[] = JLayoutHelper::render('nge.parts.panels.html.header_html', $dataHeader);
}

for ($i=0;$i <$data->count; $i++){
	/*$data->transform_translatexs[$i] = min(max((float)$data->transform_translatexs[$i], 0),80);
	$data->transform_translateys[$i] = max((float)$data->transform_translateys[$i], 0);
	$data->transform_translatexs[$i] = 0;
	$data->transform_translateys[$i] = 0;*/
	$html[] = '<img id="part-'.$data->id.'-'.$i.'" src="'.JUri::root().$data->images[$i].'" data-index="'.$i.'" data-x="'.$data->positions_x[$i].'" data-y="'.$data->positions_y[$i].'" data-rotate="'.$data->rotations[$i].'" data-width="'.$data->width_values[$i].'" class="part-'.$data->id.'-draggable" />';
}

for ($i=0;$i <count($data->content->items); $i++){
	/*$data->transform_translatexs[$i] = min(max((float)$data->transform_translatexs[$i], 0),80);
	$data->transform_translateys[$i] = max((float)$data->transform_translateys[$i], 0);
	$data->transform_translatexs[$i] = 0;
	$data->transform_translateys[$i] = 0;*/
	$item = $data->content->items[$i];
	$html[] = '<img id="part-'.$data->id.'-'.$i.'" src="'.JUri::root() . $item->image.'" data-index="'.$i.'" data-x="' . $data->item->position_x.'" data-y="' . $item->position_y.'" data-rotate="'.$item->rotation.'" data-width="'.$data->scale.'" class="part-'.$data->id.'-draggable" />';
}


$html[] = '</div>';

//print_r($data->transform_translatexs);

echo implode($html);