<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
$data = 			$displayData;
$part = new LayoutPanel($data);

$imgAttributes = '';
$imghoverAttributes = '';

//Part usage is unique or multiple (in data reports)
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $data->selector = '.part-'.$data->id;
else
    $data->selector = '#part-'.$data->id;

//CONTENT

	$data->image = '';
	$data->image_hover = '';

	//Image
	if ($data->content->body->source == 'image'){
	    if($data->content->body->image != "")
		$data->image = NGEURL_ROOT . $data->content->body->image;
	    else
		$data->image = NGEURL_ROOT . "components/com_nge/assets/images/default_bigthumb_purple.png";
	}
	else if ($data->content->body->source == 'data'){
	    if($data->content->body->data != ""){
		$data->image = $data->content->body->data; //Will be tested for display
		$imgAttributes = 'v-bind:src="item.'.$data->content->body->data . '"';
	    }
	}

	//Image hover
	if ($data->content->hover->source == 'image'){
	    if($data->content->hover->image != "")
		$data->image_hover = NGEURL_ROOT . $data->content->hover->image;
	}
	else if ($data->content->hover->source == 'data'){
	    if ($data->content->hover->data != ""){
		$data->image_hover = $data->content->hover->data; //Will be tested for display
		$imghoverAttributes = 'v-bind:src="item.'.$data->content->hover->data . '"';
	    }
	}
	
    	//Url link
	$url = "";
	if (isset($data->link->type)){
	    switch ($data->link->type){
		case 'url' :
		    //require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
		    //$url = UrlDriver::getUrlLink($data);
		    if ($data->link->url != '')
			$url = $data->link->url;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_URLLINK_MISSING';
		    break;
		case 'article' :
		    if ($data->link->article != '')
			$url = NGEURL_ROOT . 'index.php?option=com_content&view=article&id='.$data->link->article;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_ARTICLELINK_MISSING';
		    break;
		case 'file' :
		    $url = NGE::url('root') . $data->link->file;
		    break;
		case 'menu' :
		    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
		    $menu = NgeJoomlaMenuDriver::loadItem($data->link->menu);
		    if (isset($menu)){
			$link = $menu->route;
			$url = NGE::url('root').'index.php/'.$link;        			    
		    }
		    else{
			$part->warnings[] = 'COM_NGE_WARNING_MENULINK_MISSING';
		    }	
		    break;
		case 'javascript' :
		    $url = $data->link->javascript;
		    break;
		case 'submit' :
		    $url = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
		    break;
	    }	
	}	
            

if ($url != ''){
    //Only if not in preview mode
    if(isset($data->rendering->mode) && ($data->rendering->mode != 'preview')){
	//Link target JS
	$dataLink = $data->link;
	$dataLink->selector = $data->selector;
	$dataLink->url = $url;
	$dataLink->type = $data->link->type;
	$dataLink->target = $data->link->target;
	$part->script[] = JLayoutHelper::render('nge.parts.panels.js.button_js', $dataLink);
	$part->style[] = $data->selector . ':hover{cursor:pointer;}';
    }
}


if(isset($data->hovereffect) && isset($data->hovereffect->image) && $data->hovereffect->image == ""){
	$data->hovereffect->image = "components/com_nge/assets/images/default_bigthumb_black.png";
}

//Image style
$class_img = JLayoutHelper::render('nge.parts.images.css.image_class', $data);

//Tooltip
$tooltip_content = "";
if ($data->tooltip->trigger != "none"){
	if ($data->tooltip->source == 'html'){
		$tooltip_content = $data->tooltip->html;
	}else if ($data->tooltip->source == 'url'){
		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
		$tooltip_content = UrlDriver::getContents($data->tooltip->url);
	}else if ($data->tooltip->source == 'query') {
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
		$tooltip_content = NgeDatabaseDriver::loadSingle($data->tooltip->query);
	}else if ($data->tooltip->source == 'article') {
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$article = NgeArticleDriver::load($data->tooltip->article);
		$tooltip_content = $article->introtext;
	}else if ($data->tooltip->source == 'file') {
		require_once (NGEPATH_HELPERS . '/data/file/filedriver.php');
		$tooltip_content = NgeFileDriver::getContents($data->tooltip->file);
	}
}
//Popover
if($data->popover->trigger != "none"){
	switch($data->popover->source) {
		case 'html' :
			$popover_content = $data->popover->html;
			break;
		case 'url' :
			require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
			//$popover_content = UrlDriver::getContents($data->popover->url);
			$popover_content = '<iframe src="'.$data->popover->url.'" style="zoom:0.60" width="400" height="500" frameborder="0"></iframe>';
			break;
		case 'query' :
			require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
			$popover_content = NgeDatabaseDriver::loadSingle($data->popover->query);
			break;
		case 'article' :
			require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
			$article = NgeArticleDriver::load($data->popover->article);
			$popover_content = $article->introtext;
			break;
		case 'module' :
			require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
			$popover_content = NgeJoomlaModuleDriver::load($data->popover->module);
			break;
		case 'image' :
			if($data->popover->image == ""){
				$data->popover->image = "components/com_nge/assets/images/default_bigthumb.png";
			}
			$popover_content = '<img src="'.$data->popover->image.'" />';
			break;
		default :
			$popover_content = "";
	}
	
	if ($popover_content != ""){
		$dataPopover = $data->popover;
		$dataPopover->selector = $data->selector;
		$dataPopover->id = $data->id;
		$dataPopover->content = $popover_content;
		$dataPopover->rendering_mode = $data->rendering->mode;
		$htmlPopover = JLayoutHelper::render('nge.parts.text.html.popover_html', $dataPopover);
		$classPopover = ' trigger';
		
		$part->style[] = JLayoutHelper::render('nge.parts.text.css.popover_css', $dataPopover);
		$part->script[] = JLayoutHelper::render('nge.parts.text.js.popover_js', $dataPopover);
		
		//Popover header
		//Header Font CSS
		if($data->popover->header->font->style == 'custom'){
			$dataHeaderFont = $data->popover->header->font;
			$dataHeaderFont->selector = '#popover-'.$data->id.' .popover > .popover-title';
			$part->style[] = JLayoutHelper::render('nge.parts.text.css.font_css', $dataHeaderFont);
		}
		
		//Header Background CSS
		if ($data->popover->header->background->style != "default") {
			$dataHeaderBackground = $data->popover->header->background;
			$dataHeaderBackground->selector = '#popover-'.$data->id.' .popover > .popover-title';
			$part->style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataHeaderBackground);
		}
		
		//Popover body
		//Border
		if ($data->popover->border->style != "default") {
			$dataGeneralBorder = $data->popover->border;
			$dataGeneralBorder->selector = '#popover-'.$data->id.' .popover';
			$part->style[] = JLayoutHelper::render('nge.parts.panels.css.border_css', $dataGeneralBorder);
		}
		
		//Background
		if ($data->popover->background->style != "default") {
			$dataPanelBackground = $data->popover->background;
			$dataPanelBackground->selector =  '#popover-'.$data->id.' .popover > .popover-content';
			$part->style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataPanelBackground);
		}
	}else{
		$htmlPopover = '';
		$classPopover = '';
	}
}

//Caption CSS
 if (isset($data->caption->html) && ($data->caption->html != '')){
 	//Caption options and display
	$dataCaption = $data->caption;
 	$dataCaption->selector = $data->selector.' .content_img .image_caption';
	$dataCaption->selector_hover = $data->selector.' .content_img:hover .image_caption';
	$part->style[] = JLayoutHelper::render('nge.parts.images.css.caption_css', $dataCaption);

	//Font
	if ($data->caption->font->style == 'custom') {
		$this->dataCaptionFont = $data->caption->font;
		$this->dataCaptionFont->selector = $data->selector . ' .caption_value';
		$part->style[] = JLayoutHelper::render('nge.parts.text.css.font_css', $this->dataCaptionFont);
	}
	
	//Caption Border
	if ($data->caption->border->style != "none") {
		$dataCaptionBorder = $data->caption->border;
		$dataCaptionBorder->selector = $data->selector . ' .image_caption';
		$part->style[] = JLayoutHelper::render('nge.parts.panels.css.border_css', $dataCaptionBorder);
	}
	
	//Caption background
	if ($data->caption->background->style != "none") {
		$dataCaptionBackground = $data->caption->background;
		$dataCaptionBackground->selector = $data->selector . ' .content_img .image_caption';
		$part->style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataCaptionBackground);
	}	
	
 }

//Tooltip
if (($data->tooltip->trigger != "none") && ($tooltip_content != "")){
	$data->tooltip_content = $tooltip_content;
	$part->style[] = JLayoutHelper::render('nge.parts.text.css.tooltip_css', $data);
	$part->script[] = JLayoutHelper::render('nge.parts.text.js.tooltip_js', $data);
}

//Zoom
if (isset($data->zoom->style) && ($data->zoom->style != "none")){
	NgeContenthelper::addScript(NGEURL_MEDIA . 'elevatezoom/jquery.elevatezoom.min.js');
	$dataZoom = $data->zoom;
	$dataZoom->selector = $data->selector.' .url_image' ;
	$part->script[] = JLayoutHelper::render('nge.parts.images.js.zoom_js', $dataZoom);
}

//Shape 
if (isset($data->shape->style) && ($data->shape->style != "default")){
	$dataShape = $data->shape;
	//$dataShape->selector = $data->selector.' .url_image, ' . $data->selector.' .url_image_hover';
	$dataShape->selector = $data->selector;	
	$part->style[] = JLayoutHelper::render('nge.parts.images.css.shape_css', $dataShape);
	//todo call once only
	$part->style[] = JLayoutHelper::render('nge.parts.images.css.imagecrop_css', $dataShape);
	$part->script[] = JLayoutHelper::render('nge.parts.images.js.shape_js', $dataShape);
}


if($data->rendering->mode != 'fastview' && isset($data->caption->effects) && ($data->caption->effects != "")){
	//NgeContenthelper::addStyleSheet(JUri::root() . 'media/com_nge/animate/css/animate.min.css');
	//NgeContenthelper::addScript(JUri::root() . 'media/com_nge/velocity/velocity.min.js');

	if (count($data->caption->effects) > 0){
	    $dataEffects = $data->caption->effects[0];
	    $dataEffects->selector = $data->selector;
	    $dataEffects->hover_animate = true;
	    $part->style[] = JLayoutHelper::render('nge.parts.parts.effects.css.effects_caption_css', $dataEffects);
	    $part->script[] = JLayoutHelper::render('nge.parts.parts/effects.js.effects_caption_js', $dataEffects);
	}
}


$dataSelector = $data->selector;
$dataImage = $data;
$dataImage->selector = $data->selector . '-body img';

$part->style[] = JLayoutHelper::render('nge.parts.images.css.image_css', $dataImage);
$data->selector = $dataSelector;
//Overflow !
/*
$overflow = (in_array($data->caption->positions->horizontal->position, array('left', 'right')) && $data->caption->positions->horizontal->margin <0) 
	||(in_array($data->caption->positions->vertical->position, array('top', 'bottom')) && $data->caption->positions->vertical->margin <0) ?
		'visible' : 'hidden';
 */
//if ($data->caption->)
//$part->style[] = $data->selector . ' .content_img {position:relative;max-width: 100%; margin: 0 auto; width:100%;overflow:hidden;';

//if ($data->link->type != 'none')
    if ($url != '')
    $part->style[] = 'cursor:pointer;';
$part->style[] = '}';

//$part->style[] = '#part-'.$data->id . ' .content_img div{position:relative;}';
$part->style[] = $data->selector . ' .image_caption{position:absolute;}';

//Content
	if($data->rendering->mode == 'edit'){
	    $xeditable_class = ' ngeelement ngeinlineeditable ngeinlineimage';
	    $attributes = ' data-nge = \'{"title": "Image", "type": "image", "source":"content:image", "name":"'.$data->image.'"}\' ';

	}else{
	    $xeditable_class = '';
	    $attributes = '';
	}
        
	$imageContent = '	<div id="part-' . $data->id . '-body" class="content_img">';
	$imageContent .= '	      <div style="position:relative;" class="'.$xeditable_class.'"'.$attributes.'>';
	if (isset($data->caption->html) && $data->caption->html != ''){
		
		$imageContent .= ' 	<div id="part-'.$data->id .'-caption" class="image_caption">';
		//$imageContent .= ' 		<div class="transparent"></div>';
		if ($data->rendering->mode == 'edit')
			$imageContent .= '	<div id="'.$part->data->id.'-caption" class="caption_value ngeinlineeditable ngeinlineeditor"  data-nge = \'{"title": "Caption", "type": "editor", "source":"content:caption.html"}\'>'.$data->caption->html.'</div>';
		else
			$imageContent .= '	<div class="caption_value" >'.$data->caption->html.'</div>';
		$imageContent .= ' 	</div>';
	}
	
	$imageContent .= '<div class="url_image"><img '.$imgAttributes.' class="'.$class_img.$classPopover.'" src="' . $data->image.'"/></div>';
	if(isset($data->image_hover) && ($data->image_hover != '')){
		$imageContent .= '<div class="url_image_hover"><img '.$imghoverAttributes.' class="'.$class_img.$classPopover.'" src="' . $data->image_hover.'"/></div>';
	}
	$imageContent .= $htmlPopover;
	$imageContent .= '	      </div>';
	$imageContent .= '	</div>';

	//Legend
	if(isset($data->legend->html) && ($data->legend->html != "")){
		$dataLegend = $data->legend;
		$legend = JLayoutHelper::render('nge.parts.panels.html.legend_html', $dataLegend);
	}
	else
		$legend = '';

	//Rendering
	$part->content .= $imageContent;	

if(isset($data->image_hover) && ($data->image_hover != '')){ ?>
<script>
jQuery(function() {
	jQuery('<?php echo $data->selector; ?> .url_image_hover').hide();
	jQuery('<?php echo $data->selector; ?> .content_img div').hover(function(){
		jQuery(this).find('.url_image').hide();
		jQuery(this).find('.url_image_hover').fadeIn(500);
	},function(){
		jQuery(this).find('.url_image').fadeIn(500);
		jQuery(this).find('.url_image_hover').hide();
	});
});

</script>

<?php } 

echo $part->render();