<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

?>
<?php 
$data = $displayData;

function hex2rgb($hex) {
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3) {
		$r = hexdec(substr($hex,0,1).substr($hex,0,1));
		$g = hexdec(substr($hex,1,1).substr($hex,1,1));
		$b = hexdec(substr($hex,2,1).substr($hex,2,1));
	} else {
		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
	}
	$rgb = array($r, $g, $b);
	//return implode(",", $rgb); // returns the rgb values separated by commas
	return $rgb; // returns an array with the rgb values
}

$caption_background_color = hex2rgb($data->color);

echo $data->selector; ?> div.bx-caption{
	<?php 
		
	if ($data->verticalposition == 'top'){ ?>
		top:<?php echo $data->verticalmargin; ?>%;
	<?php }else if($data->verticalposition == 'bottom'){ ?>
		bottom:<?php echo $data->verticalmargin; ?>%;
	<?php }else{ ?>
		height:100%;
		top:0;
	<?php }
	
	if ($data->horizontalposition == 'full'){ ?>
		width:100%;
		left:0;
	<?php }else if($data->horizontalposition == 'right'){ ?>
		right:<?php echo $data->horizontalmargin; ?>%;
	<?php }else{ ?>
		left:<?php echo $data->horizontalmargin; ?>%;
	<?php } ?>
	position: absolute;
	<?php echo "background: rgba(".$caption_background_color[0].", ".$caption_background_color[1].", ".$caption_background_color[1].", ".($data->opacity/100).")"; ?>;
}

