<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

?>
<?php 
$data = $displayData;

require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');

//$caption_background_color = CssHelper::hex2rgb($data->backgroundcolor);

echo $data->selector. '{
 	position: absolute;';
	echo 'z-index:2;'; //To be visible when the main image has shape (round, polygon...)


	if($data->trigger == "hover"){
		echo 'visibility:hidden; transition:visibility 0s linear 0.3s, opacity 0.3s linear; opacity:0;';
	}else{
		echo 'visibility:visible; opacity:1; transition:visibility 0.3s linear 0s, opacity 0.3s linear;';
	}
	
	switch ($data->positions->vertical->position){
		case 'top' :
			echo 'min-height:'.round($data->positions->vertical->height - max($data->positions->vertical->height + $data->positions->vertical->margin - 100, 0)).'%;';
			echo 'top:'.$data->positions->vertical->margin.'%;';
			break;
		case 'middle' :
			echo 'min-height:'.$data->positions->vertical->height.'%;';
			echo 'top:'.round((100-$data->positions->vertical->height)/2).'%;';
			break;
		case 'bottom' :
			echo 'min-height:'.round($data->positions->vertical->height - max($data->positions->vertical->height + $data->positions->vertical->margin - 100, 0)).'%;';
			//echo 'top:'.max(100 - $data->positions->vertical->height - $data->positions->vertical->margin, 0).'%;';
			echo 'bottom:'.$data->positions->vertical->margin.'%;';
			break;
		case 'full' :
			echo 'height:100%;';
			echo 'top:0;';
			break;
	}
	
	switch ($data->positions->horizontal->position){
		case 'left' :
			echo 'width:'.round($data->positions->horizontal->width - max($data->positions->horizontal->width + $data->positions->horizontal->margin - 100, 0)).'%;';
			echo 'left:'.$data->positions->horizontal->margin.'%;';				
			break;
		case 'center' :
			echo 'width:'.$data->positions->horizontal->width.'%;';
			echo 'left:'.round((100-$data->positions->horizontal->width)/2).'%;';				
			break;
		case 'right' : 
			echo 'width:'.round($data->positions->horizontal->width - max($data->positions->horizontal->width + $data->positions->horizontal->margin - 100, 0)).'%;';
			echo 'left:'.max(100 - $data->positions->horizontal->width - $data->positions->horizontal->margin, 0).'%;';
			break;
		case 'full' : 
			echo 'width:100%;';
			echo 'left:0;';
			break;
	}
	
	
echo '}';

echo $data->selector. ' div{
 	position: relative; 
	width: 100%; 
	height: 100%; 
	/*color: black;*/
	box-sizing:border-box;';
	
	/*Caption padding*/
	if(isset($data->padding->top))
	    echo 'padding-top: '.$data->padding->top.'px;';
	if(isset($data->padding->left))
	    echo 'padding-left: '.$data->padding->left.'px;';
	if(isset($data->padding->right))
	    echo 'padding-right: '.$data->padding->right.'px;';
	if(isset($data->padding->bottom))
	    echo 'padding-bottom: '.$data->padding->bottom.'px;';
	
echo '}';

if($data->trigger != "always"){
	echo $data->selector_hover.'{';
		if($data->trigger == "hover"){
			echo ' visibility:visible;
			  opacity:1;
			  transition-delay:0s;';
		}else
			if($data->trigger == "outside"){
			echo 'visibility:hidden;
			  transition-delay:0s;
			  opacity:0;';
		}
	echo '}';
}

//Display effects
if (isset($data->effects) && count($data->effects) > 0){
    foreach ($data->effects as $effect){
	if ($effect->type == 'display'){
	    $dataEffect = $effect;
	    $dataEffect->selector = $data->selector;
	    if (isset($data->selector_hover))
		$dataEffect->selector_hover = $data->selector_hover;
	    switch ($effect->action){
		case 'show' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
		    break;
		case 'animate' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
		    break;
		case 'hide' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
		    break;
	    }
	}
    }
}
