<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
?>
<?php 
require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');

$data = $displayData;
$tabsNumber = 		$data->multiple;

$li = array();
for ($i=0;$i <$tabsNumber; $i++){
	if ($i==0)
		$active = ' class="active"';
	else
		$active = '';
	$li[] = '<li'.$active.' data-target="#part-'.$data->id.'" data-slide-to="'.$i.'"></li>'."\n";
}

$div = array();
for ($i=0;$i <$tabsNumber; $i++){
	if ($i==0)
		$active = 'active ';
	else
		$active = '';
	$div[] = '<div class="'.$active.'item"><img src="'.$data->images[$i].'">';
	if ($data->caption_displays[$i])
		$div[] = '<div id="caption-'.$data->id.'_'.$i.'" class="carousel-caption">'.$data->caption_labels[$i].'</div>';
	$div[] = '</div>'."\n";	
}

$style = array();
for ($i=0;$i <$tabsNumber; $i++){
	if ($data->show_caption){
		$style[] = '#caption-'.$data->id.'_'.$i.'  {'."\n";
		if ($data->caption_positions[$i] == 'top'){
			$style[] = 'top:'.$data->caption_vmargins[$i].'%;'."\n";			
			$style[] = 'bottom:auto;'."\n";
		}
		else 
		if ($data->caption_positions[$i] == 'left'){
			$style[] = 'top:'.$data->caption_vmargins[$i].'%;'."\n";
			$style[] = 'bottom:auto;'."\n";
			$style[] = 'left:'.$data->caption_hmargins[$i].'%;'."\n";
			$style[] = 'right:auto;'."\n";
		}
		else
		if ($data->caption_positions[$i] == 'right'){
			$style[] = 'top:'.$data->caption_vmargins[$i].'%;'."\n";
			$style[] = 'bottom:auto;'."\n";
			$style[] = 'left:auto;'."\n";
			$style[] = 'right:'.$data->caption_hmargins[$i].'%;'."\n";
		} 
		else {
			$style[] = 'top:auto;'."\n";
			$style[] = 'bottom:'.$data->caption_vmargisn[$i].'%;'."\n";
		}		
		$rgb = CssHelper::hex2rgb($data->caption_colors[$i]);
		$style[] =  'background: rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.'. (string) (100-$data->caption_transparencys[$i]).');'."\n";
		$style[] = '}'."\n";		
	}
}

//Attributes
$class = array();
$class[] = "part";
$class[] = ' carousel';
$class[] = ' slide';

//Part display options
$style[] = JLayoutHelper::render('nge.parts.display_style', $data);
$class[] = JLayoutHelper::render('nge.parts.display_class', $data);

$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = ' class="'.implode($class).'"';

echo JLayoutHelper::render('panels.css.carousel_css', $data, JPATH_ROOT.'/components/com_nge/layouts');
echo JLayoutHelper::render('panels.js.carousel_js', $data, JPATH_ROOT.'/components/com_nge/layouts');
?>
  
<div id="part-<?php echo $data->id; ?>" class="carousel slide">
<div class="carousel-header"></div>
<?php 
  	if ($data->header->content != ''){
		$titleLabel = $data->header->content;
	if ($data->header->glyph_position == 'left')
		$titleLabel = '<i class="'.$data->header->glyph_name.'"></i> ' . $titleLabel;
	if ($data->header->glyph_position == 'right')
		$titleLabel .= ' <i class="'.$data->header->glyph_name.'"></i>';
 	echo '<div class="carousel-title">'.$titleLabel.'</div>';
  	}
  ?>
  <ol class="carousel-indicators">
	<?php echo implode($li); ?>
  </ol>
  <!-- Carousel items -->
  <div class="carousel-inner">
    <?php echo implode($div); ?>
  </div>
  <!-- Carousel nav -->
  <a class="carousel-control left" href="#part-<?php echo $data->id; ?>" data-slide="prev">&lsaquo;</a>
  <a class="carousel-control right" href="#part-<?php echo $data->id; ?>" data-slide="next">&rsaquo;</a>
</div>
<style>
<?php 
echo implode($style);
?>
</style>