<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

$data = $displayData;

$styles = array();

//Margin
$margin_top = "0";
$margin_right = "0";
$margin_bottom = "0";
$margin_left = "0";

if (isset($data->size->margin->left))
	$margin_left = $data->size->margin->left;
if (isset($data->size->margin->top))
	$margin_top = $data->size->margin->top;
if (isset($data->size->margin->bottom))
	$margin_bottom = $data->size->margin->bottom;
if (isset($data->size->margin->right))
	$margin_right = $data->size->margin->right;

if (isset($data->size->display) && ($data->size->display == 'inline')) {	
	switch ($data->size->align) {
		case 'left' :
			$styles[] = 'float:left;';
			$styles[] = 'display:inline-block;';
			break;
		case 'right' :
			$styles[] = 'float:right;';
			$styles[] = 'display:inline-block;';
			break;
		default :
			$styles[] = 'display:inline-block;';
	}

	//General part margins
	if ($margin_left != '0')
		$styles[] = 'margin-left : ' . $margin_left . ';';
	if ($margin_top != '0')
		$styles[] = 'margin-top : ' . $margin_top . ';';
	if ($margin_right != '0')
		$styles[] = 'margin-right : ' . $margin_right . ';';
	if ($margin_bottom != '0')
		$styles[] = 'margin-bottom : ' . $margin_bottom . ';';
}else if ((!isset($data->size->display) || ($data->size->display == 'block'))) {
	if (isset($data->size->width) && ($data->size->width->mode == 'content')) /* Mode content */
		$styles[] = 'display:table;';
	else /* Mode fixed or auto */
		$styles[] = 'display:block;';

	if (isset($data->size->align)) {
		if (isset($data->background)){
			switch ($data->background->overflow->direction){
				case 'left' :
					if (strpos($margin_left, 'px') != false) {
						$leftBackgroundMargin = (string) (5000 - (int) substr($margin_left, 0, strpos($margin_left, 'px'))) . 'px';
						$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'padding-left: 5000px;';
					}
					else
					if (strpos($margin_left, ' %') != false) {
						$leftBackgroundMargin = (string) (500 - (int) substr($margin_left, 0, strpos($margin_left, '%'))) . '%';
						$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'padding-left: '.$leftBackgroundMargin.';';
					}
					else {
						$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' -5000px;';
						$styles[] = 'padding-left: 5000px;';
					}
					
					break;
				case 'right' :
					if (strpos($margin_right, 'px') != false) {
						$rightBackgroundMargin = (string) (5000 - (int) substr($margin_right, 0, strpos($margin_right, 'px')) - 5000) . 'px';
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $margin_left . ';';
						$styles[] = 'padding-right: 5000px;';
					}
					else
					if (strpos($margin_right, '%') != false){
						$rightBackgroundMargin = (string) (500 - (int) substr($margin_right, 0, strpos($margin_right, '%')) - 500) . '%';
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $margin_left . ';';					
						$styles[] = 'padding-right: 500%;';
					}
					else {
						$styles[] = 'margin:' . $margin_top . ' 5000px ' . $margin_bottom . ' ' .$margin_left;
						$styles[] = 'padding-right: 5000px;';
					}
					
					break;
				case 'justify' :
					if ((strpos($margin_left, 'px') != false) || (strpos($margin_right, 'px') != false)) {
						if (strpos($margin_left, 'px') != false)
							$leftBackgroundMargin = (string) (5000 - (int) substr($margin_left, 0, strpos($margin_left, 'px'))) . 'px';
						else
							$leftBackgroundMargin = '5000px';
						if (strpos($margin_right, 'px') != false)
							$rightBackgroundMargin = (string) (5000 - (int) substr($margin_right, 0, strpos($margin_right, 'px')) - 5000) . 'px';
						else
							$rightBackgroundMargin = '5000px';
						switch ($data->size->align) {
							case 'right' :	$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' auto;';				break;
							case 'left' :		$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' ' . $margin_left . ';';				break;
							case 'center' :		$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' auto;';						break;
							case 'available' :	$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' ' . $margin_left . ';';	break;
						}
							
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						
						$styles[] = 'padding-left: 5000px;';
						$styles[] = 'padding-right: 5000px;';
					}
					else
					if ((strpos($margin_left, ' %') != false) || (strpos($margin_right, '%') != false)) {
						if (strpos($margin_left, '%') != false)
							$leftBackgroundMargin = (string) (500 - (int) substr($margin_left, 0, strpos($margin_left, '%'))) . '%';
						else
							$leftBackgroundMargin = '500%';
						if (strpos($margin_right, 'px') != false)
							$rightBackgroundMargin = (string) (500 - (int) substr($margin_right, 0, strpos($margin_right, '%')) - 500) . '%';
						else
							$rightBackgroundMargin = '500%';
	
						$styles[] = 'margin:' . $margin_top . ' -' . $rightBackgroundMargin . ' ' . $margin_bottom . ' -' . $leftBackgroundMargin . ';';
						$styles[] = 'padding-left: 500%;';
						$styles[] = 'padding-right: 500%;';
					}
					else {
						$styles[] = 'margin:' . $margin_top . ' -5000px ' . $margin_bottom . ' -5000px;';
						$styles[] = 'padding-left: 5000px;';
						$styles[] = 'padding-right: 5000px;';
					}
	
					break;
				default :
					switch ($data->size->align) {
						case 'right' :
							$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' auto;';
							break;
						case 'left' :
							$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' ' . $margin_left . ';';
							break;
						case 'center' :
							$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' auto;';
							break;
						case 'available' :
							$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' ' . $margin_left . ';';
							break;
					}
			}
		}else{
			switch ($data->size->align) {
				case 'right' :
					$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' auto;';
					break;
				case 'left' :
					$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' ' . $margin_left . ';';
					break;
				case 'center' :
					$styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' auto;';
					break;
				case 'available' :
					$styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' ' . $margin_left . ';';
					break;
			}
		}
	}
}

//Width
if (isset($data->size->align)){
    switch ($data->size->align){
	case 'available' :
	    if (!(isset($data->background->overflow->direction)) || ($data->background->overflow->direction == 'none'))
		$styles[] = 'width: 100%;';
	    break;
	//Do nothing
	case 'none' :
	$styles[] = 'width: auto;';
	    break;
	default :
	    if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')) /* Mode content */
		$styles[] = 'width: auto;';
	    else /* Mode fixed or auto */
		$styles[] = 'width: ' . $data->size->width->value . ';';
    }	
}
else
    {
	if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')) /* Mode content */
		$styles[] = 'width: auto;';
	else /* Mode fixed or auto */
		$styles[] = 'width: ' . $data->size->width->value . ';';
}

$styles[] = '-webkit-box-sizing: border-box;';
$styles[] = '-moz-box-sizing: border-box;';
$styles[] = 'box-sizing: border-box;';

//Height
if (isset($data->size->height->mode) && ($data->size->height->mode == 'custom')) {
	$styles[] = 'height: ' . $data->size->height->value . ';';
}

if (count($styles) > 0) {
	echo '#part-' . $data->id . ' {';
	echo implode($styles);
	echo ' }';
}
