<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
/**
 * View to edit
 */
class NgeViewPattern extends JViewLegacy {

    protected $state;
    protected $item;
    protected $form;
    protected $params;
    protected $workshop;

    /**
     * Display the view
     */
    public function display($tpl = null) {

    	$jinput = JFactory::getApplication()->input;
    	$mode =					$jinput->get('mode', '', 'string');
	$key =					$jinput->get('key', '', 'string');
    	$layout =				$jinput->get('layout', '', 'string');
    	$includeLibraries =				$jinput->get('include_libraries', '1', 'int'); //Existing part id
    	$model = $this->getModel();
    
	//Decoding values
	//Warning. If values are json string object, decode them to save them as array.
	//Each array item can be modified by inlineediting.
	//Save thing in model part->save
	$keyArrayJson = NGE::recursive_array_search('ngejson::',$_REQUEST);
	if($keyArrayJson !== false){/*If value with json object string exist*/
	    $_REQUEST = NGE::decode_json_string($_REQUEST, $keyArrayJson);
	}

	//Loading stored params of the current pattern
	$patternParams = array();
	if ($mode == "edit"){
	    require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
	    $pattern = NgePatternDriver::load($key);
	    $partName = $pattern->name;
	    $patternParams = json_decode($pattern->params, true);
	    //Merging content and params
	    if ($pattern->content != ''){
		$contentArray = json_decode($pattern->content, true);
		$patternParams = NGE::array_merge_recursive_replace($contentArray, $patternParams);
	    }
	    
	    //Merging url params
	    $urlParams = json_decode(json_encode($_REQUEST), true);
	    if($patternParams !== '')	//Get Array params with current url params
		$patternParams = json_encode(NGE::array_merge_recursive_replace($patternParams, $urlParams));
	    else
		$patternParams = $urlParams;
	}
	else {
	    $patternParams = json_decode(json_encode($_REQUEST), true);;
	    $partName = $key;
	}
	    	
	//Rendering part with the merged params
	if(isset($partName)){
	    //If mode == edit, create, duplicate, we are in the config screen, in live preview, live params are in the url
	    //Otherwise, no url params, normal rendering => only database params

	    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';	
	    $result = $model->render($name, $mode, $patternParams);
	    //Load common scripts and stylesheets for the current part		
	    //TOTO, scripts are always included, because of content.prepare call in the part model.
	    if ($includeLibraries == '1'){ //Include libraries when first preview
		$result = NgeContenthelper::renderScripts() . $result;
		$result = NgeContenthelper::renderStyleSheets() . $result;
	    }


	    $this->part = NgePartsHelper::getPart($name);
	    $this->widgetId = $pk;
	    $this->partContent = $result;

	}

        parent::display($tpl);

        exit; 
    }
}
