<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
/**
 * View to edit
 */
class NgeViewPart extends JViewLegacy {

    protected $state;
    protected $item;
    protected $form;
    protected $params;
    protected $workshop;

    /**
     * Display the view
     */
    public function display($tpl = null) {

    	$jinput = JFactory::getApplication()->input;
    	$mode =					$jinput->get('mode', '', 'string');
    	$layout =				$jinput->get('layout', '', 'string');
    	$plname = 				$jinput->get('plname', '','string'); //Part library id
    	$pk = 					$jinput->get('pk', '', 'int'); //Existing part id
    	$includeLibraries =				$jinput->get('include_libraries', '1', 'int'); //Existing part id
    	$model = $this->getModel();

    	if ($plname != ''){ //Creation mode, part library id
    		$name = $plname;
    	}else if ($pk != '') //Modification mode, part id
    		$name = '['.$pk.']';
    
        if(isset($name)){
            //If mode == edit, create, duplicate, we are in the config screen, in live preview, live params are in the url
            //Otherwise, no url params, normal rendering => only database params

            //Warning. If values are json string object, decode them to save them as array.
            //Each array item can be modified by inlineediting.
            //Save thing in model part->save
            $keyArrayJson = NGE::recursive_array_search('ngejson::',$_REQUEST);
            if($keyArrayJson !== false){/*If value with json object string exist*/
                $_REQUEST = NGE::decode_json_string($_REQUEST, $keyArrayJson);
            }

            if (($mode == 'edit') || ($mode == 'create') || ($mode == 'duplicate'))
                    $urlparams = json_encode($_REQUEST);
            else
                    $urlparams = '';

            require_once NGEPATH_HELPERS . '/ngecontenthelper.php';	
            $result = $model->render($name, $mode, $urlparams);
            //Load common scripts and stylesheets for the current part		
            //TOTO, scripts are always included, because of content.prepare call in the part model.
            if ($includeLibraries == '1'){ //Include libraries when first preview
                $result = NgeContenthelper::renderScripts() . $result;
                $result = NgeContenthelper::renderStyleSheets() . $result;
            }
            
            
            $this->part = NgePartsHelper::getPart($name);
            $this->widgetId = $pk;
            $this->partContent = $result;
            
            if($mode == 'edit'){
                $this->user_email = (isset($_REQUEST["user_email"])) ? htmlspecialchars($_REQUEST["user_email"]) : null;
                $this->error_type = (isset($_REQUEST["error_type"])) ? $_REQUEST["error_type"] : null;
            }

            if($layout === "liveediting_widget" || $layout === "liveediting_scripts"){            
                /*
                 * Get part JSON file options for liveediting view. It should provide a JSON Object of plugins needed to launch
                 * Use case :
                 * {
                        "init": ["nge.xxx","xxx.xxx", ...] Script necessary for the proper functioning of plugins (String or Array
                        "toolbarPlugins": ["nge.xxx","xxx.xxx", ...], JS Plugins needed to launch in the toolbar
                        "elementsPlugins": "nge.xxx", JS Plugins needed to launch for specific widget elements (row, cell, col, point, xaxis ...)
                    }
                 */
                $liveediting_options_file_path = NGEPATH_PARTS . '/'.str_replace(".", "/", $this->part->name).'/liveediting.json';

                if(file_exists($liveediting_options_file_path)){
                    $this->liveediting_options = new stdClass();
                    $liveediting_options = json_decode(file_get_contents($liveediting_options_file_path), true);

                    if(!empty($liveediting_options) && $liveediting_options !== "" && $liveediting_options !== null){
                        foreach($liveediting_options as $key => $value) {
                            if(is_array($value)){
                                $this->liveediting_options->$key = array();
                                $array_script = new stdClass();
                                $array_script->js = array();
                                $array_script->css = array();

                                foreach ($value as $script_name) {
                                    $short_path = str_replace(".", "/", $script_name);

                                    switch ($key) {
                                        case "toolbarPlugins":
                                            $script_path = NGEPATH_HELPERS . '/editor/liveediting/toolbar/plugins/'.$short_path.'.js';

                                            if(file_exists($script_path)){
                                                $array_script->js[] = $script_path;
                                            }
                                            break;
                                        case "elementsPlugins":
                                            $script_path = NGEPATH_HELPERS . '/editor/liveediting/elements/plugins/'.$short_path.'.js';

                                            if(file_exists($script_path)){
                                                $array_script->js[] = $script_path;
                                            }
                                            break;
                                        default: //Init
                                            //remove last name plugin path
                                            $short_path_array = explode(".", $script_name);
                                            $last_shortpath_name = end($short_path_array);
                                            $new_shortpath_name = "";
                                            for ($i = 0; $i < count($short_path_array) - 1; $i++){
                                                $new_shortpath_name .= $short_path_array[$i]."/";
                                            }

                                            $style_path = NGEPATH_HELPERS . '/editor/liveediting/init/'.$new_shortpath_name.'css/'.$last_shortpath_name.'.css'; 
                                            $script_path = NGEPATH_HELPERS . '/editor/liveediting/init/'.$new_shortpath_name.'js/'.$last_shortpath_name.'.js';

                                            if(file_exists($style_path)){
                                                $array_script->css[] = $style_path;
                                            }
                                            if(file_exists($script_path)){
                                                $array_script->js[] = $script_path;
                                            }
                                            break;
                                    }
                                }
                                $this->liveediting_options->$key = $array_script;
                            }else{
                                $this->liveediting_options->$key = $value;
                            }
                        }
                    }
                }
            }
        }

        parent::display($tpl);

        exit; 
    }
}
