<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * WIDGET EDITING FIGARO
 */
// No direct access
defined('_JEXEC') or die;

if(isset($this->liveediting_options)){
    /***** SPECIFIC STYLESHEET AND JS SCRIPT LOADED EVERY TIME INSIDE THE MODAL WHEN A WIDGET LIVEEDITING VIEW IS CALLED *****/
    ob_start();
        echo '<style>';
        //Load widgets liveediting init style if exist.
        if(isset($this->liveediting_options->init->css)){
            if(is_array($this->liveediting_options->init->css)){
                foreach ($this->liveediting_options->init->css as $path) {
                    require $path;
                }
            }else{
                require $this->liveediting_options->init->css;
            }
        }
        echo '</style>';

        /* Get nge init scripts */
        echo '<script>';				 
        //Load widgets liveediting init js script if exist.
        if(isset($this->liveediting_options->init->js)){
            if(is_array($this->liveediting_options->init->js)){
                foreach ($this->liveediting_options->init->js as $path) {
                    require $path;
                }
            }else{
                require $this->liveediting_options->init->js;
            }
        }

        echo '</script>';
        $ngeInitScripts = ob_get_contents();
    ob_clean();

    /*Load specific widget init script for live editing*/
    echo $ngeInitScripts; 
    /*Load widget html*/
    echo $this->partContent;
?>
    <script>
        /*Function*/
        loadMainToolbarPlugins = function(){
            <?php
                /*Include all available liveediting plugins for widget elements*/
                if(isset($this->liveediting_options->toolbarPlugins->js)){
                    if(is_array($this->liveediting_options->toolbarPlugins->js)){
                        foreach ($this->liveediting_options->toolbarPlugins->js as $path) {
                            require $path;
                        }
                    }else{
                        require $this->liveediting_options->toolbarPlugins->js;
                    }
                }
            ?>
        };
        loadWidgetElementsPlugins = function(){
            <?php
                /*Include all available liveediting plugins for toolbar*/
                if(isset($this->liveediting_options->elementsPlugins->js)){
                    if(is_array($this->liveediting_options->elementsPlugins->js)){
                        foreach ($this->liveediting_options->elementsPlugins->js as $path) {
                            require $path;
                        }
                    }else{
                        require $this->liveediting_options->elementsPlugins->js;
                    }
                }
            ?>
        };
    </script> 
<?php
}else{
    echo '<div class="ngePreviewWarning" style="text-align:center;">Warning : Live editing is not enabled for this widget !</div>';
}