<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * WIDGET EDITING FIGARO
 */
// No direct access
defined('_JEXEC') or die;

//To flush browser cache when NGE version changes
$ngeVersion = '?'. NGE::version();
?>
<!DOCTYPE html>
<html prefix="og: http://ogp.me/ns#" xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr-fr" lang="fr-fr" dir="ltr">
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
        
        <!-- GENERAL STYLESHEET AND JS SCRIPT LOADED THE FIRST TIME THE MODAL IS LOADED -->
	<link href="<?= NGEURL_ROOT ?>components/com_nge/assets/css/all.css<?= $ngeVersion ?>" rel="stylesheet" type="all" />
	<link href="<?= NGEURL_ROOT ?>components/com_nge/assets/css/screen.css<?= $ngeVersion ?>" rel="stylesheet" type="screen" />
	<link href="<?= NGEURL_MEDIA ?>icomoon/icomoon-nge.css<?= $ngeVersion ?>" rel="stylesheet"/>
	<link href="<?= NGEURL_MEDIA ?>material/icons/material-icons.css<?= $ngeVersion ?>" rel="stylesheet" type="text/css"/>	
	<link href="<?= NGEURL_MEDIA ?>jquery-ui/jquery-ui.min.css<?= $ngeVersion ?>" rel="stylesheet"/>
	<link href="<?= NGEURL_ROOT ?>media/jui/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="<?= NGEURL_ROOT ?>components/com_nge/assets/css/ngedefault.min.css<?= $ngeVersion ?>" rel="stylesheet"/>
        <link href="<?= NGEURL_MEDIA ?>fonts/nge/ngeiconsfont.css<?= $ngeVersion ?>" rel="stylesheet"/>
	<link href="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/inline/editor.inline.css<?= $ngeVersion ?>" rel="stylesheet"/>
	<link href="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/toolbars/editor.toolbars.css<?= $ngeVersion ?>" rel="stylesheet"/>

	<script src="<?= NGEURL_ROOT ?>media/jui/js/jquery.min.js" type="text/javascript"></script>
	<script src="<?= NGEURL_MEDIA ?>jquery-ui/jquery-ui.min.js<?= $ngeVersion ?>" type="text/javascript"></script>
	<script src="<?= NGEURL_ROOT ?>media/jui/js/jquery-noconflict.js" type="text/javascript"></script>
	<script src="<?= NGEURL_ROOT ?>media/jui/js/bootstrap.min.js" type="text/javascript"></script>	
        <script src="<?= NGEURL_MEDIA ?>bootbox/bootbox.min.js<?= $ngeVersion ?>" type="text/javascript"></script>
        <script src="<?= NGEURL_MEDIA ?>jquery-ui/jquery.ui.touch-punch.min.js<?= $ngeVersion ?>" type="text/javascript"></script>
	<script src="<?= NGEURL_MEDIA ?>ckeditor/ckeditor.js<?= $ngeVersion ?>" type="text/javascript"></script>
        <script src="<?= NGEURL_MEDIA ?>nge/ngetools.js<?= $ngeVersion ?>" type="text/javascript"></script> 
        <script><?php require NGEPATH_HELPERS . '/editor/editor.nge_js.php'; ?></script>
	<script src="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/editor.nge.js<?= $ngeVersion ?>"></script>
	<script src="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/inline/editor.inline.js<?= $ngeVersion ?>"></script>
	<script src="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/toolbars/editor.toolbars.js<?= $ngeVersion ?>"></script> <!-- Pour loadInlineForm  -->
	<script src="<?= NGEURL_ROOT ?>components/com_nge/helpers/editor/liveediting/editor.toolbar.js<?= $ngeVersion ?>"></script>
        <script>
            /*Launch editing for all text editable*/
            var ngeInline = new NgeInline();
            
            /*Function updateWidgetHtml
             * Update the widget Html replacing the old Html with the new one.*/
            updateWidgetHtml = function(widgetId, widgetHtml){
                jQuery("#nge-liveediting-loading").show();
                
                /*Only update if autorefresh is On*/
                if(jQuery("#previewswitch").prop("checked")){
                    /*Disabled*/
                    if(typeof ngeToolbarLiveEditingElements !== "undefined"){
                        ngeToolbarLiveEditingElements.clear();
                    }

                    /*First launch liveediting Init script.*/
                    jQuery(document).trigger("ngeDisableLiveEditingInit");
                    /* END Disabled*/
                
                
                    jQuery("#part-"+widgetId).replaceWith(widgetHtml).promise().done(function() {
                        jQuery('#ngeModalLiveEditing .nge-modal-content', window.parent.document).css('visibility', 'visible');
                            
                        jQuery("#nge-liveediting-loading").hide();
                    });  
                }else{
                    jQuery("#nge-liveediting-loading").hide();
                }
            };
            
            /*Function loadWidgetHtml
             * Load the widget Html with widget ID propertie*/
            loadWidgetHtml = function(widgetId){
                jQuery("#nge-liveediting-loading").show();
                
                /*Disabled*/
                if(typeof ngeToolbarLiveEditingMain !== "undefined"){
                    ngeToolbarLiveEditingMain.clear();
                }
                if(typeof ngeToolbarLiveEditingElements !== "undefined"){
                    ngeToolbarLiveEditingElements.clear();
                }
                
                /*Empty the function, otherwise functions will be called as many times as will be declared.*/
                loadMainToolbarPlugins = function(){};
                loadWidgetElementsPlugins = function(){};
                
                jQuery(document).trigger("ngeDisableLiveEditingInit"); /*First launch liveediting Init script.*/
                jQuery(document).off("ngeEnableLiveEditingInit");
                jQuery(document).off("ngeDisableLiveEditingInit");
                
                jQuery(".part").find(".ngeliveediting").removeClass('ngeliveediting');
                /* END Disabled*/
                            
                jQuery.ajax({
                    type : 'POST',
                    url: rootUrl+"index.php?option=com_nge&view=part&layout=liveediting_widget&format=raw&mode=edit&pk="+widgetId,
                    success : function(widgetHtml){
                        jQuery('#ngeModalLiveEditing .nge-loading-content', window.parent.document).hide();
                            
                        jQuery(".nge-liveediting-container").html(widgetHtml).promise().done(function() {
                            jQuery('#ngeModalLiveEditing .nge-modal-content', window.parent.document).css('visibility', 'visible');
                            
                            /*Instanciate toolbar class needed to to live editing for the current widget*/
                            ngeToolbarLiveEditingMain = new NgeLiveEditingToolbar("nge-toolbar-liveediting-main");
                            ngeToolbarLiveEditingElements = new NgeLiveEditingToolbar("nge-toolbar-liveediting-elements", {
                                moveToClass: ".ngeelement",
                                initialPlugin: {
                                    tooltipPlacement: "top"
                                }
                            });
                        
                            /*Launch main toolbar loading plugin*/
                            loadMainToolbarPlugins();
                            /*Launch widget elemenst toolbar loading plugin*/
                            loadWidgetElementsPlugins();
                        });
                    },
                    error : function(result){
                        console.error("Erreur : impossible de sauvegarder le html du widget");   
                    }
                });
            };
            
            /*INITIALIZE FIRST TIME*/
            var ngeToolbarLiveEditingMain = undefined;
            var loadMainToolbarPlugins = function(){};
            var ngeToolbarLiveEditingElements = undefined;
            var loadWidgetElementsPlugins = function(){};
            
            jQuery(document).ready(function() {
                /*Instanciate toolbar class needed to to live editing for the current widget*/
                ngeToolbarLiveEditingMain = new NgeLiveEditingToolbar("nge-toolbar-liveediting-main");
                ngeToolbarLiveEditingElements = new NgeLiveEditingToolbar("nge-toolbar-liveediting-elements", {
                    moveToClass: ".ngeelement",
                    initialPlugin: {
                        tooltipPlacement: "top"
                    }
                });
                
                if(jQuery(".ngePreviewWarning").length > 0){
                    jQuery("#nge-liveediting-loading").hide();
                }
            });
            
            /*TRIGGER FUNCTION*/
            jQuery(document).on( "ngeWidgetLoaded", function() {
                /*Add ngeliveediting class and ngeeditablestructure class needed to begin live editing*/
                jQuery(".part").each(function () {
                    var pk = jQuery(this).attr("id").split("-");
                    jQuery(this).addClass('ngeeditablestructure ngeeditablestructurepart ngeliveediting').data("nge", {type: "part", id: pk[1]});
                });

                /*Launch editing for all text editable*/
                ngeInline._editing.texts.enable();

                /*Launch specific script for init the specific widget plugin and load the plugin after*/
                jQuery(document).trigger("ngeEnableLiveEditingInit");
                /*Clear current toolbars and load plugins*/
                if(typeof ngeToolbarLiveEditingMain !== "undefined"){
                    ngeToolbarLiveEditingMain.clear();
                }

                loadMainToolbarPlugins();
                if(typeof ngeToolbarLiveEditingElements !== "undefined"){
                    ngeToolbarLiveEditingElements.clear();
                }
                loadWidgetElementsPlugins();

                jQuery("#nge-liveediting-loading").hide();
            });
            
            /*INITIALIZE EVENT REDRAW FOR WIDGET WHO REDRAW IS OWN HTML (ex : Highchart)*/
            jQuery(document).on( "ngeWidgetRedraw", function() {
                jQuery("#nge-liveediting-loading").show();
                
                /*Clear current toolbar*/
                if(typeof ngeToolbarLiveEditingElements !== "undefined"){
                    ngeToolbarLiveEditingElements.clear();
                }
                
                /*First launch liveediting Init script.*/
                jQuery(document).trigger("ngeDisableLiveEditingInit");
                /* END Disabled*/

                /*Launch editing for all text editable*/
                ngeInline._editing.texts.enable();

                /*Launch specific script for init the specific widget plugin and load the plugin after*/
                jQuery(document).trigger("ngeEnableLiveEditingInit");
                /*Launch widget elemenst toolbar loading plugin*/
                loadWidgetElementsPlugins();
                        
                jQuery("#nge-liveediting-loading").hide();
            });
        </script>
        <style>
            html{
                overflow:auto;
            }
            .nge-liveediting-container{
                padding:20px 20px 20px 40px; 
                -webkit-box-sizing: border-box;
                -moz-box-sizing: border-box; 
                box-sizing: border-box;
                max-width:630px;
                margin: 0 auto;
            }
            #nge-message-box{
                position: fixed;
                top: 0;
                left: 40px;
                z-index: 15001;
            }

            #nge-message-box .nge-message-box-first{
                display:none;
            }

            #nge-message-box .nge-message-box-clone{
                position:relative;
                padding:10px;
                color:#ffffff;
                margin-bottom:2px;
            }

            #nge-message-box .nge-message-box-success{background:#81CE66;}
            #nge-message-box .nge-message-box-warning{background:#F09721;}
            #nge-message-box .nge-message-box-error{background:#E43D26;}
            
            .ngesvghidden{visibility:hidden};
            .close {
                float: right;
                font-size: 20px;
                font-weight: bold;
                line-height: 18px;
                color: #000;
                text-shadow: 0 1px 0 #ffffff;
                opacity: 0.2;
                filter: alpha(opacity=20);
            }
            
            /* Preview switch */
            #previewswitchlabel {
              position: relative;
              display: inline-block;
              width: 30px;
              height: 17px;
              margin-bottom: initial;
            }

            /* Hide default HTML checkbox */
            #previewswitch {display:none;}

            /* The slider */
            #previewswitchdiv {
              position: absolute;
              cursor: pointer;
              top: 0;
              left: 0;
              right: 0;
              bottom: 0;
              background-color: #ccc;
              -webkit-transition: .4s;
              transition: .4s;
            }

            #previewswitchdiv:before {
              position: absolute;
              content: "";
              height: 13px;
              width: 13px;
              left: 2px;
              bottom: 2px;
              background-color: white;
              -webkit-transition: .4s;
              transition: .4s;
            }

            #previewswitch:checked + #previewswitchdiv {
              background-color: #646D9C;
            }

            #previewswitch:focus + #previewswitchdiv {
              box-shadow: 0 0 1px #646D9C;
            }

            #previewswitch:checked + #previewswitchdiv:before {
              -webkit-transform: translateX(13px);
              -ms-transform: translateX(13px);
              transform: translateX(13px);
            }

            #nge-toolbar-liveediting-elements{
                display: inline-block;
                position:absolute;
                left:50%;
                top: 10px;
            }
            #nge-toolbar-liveediting-elements .nge-toolbar-plugins{
                display: -ms-flexbox;
                display: -webkit-flex;
                display: flex;
                -webkit-flex-direction: row;
                -ms-flex-direction: row;
                flex-direction: row;
                -webkit-flex-wrap: wrap;
                -ms-flex-wrap: wrap;
                flex-wrap: wrap;
                -webkit-justify-content: flex-start;
                -ms-flex-pack: start;
                justify-content: flex-start;
                -webkit-align-content: flex-start;
                -ms-flex-line-pack: start;
                align-content: flex-start;
                -webkit-align-items: center;
                -ms-flex-align: center;
                align-items: center;
            }
            #nge-toolbar-liveediting-elements .nge-toolbar-plugins .nge-toolbar-items{
                padding: 4px;
                font-size: 13px;
                background: #646D9C;
                color: #FFFFFF;
                -webkit-transition: background 0.25s ease-in-out;
                -moz-transition: background 0.25s ease-in-out;
                -ms-transition: background 0.25s ease-in-out;
                -o-transition: background 0.25s ease-in-out;
                transition: background 0.25s ease-in-out;
            }
            #nge-toolbar-liveediting-elements .nge-toolbar-plugins .nge-toolbar-items:hover{
                background: #78A2DB;
            }
            /* Rounded sliders */
            #previewswitchdiv {
              border-radius: 17px;
            }

            #previewswitchdiv:before {
              border-radius: 50%;
            }
            
            #nge-toolbar-liveediting-main{
                position: fixed;
                margin-top: 20px;
                z-index: 1;
            }
            #nge-toolbar-liveediting-main .nge-toolbar-plugins{
                margin-bottom:20px;
            }
            #nge-toolbar-liveediting-main .nge-toolbar-items{
                padding: 5px;
                cursor:pointer;
                opacity: 1;
                -webkit-transition: opacity 0.25s ease-in-out;
                -moz-transition: opacity 0.25s ease-in-out;
                -ms-transition: opacity 0.25s ease-in-out;
                -o-transition: opacity 0.25s ease-in-out;
                transition: opacity 0.25s ease-in-out;
            }
            #nge-toolbar-liveediting-main .nge-toolbar-items:hover{
                opacity: 0.7;
            }
            #ngetoolbardisplayitem-refresh, #ngetoolbardisplayitem-switchdevice{
                text-align:center;
                color:#646D9C;
                font-size:18px;
            }
            .switchdevice-container{
                display: -ms-flexbox;
                display: -webkit-flex;
                display: flex;
                -webkit-flex-direction: row;
                -ms-flex-direction: row;
                flex-direction: row;
                -webkit-flex-wrap: wrap;
                -ms-flex-wrap: wrap;
                flex-wrap: wrap;
                -webkit-justify-content: center;
                -ms-flex-pack: center;
                justify-content: center;
                -webkit-align-content: stretch;
                -ms-flex-line-pack: stretch;
                align-content: stretch;
                -webkit-align-items: flex-start;
                -ms-flex-align: start;
                align-items: flex-start;
            }
            .switchdevice-container .switchdevice-item{
                -webkit-order: 0;
                -ms-flex-order: 0;
                order: 0;
                -webkit-flex: 0 1 auto;
                -ms-flex: 0 1 auto;
                flex: 0 1 auto;
                -webkit-align-self: auto;
                -ms-flex-item-align: auto;
                align-self: auto;
                margin: 2px;
                text-align: center;
                font-size: 14px;
                padding: 10px;
                width: 84px;
                color: #FFFFFF;
                background-color: rgb(120, 143, 161);
                cursor: pointer;
                -webkit-transition: background 0.25s ease-in-out;
                -moz-transition: background 0.25s ease-in-out;
                -ms-transition: background 0.25s ease-in-out;
                -o-transition: background 0.25s ease-in-out;
                transition: background 0.25s ease-in-out;
            }
            .switchdevice-container .switchdevice-item:hover, .switchdevice-container .switchdevice-item.active{
                background-color: #646D9C;
            }
            div.ngePreviewWarning{
                padding: 10px 10px 10px 10px;
                font-size: 12px;
                color : #fff;
                background: #D44A26;
                margin-bottom: 5px;
            }
    
            div.ngePreviewWarning h4    {
	font-size : 26px;
	font-weight : normal;
	margin:0px 0px 10px 0px;
    }
    div.ngePreviewWarning .close, div.ngePreviewInformation .close {
	position: relative;
	top: -2px;
	line-height: 18px;
	float: right;
	font-size: 20px;
	font-weight: bold;
	line-height: 18px;
	color: #fff;
	text-shadow: 0 1px 0 #ffffff;
	opacity: 0.3;
	filter: alpha(opacity=20);
	cursor:pointer;
	border:transparent;
}

    div.ngePreviewInformation{
	padding: 10px 10px 10px 10px;
	font-size: 12px;
	color : #fff;
	background: #4F73DB;
	margin-bottom: 5px;
	border-left:4px solid #4F73DB;
    }
    div.ngePreviewInformation h4    {
	font-size : 26px;
	font-weight : normal;
	margin:0px 0px 10px 0px;
    }
    
    .ngetoolbar-general{
        z-index: 9998;
    }
    
    .ngetoolbar-general .nge-toolbar-plugins .nge-toolbar-items{
        cursor: pointer;
    }
    
    .ngetoolbar-general .nge-toolbar-plugins .nge-toolbar-items .icomoon-move{
        cursor: move;
    }
    #nge-liveediting-loading{
        position: fixed;
        z-index: 9999;
        width: 100%;
        height: 100%;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
        background: rgba(255,255,255,0.8);
        font-size: 28px;
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: nowrap;
        -ms-flex-wrap: nowrap;
        flex-wrap: nowrap;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
        -webkit-align-content: center;
        -ms-flex-line-pack: center;
        align-content: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
    }
    #nge-liveediting-loading div{
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 auto;
        -ms-flex: 0 1 auto;
        flex: 0 1 auto;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
    }
        </style>
</head>
    <body>
    <form id="tokenform">
	<?php
	echo NGE::tokenInput();
	?>
    </form>    	
        <div id="nge-liveediting-loading"><div>Chargement en cours ...</div></div>
        <div id="nge-toolbar-liveediting-main" class="ngetoolbar-general">
            <div id="ngeedit-toolbar-plugins" class="nge-toolbar-plugins"></div>
        </div>
        <div id="nge-toolbar-liveediting-elements" class="ngetoolbar-general" style="display:none;">
            <div id="ngeedit-toolbar-plugins" class="nge-toolbar-plugins"></div>
        </div>
        <div id="nge-message-box">
            <div class="nge-message-box-first nge-message-box-clone">
                <span class="icomoon"></span>
                <span class="nge-message"></span>
            </div>
        </div>
        <div class="nge-liveediting-container">
            <?php 
                require_once "liveediting_widget.php";
            ?>
        </div>
	<?php
	    //Inline Config form
	    require NGEPATH_HELPERS . '/editor/inline/config/modal.inlineconfig.php';
            //Elements Toolbar
	    require NGEPATH_HELPERS . '/editor/elements/editor.element_toolbar.php';
            //Modal General
            require NGEPATH_HELPERS .'/forms/fields/ngefields_html.php';
	?>
    </body>
</html>