<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
jimport('joomla.form.form');

/**
 * View to edit a module.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_modules
 * @since       1.6
 */
class NgeViewModule extends JViewLegacy
{
	protected $form;

	protected $item;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$lang = JFactory::getLanguage();
		$lang->load('joomla',JPATH_ADMINISTRATOR);
	    //require_once('administrator/components/com_modules/models/module.php');
	    //$modelModule = new ModulesModelModule();
	    //$this->form = $modelModule->getForm();
	  //  $this->item = $modelModule->getItem();
	    
	    $jinput = JFactory::getApplication()->input;
		$this->element = 		$jinput->get('element', '','string'); //Type of module
		$this->caller = 		$jinput->get('caller', '','string'); //Type of screen caller : for example tinymce for calling for tinymce screen
		$this->mode = 		$jinput->get('mode', '','string'); //Mode of the calling form : create (new part), edit (existing part), duplicate(part)		
		//$this->plname = 		$jinput->get('plname', '','string'); //Creating new part with the library id
		$this->pk = 		$jinput->get('id', ''); //Modifying existant module
		$this->medium = 		$jinput->get('medium', '','string'); //Destination of the new part : article, page, report, publication...

		$this->position =		$jinput->get('end_position','','string'); //If layout is a module position
		$this->m_before_id =		$jinput->get('m_before_id','','string'); //If layout is a module position
		$this->article =		$jinput->get('article','','string'); // If layout is an article
		
		$jinput->set('module',$this->element);
		//$this->mediumId = 		$jinput->get('medium_id', '','int');	    
	    
		$model = $this->getModel();
        
		$model ->setState('module.id', $this->pk);
		$model ->setState('extension.element', $this->element);
        
        //jForm::addFormPath(JPATH_ADMINISTRATOR.'/components/com_modules/models/forms');

		//Check position
		//if Layout is article, we create a new Position inside this article for the new module
		if (($this->caller == 'layout.article') && ($this->article != '')){
		    $this->position = $model->getNewPositionInArticle($this->article);
		}

	
	   // $modelModule = new ModulesModelModule();
	    $this->form = $model->getForm();
	    $this->form = $model->getModuleForm($this->form);

	    //$this->item		= $this->get('Item');
		$this->item = $model->getItem($this->pk);
		
	    $this->form->bind($this->item);
		
//		$this->item =new StdClass();
//		$this->item->module = new StdClass();
		//$this->state	= $this->get('State');
		$this->canDo	= JHelperContent::getActions('com_modules', 'module', $this->item->id);

		$this->editParams = new stdClass();
		$this->editParams->demoMode = false;		
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			NGE::message(implode("\n", $errors) , 'error');
			return false;
		}

		
	//	exit();
		
		//$this->addToolbar();
		parent::display($tpl);
	}

}
