<?php

/**
 * @version     1.0.0
 * @package     com_nge
 * @copyright   Copyright (C) 2013. Tous droits réservés.
 * @license     GNU General Public License version 2 ou version ultérieure ; Voir LICENSE.txt
 * @author      Teatis <administration@teatis.com> - http://www.teatis.com
 * 
 * * Warning : can be used both from Frontend or Backend.
 * All the files from libraygalleryview are copied once in the /components/com_nge/views directory 
 * and once in the /administrator/components/com_nge/views directory
 * Due to internal login limitations :
 * When Front editing : the current user is logged only front
 * When Back editing : the current user is logged only back
 * So the view is duplicated, but then calls common front helpers and font parts

 * 
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View to edit
 */
class NgeViewInlinecontent extends JViewLegacy {

    protected $state;
    protected $item;
    protected $form;

    /**
     * Display the view
     */
    public function display($tpl = null) {

	$jinput = JFactory::getApplication()->input;
	$partType = $jinput->get('part', '', 'string'); 
	$contentType = $jinput->get('content', '', 'string'); 
	// if in admin, load front component lang file
	$app = JFactory::getApplication();

	if ($app->isAdmin()) {
	    $lang = JFactory::getLanguage();
	    $lang->load('com_nge', JPATH_SITE);
	}

	//Editing params 
	switch ($contentType) {
	    case "newarticle" :
		$tpl = $contentType; //default_article
		break;
	    case "article" :
		$db = JFactory::getDbo();
		$db->setQuery("SELECT title, catid, id FROM #__content WHERE state=1");
		$this->articles = $db->loadAssocList();
		for ($i=0; $i<count($this->articles); $i++){
		    $this->articles[$i]['title'] = '<a data-id="'.$this->articles[$i]['id'].'" data-label="' . $this->articles[$i]['title'] . '" href="#">' . $this->articles[$i]['title'] . '</a>';
		}
		$db->setQuery("SELECT title, catid, id FROM #__content WHERE state=1 order by created DESC limit 0,20");
		$this->lastArticles = $db->loadAssocList();
		for ($i=0; $i<count($this->lastArticles); $i++){
		    $row = array();
		    $this->articles[$i]['title'] = '<a data-id="'.$this->lastArticles[$i]['id'].'" data-label="' . $this->articles[$i]['title'] . '" href="#">' . $this->lastArticles[$i]['title'] . '</a>';
		}
		$tpl = $contentType; //default_article
		break;
	    case "component" :
		require_once('administrator/components/com_menus/models/menutypes.php');
		require_once('administrator/components/com_menus/helpers/menus.php');
		$menusModelMenutypes = new MenusModelMenutypes();
		$this->components = $menusModelMenutypes->getTypeOptions();
		/*
		$types = $this->get('TypeOptions');
		
		$db = JFactory::getDbo();
		$db->setQuery("SELECT name, extension_id FROM #__extensions WHERE type='component' AND enabled=1");
		$this->components = $db->loadRowList();
		for ($i=0; $i<count($this->components); $i++){
		    $this->components[$i][0] = '<a data-id="'.$this->components[$i][1].'" data-label="' . $this->components[$i][0] . '" href="#">' . $this->components[$i][0] . '</a>';
		}*/
		$tpl = $contentType; //default_article
		break;
	    case "menuitem" :
		$db = JFactory::getDbo();
		$db->setQuery("SELECT title, catid, id FROM #__content WHERE state=1");
		$this->articles = $db->loadAssocList();
		for ($i=0; $i<count($this->articles); $i++){
		    $this->articles[$i]['title'] = '<a data-id="'.$this->articles[$i]['id'].'" data-label="' . $this->articles[$i]['title'] . '" href="#">' . $this->articles[$i]['title'] . '</a>';
		}
		$db->setQuery("SELECT title, catid, id FROM #__content WHERE state=1 order by created DESC limit 0,20");
		$this->lastArticles = $db->loadAssocList();
		for ($i=0; $i<count($this->lastArticles); $i++){
		    $row = array();
		    $this->articles[$i]['title'] = '<a data-id="'.$this->lastArticles[$i]['id'].'" data-label="' . $this->articles[$i]['title'] . '" href="#">' . $this->lastArticles[$i]['title'] . '</a>';
		}
		$tpl = $contentType; //default_article
		break;
	    case "image" :
		$tpl = $contentType; 
		break;		
	    case "glyph" :
		$tpl = $contentType; 
		break;			    
	    case "module" :
		$db = JFactory::getDbo();
		$db->setQuery("SELECT id, title, position, ordering FROM #__modules WHERE published=1 AND client_id=0");
		$this->modules = $db->loadAssocList();
		for ($i=0; $i<count($this->modules); $i++){
		    $this->modules[$i]['title'] = '<a data-id="'.$this->modules[$i]['id'].'" data-label="' . $this->modules[$i]['title'] . '" href="#">' . $this->modules[$i]['title'] . '</a>';
		}
		$tpl = $contentType; //default_module
		break;
	    case "pattern" :
		$db = JFactory::getDbo();
		$db->setQuery("SELECT id, title, ordering FROM #__nge_patterns WHERE state=1"); //AND part=".$partType."
		$this->patterns = $db->loadAssocList();
		for ($i=0; $i<count($this->patterns); $i++){
		    $row = array();
		    $this->patterns[$i]['title'] = '<a data-id="'.$this->patterns[$i]['id'].'" data-label="' . $this->patterns[$i]['title'] . '" href="#">' . $this->patterns[$i]['title'] . '</a>';
		    }
		$tpl = $contentType; //default_module
		break;
	}
	$user = JFactory::getUser();
	$params = JComponentHelper::getParams('com_nge');
	$this->editParams = new stdClass();
	//Searching jEasyStudio params for demo mode
	$jinput = JFactory::getApplication()->input;
	/*
	  $this->caller = 		$jinput->get('caller', '','string'); //Type of screen caller : for example tinymce for calling for tinymce screen
	  $this->mode = 			$jinput->get('mode', '','string'); //Mode of the calling form : create (new part), edit (existing part), duplicate(part)
	  $this->plname = 		$jinput->get('plname', '','string'); //Creating new part with the library id
	  $this->pk = 			$jinput->get('pk', '','int'); //Modifying existant part <ith the part id
	  $this->medium = 		$jinput->get('medium', '','string'); //Destination of the new part : article, page, report, publication...
	  $this->mediumId = 		$jinput->get('medium_id', '','int');
	 */
	
	parent::display($tpl);
    }

}
