<?php
/**
 * @version     1.0.0
 * @package     com_nge
 * @copyright   Copyright (C) 2013. Tous droits réservés.
 * @license     GNU General Public License version 2 ou version ultérieure ; Voir LICENSE.txt
 * @author      Teatis <administration@teatis.com> - http://www.teatis.com
 */
// no direct access
defined('_JEXEC') or die;

$document = JFactory::getDocument();
?>
<style>
    body{
	background: #fff;
    }
    .nav{
	background-color:#204389;
	
    }
    .nav a {
	color:#FFFFFF;
	text-transform:uppercase;
    }
    .tabheader{
	padding-left:40px;
	width:100%;	
	border-bottom: 1px solid #ddd;
    }
    .tabheader li{
	display: inline-block;
    }
    
    .nav-pills{
	/* Hidden in v1.1 */
	display:none;	
    }
    .nav-pills > li > a{
	padding: 15px 30px 15px 30px;
        -webkit-border-radius: 0px;
        -moz-border-radius: 0px;
        border-radius: 0px;
        margin-top: 0px; 
        margin-bottom: 0px; 
        margin-right: 0px;
        -webkit-transition: background-color .2s ease-in-out, border-bottom-color .2s ease-in-out;
        -moz-transition: background-color .2s ease-in-out, border-bottom-color .2s ease-in-out;
        -o-transition: background-color .2s ease-in-out, border-bottom-color .2s ease-in-out;
        transition: background-color .2s ease-in-out, border-bottom-color .2s ease-in-out;
    }
    .nav>li>a:hover, .nav>li>a:focus {
       background-color:#2F62C7;
       border-bottom: 3px solid #E7EDF9;
    }
    .nav-pills > .active > a, .nav-pills > .active > a:hover, .nav-pills > .active > a:focus {
        color: #fff;
        background-color: #2F62C7;
        border-bottom: 3px solid #E7EDF9;
    }
    #tabcontentnew{
	width:100%;
	text-align:center;
    }
    .dropimage{
	width:600px;
	margin:30px auto 30px auto;
	min-height:350px;
	border:2px dashed #ddd;
	padding-top:50px;
    }
    
    .blank_gallery{
	padding:20px 120px;	
    }
   #tabcontentblank li{
	display: inline-block;
	text-align:center;
	padding:10px;
	width:120px;
    }
    #tabcontentblank li:hover{
	border:1px solid #ddd;
    }
    #tabcontentblank img {
	max-height:80px;	
    }
    
    .gallery li{
	border:1px solid #fff;
	display: inline-block;
	padding:5px;
    }
    .gallery li:hover{
	border: 1px solid #ddd;
    }
    
    /*Elfinder*/
    #elfinder.ui-widget-content {
            border: 0px solid #aaaaaa; 
    }
    #ngeModalElfinder >div.modal-header{
        background-color:#646D9C;
        color:#fff;
          font-weight: normal;
        font-size: 22px;
    }
    #ngeModalElfinder >div.modal-header>h3{
          font-weight: normal;
        font-size: 22px;
    }
    #elfinder .icomoon{
        margin-right:5px;
    }
    #elfinder .elfinder-toolbar{
        color:#fff;
    }
    #elfinder .elfinder-button{
            padding:15px;
    }
    .elfinder-buttonset {
        -moz-border-radius: 0px;
        -webkit-border-radius: 0px; 
        border-radius: 0px; 
    }
    #elfinder .elfinder-navbar{
        background:#fff;
    }
    #elfinder .elfinder-cwd-file{			
        border: 1px solid #fff;
        -moz-box-shadow: 0px 0px 5px 1px #fff;
        -webkit-box-shadow: 0px 0px 5px 1px #fff;
        -o-box-shadow: 0px 0px 5px 1px #fff;
        box-shadow: 0px 0px 5px 1px #fff;
        filter:progid:DXImageTransform.Microsoft.Shadow(color=#D5DDE5, Direction=NaN, Strength=5);
    }
    #elfinder .elfinder-cwd-file:hover{			
        border: 1px solid #C2CCD6;
        -moz-box-shadow: 0px 0px 5px 1px #D5DDE5;
        -webkit-box-shadow: 0px 0px 5px 1px #D5DDE5;
        -o-box-shadow: 0px 0px 5px 1px #D5DDE5;
        box-shadow: 0px 0px 5px 1px #D5DDE5;
        filter:progid:DXImageTransform.Microsoft.Shadow(color=#D5DDE5, Direction=NaN, Strength=5);
    }
    </style>
<div class="tab-pane" >
    <ul id="nge-nav-tabs" class="nav nav-pills" data-tabs="tabs">
	<li class="active"><a href="#tabcontenttabs" data-toggle="tab">Media</a></li>			
	<!--<li><a href="#tabcontentnew" data-toggle="tab">New image</a></li>-->			
	<!--<li><a href="#tabcontentblank" data-toggle="tab">Blank</a></li>-->														
	<!--<li><a href="#tabcontentdummy" data-toggle="tab">Sample image</a></li>-->													
    </ul>
    <div class="tab-content">
	<div class="tab-pane active" id="tabcontenttabs">
            <div id="elfinder"></div>
	</div>
	<div class="tab-pane" id="tabcontentnew">
	    <div class="dropimage"><img src="components/com_nge/assets/images/wizard/picture.png">
		<h4>Add your image</h4><br/>
		Drag and drop your image in this window<br/>
		or <a>click here to search and upload</a>
	    </div>
	</div>
	<div class="tab-pane" id="tabcontentblank">
	    <div class="tabheader">		
	    <h4>Choose a blank image</h4>
	    </div>
	    <div class="blank_gallery">
	    <ul>
		<li><img src="components/com_nge/assets/images/placeholder/image_blue.jpg"></li>
		<li><img src="components/com_nge/assets/images/placeholder/picture.jpg"></li>
		<li><img src="components/com_nge/assets/images/placeholder/picture_big.jpg"></li>
		<li><img src="components/com_nge/assets/images/placeholder/gray_image.jpg"></li>
	    </ul>
	    <ul>
		<li><img src="components/com_nge/assets/images/placeholder/face.png"></li>
		<li><img src="components/com_nge/assets/images/placeholder/person.jpg"></li>
	    </ul>
	    </div>
	</div>					
	<div class="tab-pane" id="tabcontentdummy">
	    <div class="tabheader">
		<ul>
                    <li><h4>Choose a sample image. It will be copied onto your website.</h4></li>
                    <li>
                        <div class="btn-toolbar">
                            <div class="btn-group">
                              <a class="btn" href="#"><i class="icon-align-left">V</i></a>
                              <a class="btn" href="#"><i class="icon-align-center">C</i></a>
                              <a class="btn" href="#"><i class="icon-align-right">H</i></a>
                            </div>
                        </div>
                    </li>
                </ul>
	    </div>
	    <ul class="gallery">
	    <?php
	    for ($i=0;$i<20;$i++){
		echo '<li><a href="#"><img src="https://unsplash.it/120/120?image='.$i.'" /></a></li>';
	    }
	    ?>
            </ul>
	</div>
    </div>
</div>
<script>
    jQuery(window).ready(function() {         
        var elementObject = jQuery.parseJSON(jQuery(_params.element).attr("data-nge"));
        var oldImageName = elementObject.name;
        var currentImageName;
        var ngeWindow = jQuery(window);
        var ngeNavTabsHeight = jQuery("#nge-nav-tabs").height() + 25;
        var ngeElfinder = jQuery("#elfinder").elfinder({
            url : "<?php echo JUri::root(); ?>index.php?option=com_nge&view=field_ngefilemanager&format=raw",
            height: ngeWindow.height() - ngeNavTabsHeight,
            resizable: true,
            uiOptions : {
                toolbar : [
                    ["back", "forward"],
                    ["mkdir", "upload"],
                    ["rm", "rename"],
                    ["search"],
                    ["view"]
                ],
                navbar : {
                    minWidth : 150,
                    maxWidth : 500
                }
            },
            contextmenu : {
                navbar : ["open", "rm", "info"],
                cwd    : ["back", "|", "upload", "mkdir", "|", "info"],
                files  : ["rm", "rename", "info"]
            },
            onlyMimes: ["image"],
            getFileCallback: function(imgObject) {		        		
                var regex = "images.*";
                var match = imgObject.url.match(regex);	
                currentImageName = decodeURI(match[0]);
                _params.refresh(_params.element, decodeURI(match[0]));
            }
        }).elfinder("instance");

        ngeWindow.resize(function(){
            var win_height = ngeWindow.height();
            if( ngeElfinder.options.height !== win_height ){
                resizeElFinder(ngeElfinder, (win_height-ngeNavTabsHeight));
            }
        });
        
        var elFinderReziseTimeOut;
        var resizeElFinder = function(elfinder, height){
            if(typeof elFinderReziseTimeOut !== 'undefined'){
                clearTimeout(elFinderReziseTimeOut);
            }

            var elFinderReziseTimeOut = setTimeout(function(){ 
                elfinder.resize("auto",height);
            }, 200);
        };

        submit = function(){
            jQuery("#ngeinlinebody").hide();
            _params.submit(_params.element, oldImageName, currentImageName);
        };

        cancel = function(){
            jQuery("#ngeinlinebody").hide();
            _params.cancel(_params.element, oldImageName, currentImageName);
        };
    });
</script>