<?php
/**
 * @version     1.0.0
 * @package     com_nge
 * @copyright   Copyright (C) 2013. Tous droits réservés.
 * @license     GNU General Public License version 2 ou version ultérieure ; Voir LICENSE.txt
 * @author      Teatis <administration@teatis.com> - http://www.teatis.com
 */
// no direct access
defined('_JEXEC') or die;

//Using Nge API	
$partTable = NGE::part('tables.table');
//$partTable->loadPart($part);
$partTable->content->source = "data";
$partTable->content->data = $this->components;
$partTable->title = "data";
/*$partTable->navigation->paging->display = "1";
$partTable->navigation->searching = "1";
$partTable->navigation->ordering = "1";
$partTable->navigation->resizing = "1";
$partTable->navigation->info = "1";*/

    $list = array();
    $list['com_content:archive'] =	array('articles', 'stack');
    $list['com_content:article'] =		array('articles', 'file-text2');
    $list['com_content:categories'] =	array('articles', 'list');
    $list['com_content:category'] =	array('articles', 'list');
    $list['com_content:category:blog'] =	array('articles', 'menu');
    $list['com_content:featured'] =	array('articles', 'trophy');
    $list['com_content:form'] =		array('articles', 'plus');
    $list['com_config:config'] =		array('system', 'cogs');
    $list['com_config:template'] =	array('system', 'stack');
    $list['com_contact:categories'] =	array('contact', 'list');
    $list['com_contact:category'] =	array('contact', 'list');
    $list['com_contact:contact'] =	array('contact', 'stack');
    $list['com_finder:search'] =		array('content', 'search');
    $list['com_k2:item'] =		array('k2', 'file-text2');
    $list['com_k2:item:form'] =		array('k2', 'file-text2');
    $list['com_k2:itemlist:category'] =	array('k2', 'list');
    $list['com_k2:itemlist:tag'] =		array('k2', 'list');    
    $list['com_k2:itemlist:user'] =	array('k2', 'list');        
    $list['com_k2:latest:latest'] =	array('k2', 'history');
    $list['com_newsfeeds:categories'] =	array('content', 'list');
    $list['com_newsfeeds:category'] =	array('content', 'list');
    $list['com_newsfeeds:newfeed'] =	array('content', 'history');
    $list['com_search:search'] =		array('content', 'search');
    $list['com_tags:tags'] =		array('content', 'list');
    $list['com_tags:tag'] =		array('content', 'link');
    $list['com_tags:tag:list'] =		array('content', 'list');
    $list['com_users:login'] =		array('users', 'unlocked');
    $list['com_users:login:logout'] =	array('users', 'lock');
    $list['com_users:profile'] =		array('users', 'user');
    $list['com_users:profile:edit'] =	array('users', 'user');
    $list['com_users:registration'] =	array('users', 'user-plus');
    $list['com_users:remind'] =		array('users', 'mail4');
    $list['com_users:reset'] =		array('users', 'cancel-circle');
    $list['com_weblinks:categories'] =	array('content', 'list');
    $list['com_weblinks:category'] =	array('content', 'list');
    $list['com_weblinks:form:edit'] =	array('content', 'link');
    $list['com_wrapper:wrapper'] =	array('content', 'sphere');


foreach ($this->components as $component){
    foreach ($component as $view){
	$view->title = NGE::translate($view->title);
	$view->description = NGE::translate($view->description);
	$view->component = $view->request['option'];
	$view->view = $view->request['view'];
	$view->layout = isset($view->request['layout'])? $view->request['layout'] : '';
	$view->glyph = '';
	$path = $view->component . ':' . $view->view . ($view->layout !='' ? ':' . $view->layout : '');
	if (isset($list[$path])){
	    $view->glyph = $list[$path][1];
	    $lists[$list[$path][0]][] = $view;
	}
	else {
	    $view->glyph = 'file-empty';
	    $lists['others'][] = $view;
	}	
    }
}

function getComponentsList($items){
	$html = array();
	$html[] = '<div class="ngemainbarcomponentlist">';
        foreach ($items as &$item){
	    $name    = htmlspecialchars($item->title);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->description)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->description)), 90);
	    $html[] = '<div id="thumbs_component_'.$item->component . '_' . $item->view.'" class="ngecomponent ngedraggable-mainbar" data-ngedraggable-dest="article position" data-ngedraggable-type="component" data-ngedraggable-ref="'.$item->component . ',' . $item->view.'" data-ngedraggable-title="'.$name.'" data-ngedraggable-component="'.$item->component.'" title="'.$name.'" data-content="'.$desc.'" data-glyph="'.$item->glyph.'"><div><span class="icomoon icomoon-' . $item->glyph . '"></span>'.$name.'</div></div>';
    }
    $html[] = '</div>';
    return implode($html);
}    

echo NgeContenthelper::renderStyleSheets();
echo NgeContenthelper::renderScripts();
?>

<ul id="componenttabs" class="nav nav-tabs" data-tabs="tabs">
	<li class="active"><a href="#tabcomponentscontent" data-toggle="tab">CONTENT</a></li>
	<li><a href="#tabcomponentsarticles" data-toggle="tab">ARTICLES</a></li>
	<li><a href="#tabcomponentsusers" data-toggle="tab">USERS</a></li>
	<li><a href="#tabcomponentssystem" data-toggle="tab">SYSTEM</a></li>
	<li><a href="#tabcomponentsk2" data-toggle="tab">K2</a></li>
	<li><a href="#tabcomponentsothers" data-toggle="tab">OTHERS</a></li>
    </ul>
    <div class="tab-content">
	<div class="tab-pane active" id="tabcomponentscontent">
	    <?php echo getComponentsList($lists['content']); ?>
	</div>						
	<div class="tab-pane" id="tabcomponentsarticles">
	      <?php echo getComponentsList($lists['articles']); ?>
	</div>						
	<div class="tab-pane" id="tabcomponentsusers">
	    <?php echo getComponentsList($lists['users']); ?>
	</div>
	<div class="tab-pane" id="tabcomponentssystem">
	    <?php echo getComponentsList($lists['system']); ?>
	</div>
	<div class="tab-pane" id="tabcomponentsk2">
	    <?php echo getComponentsList($lists['k2']); ?>
	</div>
	<div class="tab-pane" id="tabcomponentsothers">
	    <?php echo getComponentsList($lists['others']); ?>
	</div>
	  <div style="max-width:600px;margin-left:65px;margin-right:30px;">
	    	<h3 id="componenttitle"></h3>
			<div style="position:relative; overflow:hidden;">
				<div id="componentglyph" style="margin-right:20px;float:left;">				    
				</div>
				<div id="componentdescription">			    

				</div>
			</div> 
	  </div>
    </div>

<style>
    .tab-pane {
	max-height:320px;
	overflow:auto;
    }
    
.ngemainbarcomponentlist{
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: wrap;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        /*-webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;*/
        -webkit-align-content: flex-start;
        -ms-flex-line-pack: start;
        align-content: flex-start;
        -webkit-align-items: flex-start;
        -ms-flex-align: start;
        align-items: flex-start;
    }
    
    .ngemainbarcomponentlist > div{
        height: 148px;
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 148px;
        -ms-flex: 0 1 148px;
        flex: 0 1 148px;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
        border : 1px solid #F9BEA9;
	/*color:#F9BEA9;*/
	color:#888;
        cursor: pointer;
        -webkit-transition: all .2s ease-in-out;
        -moz-transition: all .2s ease-in-out;
        -o-transition: all .2s ease-in-out;
        transition: all .2s ease-in-out;
        overflow: hidden;
        margin:2px;
        
        padding:10px;
        box-sizing: border-box;
        
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: wrap;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
        -webkit-align-content: flex-start;
        -ms-flex-line-pack: start;
        align-content: flex-start;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
    }
    
    .ngemainbarcomponentlist > div > div{
        text-align:center;
        font-size: 14px;
    }
    
    .ngemainbarcomponentlist > div:hover{
        background-color: #F77;
        color: #FFFFFF;
    }
    
    .ngemainbarcomponentlist span{
	font-size:36px;
	display:block;
	margin-bottom:10px;
    }
    
    #componenttabs li {
	color:#fff;
	background-color: #F9BEA9 !important;
	margin-right:1px;
    }
    #componenttabs li.active, #componenttabs li:hover {
	background-color: #F77 !important;
    }
    
    #componenttabs >li a{
    color:#FFFFFF !important;
}
#componenttabs li:hover a, 
#componenttabs li.active a{
    background-color: #F77 !important;    
    border: none;
}
    
    
    
    #componenttitle{
	color:#888;
	margin-top:20px;
	margin-bottom:15px;
    }
    
    #componentglyph{
	font-size:36px;
	color:#888;
    }
    
</style>
<script>
//jQuery(".ngecomponent").popover({trigger:"hover", placement:"bottom", container:"#ngemainbar-content"});
 jQuery(".ngecomponent").click(function(){
	//var dataPopover = jQuery(this).data('popover');
	//dataPopover.tip().find('.popover-content').html("<?php echo JText::_('COM_NGE_HELP_TOOLBAR_DRAG'); ?><button id='nge-editing-bar-lock-help' class='btn btn-primary pull-right' style='margin:10px;' onclick='showHelp();'><?php echo JText::_('COM_NGE_HELP'); ?></button>");
});
jQuery(".ngecomponent").hover(function(){
	jQuery("#componenttitle").html(jQuery(this).attr('title'));
	   jQuery("#componentdescription").html(jQuery(this).attr('data-content'));
	   jQuery("#componentglyph").html('<span class="icomoon icomoon-' + jQuery(this).data('glyph') + '"></span>');
});



</script>
