<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * Full form for editing part
 * Saving all properties as new ones (replace)
 */
// no direct access
defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS.'/ngefeatures.php');

//Data used in part configuration forms, in tags used to load subforms in ajax
$data = array();
$data["mode"] = $this->mode;
$data["key"] = 'pattern:' . $this->key;
?>
<div class="row-fluid">
    <div class="span3">
	<?php
	    //Form rendering
	    //First form : pattern options
	    //Setting default values of the form
	    NGEFields::setData($this->settingsObject);
	?>
	<form id="patternform" class="ngepatternform"  style="padding: 20px;">
	    <?php
		$options = array('attributes'=>'style="width:100%;"');
		echo NGEFields::hidden('id');
		echo NGEFields::hidden('type');
		echo NGEFields::hidden('name');
		echo NGEFields::text('title', 'COM_NGE_TITLE', '', '', $options);

		$options = array('attributes'=>'style="width:100%;"');
		echo NGEFields::textarea('description', 'COM_NGE_PATTERN_DESCRIPTION', 'COM_NGE_PATTERN_DESCRIPTION_DESCRIPTION', '', $options);
	    ?>
	</form>
	<div id="pattern_preview_spinner">
                <div align="center" class="nge-loading1">
                    <div class="nge-loading1-container-general">
                        <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_1"> </div></div>
                        <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_2"> </div></div>
                        <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_3"> </div></div>
                        <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_4"> </div></div>
                    </div>
                </div>
            </div>

	<div id="pattern_preview_container"></div>
    </div>
    <div class="span9" style="border-left:1px solid #ddd;background-color:#fff;">
	<div><ul class="pattern-menu nav nav-pills" data-tabs="tabs">
	<?php if ($this->contentFilename != ''){ ?>
                <li id="licontent" title="<?= NGE::translate('COM_NGE_CONTENT_TAB_DESC') ?>"><a href="#tabcontent" data-toggle="tab"><span class="icomoon icomoon-pencil2"></span></a></li>
	<?php } ?>
                <li id="lioptions" class="active" title="<?= NGE::translate('COM_NGE_OPTIONS_TAB_DESC') ?>"><a href="#taboptions" data-toggle="tab"><span class="icomoon icomoon-paint-format"></span></a></li>
                <li id="lidisplay" title="<?= NGE::translate('COM_NGE_ACCESS_TAB_DESC') ?>"><a href="#tabaccess" data-toggle="tab"><span class="icomoon icomoon-user"></span></a></li>
	 </ul></div>
	<div class="tab-content">
	    <div class="tab-pane" id="tabcontent">
		<div class="headconfigtitle"><?php echo NGE::translate('COM_NGE_SAMPLECONTENT'); ?></div>
		<?php 
		if ($this->contentFilename != ''){
			NGEFields::setData($this->contentObject);
			include $this->contentFilename; 
		}?>
	    </div>
	    <div class="tab-pane active" id="taboptions">
		<?php 
		    NGEFields::setData($this->paramsObject);
		    include $this->optionsFilename; ?>
	    </div>
	    <div class="tab-pane" id="tabaccess">
	    <form id="accessform" class="ngepatternform form-horizontal">
		<div class="headconfigtitle"><?php echo NGE::translate('COM_NGE_ACCESS'); ?></div>
		<?php
		    if (NGEFeatures::enabled('nge.premium')){
			NGEFields::setData($this->settingsObject);
			echo NgeFields::radio('access.mode','COM_NGE_PATTERNS_ACCESS_MODE','COM_NGE_PATTERNS_ACCESS_MODE_DESC','all', array(
			    array('all','COM_NGE_ALL'), 
			    array('creator','Propriétaire'),
			    array('usergroup','Groupe','data-target="#accessform_usergroups"')
			));
			echo '<div id="accessform_usergroups">';
			$user = JFactory::getUser();
			if ($user->authorise('core.admin')){
			    // user access level
			    echo NgeFields::select('access.usergroup','COM_NGE_PATTERNS_ACCESS_USERGROUP','','', false, 0, 
				array(
				    "ajax" => false,
				    "options" => null,
				    "target" => "joomla.usergroups",
				    "multiple" => true
				)
			    );
			}
			else {
			    echo NGE::translate('JERROR_ALERTNOAUTHOR');
			}
			echo '</div>';
		    }
		?>
	    </form>		
	    </div>
	</div>
    </div>
</div>
<script>
        var timerPreviewPattern; 
    //Creating javascript variables to be used by the preview script
    key = "<?php echo $this->key; ?>";
/*    caller = "<?php echo $this->caller; ?>";*/
    mode = "<?php echo $this->mode; ?>";	
    
    //Hiding pattern fields, when loading config_options with pattern fields.
    jQuery('#field_options_source').parent().parent('.control-group').remove();
    jQuery('#field_options_pattern').remove();
    jQuery('div.ngeformtopattern').remove();
    //jQuery( document ).ready(function() {
        jQuery(".ngefield-pattern-toolbar").remove();
    //});

jQuery(document).on( "ngeConfigChange", function() {
	    previewPattern();
    });

    function patternPreviewOnLoad() {
	patternPreviewIsLoading = true;
	/* Start timer. If more than 30 seconds : displays error */
	//timerPreviewPart = setTimeout(partPreviewOnTimeout, 30000);
    }
    function patternPreviewOnLoaded() {
	clearTimeout(timerPreviewPattern);
	patternPreviewIsLoading = false;
	//previewHasError = false;
    }


    var patternPreviewIsLoading = false; // Preview is being loaded in ajax, but has not responded yet
    var previewInitpageLoaded = false; // Initial preview page is loaded. This page is a full web site html page with all scripts and css styles
/*
 * animation : show fade effect O/N
 * @returns {undefined}
 */
    function previewPattern(animation){
	if (!patternPreviewIsLoading) { //an ajax loading is already in course
	    patternPreviewOnLoad();
	    /*Get all form data*/
	    //Warning, must specify forms id. selector('form') can take unwanted popup inline forms
	    //All forms to be included in preview or saving must have one of these classes 

	    var $frm = jQuery('form.ngepatternform, form.ngecontentform, form.ngeoptionsform, form.ngeinternalform');
	    
	    dataAjax = JSON.stringify($frm.serialize());
	    dataAjax = dataAjax.replace(/\"/g, "");
	    
	    if (!previewInitpageLoaded) { /* No initial preview page already loaded. This page is a full html with all current styles */
		jQuery("#pattern_preview_spinner").show();
		jQuery("#pattern_preview_container").css('visibility', 'hidden');
		if(jQuery("#iframepatternpreview")[0] === undefined){ /*The first time and iframe not created*/
		    jQuery.ajax({
			/*url: "<?= NGEURL_ROOT; ?>index.php?option=com_nge&view=pattern&layout=preview&nge=0&name=<?= $this->settingsObject['name'] ?>",*/
			url: "<?= NGEURL_ROOT; ?>index.php?option=com_nge&view=pattern&layout=preview&nge=0&mode=<?= $this->mode ?>&key=<?= $this->key ?>",
			data: dataAjax,
			type: 'POST',
			success: function (result) {
				var newIframe = document.createElement('iframe');
				newIframe.width = '100%';
				newIframe.height = '500px';
				newIframe.src = 'about:blank'; 
				newIframe.id = 'iframepatternpreview';
				newIframe.frameBorder ="0";
				jQuery("#pattern_preview_container").html("");
				document.getElementById('pattern_preview_container').appendChild(newIframe);
				newIframe.contentWindow.document.open();
				newIframe.contentWindow.document.write(result);
				newIframe.contentWindow.document.close();
				jQuery("#pattern_preview_spinner").fadeOut( "fast", function() {
				    jQuery("#pattern_preview_container").css("visibility", "visible");
				});
				previewIsLoading = false;
				previewInitpageLoaded = true;
			}
		    });
		}
	    }else{ /*Iframe already created*/
		    document.getElementById("iframepatternpreview").contentWindow.loadPatternHtml('<?= $this->settingsObject['name'] ?>', dataAjax, animation);
	    }
	}
    };
    
    
    
</script>
<style>

    .pattern-menu{
	background-color:#FF9800;
	margin-bottom:0px;
    }
    .pattern-menu li a{
	color :#fff;
	font-size : 16px;
	border-radius: 0px;
    }
    
    .pattern-menu >li.active >a, .pattern-menu >li.hover >a{
	background-color: #FFAA31;
    }
    .pattern-menu >li >a:focus, .pattern-menu >li >a:hover, .pattern-menu >li >a:active{
	background-color: #FFAA31;
    }
    
    
    .headconfigtitle{
	color:#fff;	
	font-size:16px;
	background-color:#FF9800;
	padding:8px 20px 8px 20px;
    }
    
ul.nav-tabs >li{
	    border-right: 1px solid #dddddd;
    }
    ul.nav-tabs li.active {
	    background-color:#95A5B3;
    }
    .nav-tabs>.active>a, .nav-tabs>.active>a:hover, .nav-tabs>.active>a:focus {	
	    border:none;
	    border-bottom-color: initial;
	    background-color:initial;
	    color:#ffffff;
    }	
    
    #pattern_preview_container{
	transform: scale(0.5);
	transform-origin: 0 0 0;
	width: 200%;
    }
    
#patternoptions{
    display:none;
}

.headconfigbar {
    background-color: #FF9800;
    border-bottom:none;
}

ul.headconfigbar >li{
    background-color:#FF9800;
    border:none;
    border-right: none !important;
}

ul.headconfigbar >li.active{
    background-color:#FFAA31;    
    border-bottom: 4px solid #fff;
}

ul.headconfigbar >li:hover{
    background-color:#FFAA31;    
}

ul.headconfigbar >li a{
    background-color:transparent;
}
ul.headconfigbar >li:hover a{
    background-color:transparent;
}

.headconfigbar >li a{
    color:#fff;
    border:none;
}


    </style>