<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
?>
<style>
    #field_font_list{
        height: 100%;
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;    
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-flex-wrap: nowrap;
        -ms-flex-wrap: nowrap;
        flex-wrap: nowrap;
        -webkit-justify-content: flex-start;
        -ms-flex-pack: start;
        justify-content: flex-start;
        -webkit-align-content: stretch;
        -ms-flex-line-pack: stretch;
        align-content: stretch;
        -webkit-align-items: flex-start;
        -ms-flex-align: start;
        align-items: flex-start;
    }
    #nge-manager-fonts-toolbar{
        text-align:right;
        margin-bottom:0px;
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 auto;
        -ms-flex: 0 1 auto;
        flex: 0 1 auto;
        -webkit-align-self: stretch;
        -ms-flex-item-align: stretch;
        align-self: stretch;
    }
    #field_font_list .tab-content{
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        -webkit-align-self: stretch;
        -ms-flex-item-align: stretch;
        align-self: stretch;
        display: flex;
        display: -ms-flexbox;
        display: -webkit-flex;
    }
    #field_font_list .tab-content .tab-pane .nge-manager-fonts-container-row{
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: nowrap;
        -ms-flex-wrap: nowrap;
        flex-wrap: nowrap;
        -webkit-justify-content: flex-start;
        -ms-flex-pack: start;
        justify-content: flex-start;
        -webkit-align-content: stretch;
        -ms-flex-line-pack: stretch;
        align-content: stretch;
        -webkit-align-items: stretch;
        -ms-flex-align: stretch;
        align-items: stretch;
        height:100%;
    }
    #field_font_list .tab-content .tab-pane .nge-manager-fonts-container-row div:nth-child(1){
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 30%;
        -ms-flex: 0 1 30%;
        flex: 0 1 30%;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
    }
    #field_font_list .tab-content .tab-pane .nge-manager-fonts-container-row div:nth-child(2){
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 70%;
        -ms-flex: 0 1 70%;
        flex: 0 1 70%;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
    }
    
    #field_font_list .nge-manager-fonts-container-column{
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-flex-wrap: nowrap;
        -ms-flex-wrap: nowrap;
        flex-wrap: nowrap;
        -webkit-justify-content: flex-start;
        -ms-flex-pack: start;
        justify-content: flex-start;
        -webkit-align-content: stretch;
        -ms-flex-line-pack: stretch;
        align-content: stretch;
        -webkit-align-items: flex-start;
        -ms-flex-align: start;
        align-items: flex-start;
        height:100%;
    }
    
    #field_font_list .nge-manager-fonts-container-column div:nth-child(1){
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 auto;
        -ms-flex: 0 1 auto;
        flex: 0 1 auto;
        -webkit-align-self: stretch;
        -ms-flex-item-align: stretch;
        align-self: stretch;
    }
    #field_font_list .nge-manager-fonts-container-column div:nth-child(2){
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        -webkit-align-self: stretch;
        -ms-flex-item-align: stretch;
        align-self: stretch;
    }
    #field_font_list .manager_body{
        border-left: 1px solid #ddd;
        box-sizing: border-box;
        overflow: auto;
    }
    #field_font_list .manager_description{
        padding: 11px;
        box-sizing: border-box;
        text-align: justify;
        overflow: auto;
    }
    #field_font_list .ngefonttable thead{
        background-color:#646D9C;
        font-size:18px;
        color:#FFFFFF;
    }
    #field_font_list .ngefonttable thead tr th{
        padding:5px;
    }
    #field_font_list .ngefonttable tbody tr td{
        padding:5px;
        text-align:center;
    font-size: 22px;
    }
    #field_font_list .ngefonttable tbody tr:hover{
        background-color:#f6f6f6;
    }
    #field_font_list .ngefonttable tbody tr:nth-child(even){
        background-color:#EDF4F9;
    }
    .ngefontname, .ngebrowserfontname{
        cursor : pointer;
    }
    .ngeloadingfont:before{
        background-image: url('<?php echo NGEURL_ASSETS; ?>images/spinner.gif');
        background-size: 12px 12px;
        width: 12px;
        height: 12px;
        content: "";
        display: inline-block;
    }	
    input[type="text"].nge-manager-search{
        margin:4px;
    }
    
    #nge-manager-google-toolbar{
        text-align:right;
        border-bottom:1px solid #ddd;
    }
</style>
<div id="field_font_list">
    <div id="nge-manager-fonts-toolbar">
	<div id="ngeFontSelection">
            <ul class="nav nav-tabs headconfigbar" data-tabs="tabs">
                <li class="active"><a href="#nge-manager-fonts-tab-browser" data-toggle="tab"><?php echo NGE::translate('COM_NGE_FIELD_FONT_BROWSER'); ?></a></li>			
                <li><a href="#nge-manager-fonts-tab-google" data-toggle="tab"><?php echo NGE::translate('COM_NGE_FIELD_FONT_GOOGLE'); ?></a></li>
             </ul>
    	</div>
    </div>
    <div class="tab-content">
        <div class="tab-pane active" id="nge-manager-fonts-tab-browser" style="width:100%;">			    
            <div class="nge-manager-fonts-container-row" id="ngeListBrowserFonts">
                <div class="manager_description">
                    <h3><?php echo NGE::translate('COM_NGE_FIELD_FONT_BROWSER_FONTS'); ?></h3>
                    <?php echo NGE::translate('COM_NGE_FIELD_FONT_BROWSER_FONTS_LEGEND'); ?>
                </div>
                <div class="manager_body">
                    <table class="ngefonttable stripe hover" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th class="sort" data-sort="title"><?php echo JText::_('COM_NGE_FONT'); ?></th>
                                <th class="sort" data-sort="type"><?php echo JText::_('COM_NGE_FONTTYPE'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            <?php
                            foreach($this->browserFonts as $font){
                                $font_display = str_replace("'",'',$font[0]);
                                echo '<tr>
                                    <td class="title" style="display:none;">'.$font[0].'</td>
                                    <td class="ngebrowserfontname" style="font-family:'.$font[0].' ,'.$font[1].';" data-font="'.$font[0].'" data-family="'.$font[1].'">
                                                    '.$font_display.'
                                            </td>
                                            <td>'.$font[1].'</td>
                                    </tr>
                                ';
                            } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="tab-pane" id="nge-manager-fonts-tab-google" style="width:100%;">
            <div class="nge-manager-fonts-container-column" id="ngeListGoogleFonts">
                <div id="nge-manager-google-toolbar">
                    <input type="text" class="search nge-manager-search" placeholder="<?php echo JText::_('COM_NGE_SEARCH'); ?>" autofocus>
                </div>			    
                <div class="nge-manager-fonts-container-row">			
                    <div class="manager_description">
                        <h3><?php echo NGE::translate('COM_NGE_FIELD_FONT_GOOGLE_FONTS'); ?></h3>
                        <img width="53" alt="Google" src="<?php echo NGEURL_ROOT; ?>components/com_nge/views/field_ngefont/assets/nge_google_logo.png"><br/>
                        <?php echo NGE::translate('COM_NGE_FIELD_FONT_GOOGLE_FONTS_LEGEND'); ?>
                    </div>
                    <div class="manager_body" id="googlelistscroll">
                        <table class="ngefonttable stripe hover" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th class="sort" data-sort="title"><?php echo JText::_('COM_NGE_FONT'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="list">
                                <?php
                                $fontRowsCount = 0;
                                foreach($this->googleFonts as $font){
                                    $font_name = $font->family;
                                    $fontClass = str_replace(' ','',strtolower($font->family));
                                    echo '<tr><td style="display:none;" class="title">'.$font->family.'</td><td class="ngefontname '. $fontClass.'" data-font="'.$font_name.'" data-family="'.$font->family.'">'.$font->family.'</td></tr>';
                                }					
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>					
    </div>
    <script>
        function checkInView(container,elem,partial)
        {
            var contHeight = container.height();
            var contTop = container.scrollTop();
            var contBottom = contTop + contHeight ;

            var elemTop = jQuery(elem).offset().top - container.offset().top;
            var elemBottom = elemTop + jQuery(elem).height();

            var isTotal = (elemTop >= 0 && elemBottom <=contHeight);
            var isPart = ((elemTop < 0 && elemBottom > 0 ) || (elemTop > 0 && elemTop <= container.height())) && partial ;

            return  isTotal  || isPart ;
        }
        
        (function() {        
            var timerScroll, timerListSearch;
            var $listGoogleFontContainer = jQuery("#googlelistscroll");
            var firstShowGoogleFont = false;
            $listGoogleFontContainer.bind('scroll',function () {
                clearTimeout(timerScroll);
                timerScroll = setTimeout( refresh , 350 );
            });
            var loadbatchFonts = function($container){
                var familiesString = new Array();

                jQuery(".ngefontname").removeClass("ngevisiblefont");
                jQuery.each(jQuery(".ngefontname"),function(i,e){
                    if(checkInView($container, jQuery(e),true)){
                        var $font = jQuery(e);
                        var fontName = $font.data('font');
                        $font.addClass("ngevisiblefont");
                        if(!$font.hasClass("ngeisloadedfont")){
                            $font.addClass("ngeloadingfont");
                            familiesString.push(fontName);
                        }
                        if (familiesString.length != 0){
                            WebFont.load({
                                google: {
                                    families: familiesString
                                },
                                fontactive: function(familyName, fvd) {
                                    var currentFont = familyName.toLowerCase();
                                    currentFont = currentFont.replace(/ /g,"");
                                    jQuery("."+currentFont).html(jQuery("."+currentFont).data("nge-font-family")).css({
                                        "font-family": familyName,
                                        "font-weight": "normal"
                                    }).removeClass("ngeloadingfont").addClass("ngeisloadedfont");
                                },
                                fontinactive: function(familyName, fvd) {
                                    /-*This event show font that have failed to be downloaded by WebFont*-/
                                    var currentFont = familyName.toLowerCase();
                                    currentFont = currentFont.replace(/ /g,"");
                                    jQuery("."+currentFont).parents("tr").remove();
                                }
                            });
                        }
                    }
                });
            };
            var refresh = function () { 
                loadbatchFonts($listGoogleFontContainer);
            };
            
            var googleFontoptions = {
                valueNames: [ 'title'],
                searchClass: 'nge-manager-search'
            };
            var googleFontList = new List('ngeListGoogleFonts', googleFontoptions);
            googleFontList.on('searchComplete', function(){
                clearTimeout(timerListSearch);
                timerListSearch = setTimeout( function(){
                    loadbatchFonts($listGoogleFontContainer);
                } , 350 );
            });
            
            /* Instanciate waypoints when activate, if not, doesnt work inside a tab */
            jQuery(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function (e) {
                if (!firstShowGoogleFont && jQuery(this).attr("href") === "#nge-manager-fonts-tab-google"){
                    $listGoogleFontContainer.trigger("scroll");
                    firstShowGoogleFont = true;
                }
            });
        })();
        
	/* Browser font list click management */
	jQuery(".ngebrowserfontname").click(function () {
	    var dataFont = jQuery(this).data('font');
	    $fieldFont.find(".ngefield-font-name")[0].value = dataFont;
	    $fieldFont.find(".ngefield-font-name").trigger("change");
	    jQuery("#ngeFontManager").modal("hide");	    
	});
	
	/* Google font list click management */
	jQuery(".ngefontname").click(function () {
            if(!jQuery(this).hasClass("ngeloadingfont")){
                var dataFont = jQuery(this).data('font');
                $fieldFont.find(".ngefield-font-name")[0].value = dataFont;
                $fieldFont.find(".ngefield-font-name").trigger("change");
                jQuery("#ngeFontManager").modal("hide");
            }else{
                ngetools.showNotification("Wait until the font preview was finished loading", "success", 2000, jQuery(this).closest(".manager_body"));
            }
	});
    </script>