<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com

 */
// no direct access
defined('_JEXEC') or die;

$lang = JFactory::getLanguage();
$tag = explode("-", $lang->getTag());
$tag_select2 = $tag[0];

$modal_id = JFactory::getApplication()->input->get('modalId','');
$old_img_path = JFactory::getApplication()->input->get('oldImgPath','');

//To flush browser cache when NGE version changes
$ngeVersion = '?'. NGE::version();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
    <head>
        <title>NGE elFinder manager</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2" />
        <?php
	echo '<link rel="stylesheet" type="text/css" href="' . NGEURL_ROOT . 'media/com_nge/jquery-ui/jquery-ui.min.css' . $ngeVersion .'" />';
	echo '<link rel="stylesheet" type="text/css" href="' . NGEURL_ROOT . 'media/com_nge/jquery-ui/themes/smoothness/jquery-ui.min.css' . $ngeVersion .'" />';
	?>
        <style>
            html, body{
                height:100%;
                margin: 0;
            };
        </style>
        <?php
	echo '<script src="' . NGEURL_MEDIA . 'jquery/jquery.min.js"></script>';	
	echo '<script src="' . NGEURL_ROOT . 'media/com_nge/jquery-ui/jquery-ui.min.js"></script>';
	echo '<script src="' . NGEURL_ROOT . 'media/com_nge/elfinder/js/elfinder.min.js"></script>';
	echo '<script src="' . NGEURL_ROOT . 'media/com_nge/elfinder/js/i18n/elfinder.' .$tag_select2 . '.js"></script>';
	echo '<script src="' . NGEURL_ROOT . 'media/com_nge/nge/ngetools.js"></script>';
	echo '<script src="' . NGEURL_ROOT . 'components/com_nge/helpers/editor/inline/editor.inline.js"></script>';
	?>
    </head>
    <body>
        <!-- Element where elFinder will be created (REQUIRED) -->
	<div id="ngeelfinder"></div>
        <script>
            initElfinder = function($element, oldImgPath){
                var currentType = "image";
                jQuery('#ngeelfinder').elfinder({
                    url : "<?php echo JUri::root(); ?>index.php?option=com_nge&view=field_ngefilemanager&format=raw&layout=connector&current_type="+currentType + "&<?php echo NGE::token(); ?>=1",
                    lang: "<?php echo $tag_select2; ?>",
                    height: jQuery('body').height(),
                    resizable: false,
                    onlyMimes: ["image"], /*display all images*/
                    cssAutoLoad  : [
                        '<?php echo JUri::root(); ?>media/com_nge/elfinder/themes/nge/theme1/theme-nge.css' //Specific NGE theme based on Material with adjustement and fixed bug : https://github.com/RobiNN1/elFinder-Material-Theme
                    ],
                    uiOptions : {
                        toolbar : [
                            ['search'],
                            ['view', 'sort', 'fullscreen'],
                            ['back', 'forward'],
                            // ['reload'],
                            // ['home', 'up'],
                            //['mkdir', 'mkfile', 'upload'],
                            ['mkdir', 'upload'],
                            //['open', 'download', 'getfile'],
                            //['info', 'quicklook'],
                            //['copy', 'cut', 'paste'],
                            ['resize', 'rename', 'download', 'duplicate', 'rm', 'info', 'quicklook']
                            //['extract', 'archive'],		    
                            //['help']
                        ]
                    },
                    getFileCallback: function(object) {
                        var regex, match;
                        var $modal = jQuery(window.parent.document.getElementById("<?php echo $modal_id; ?>"));
                        
                        /*switch(currentDirectory) {
                            case 'images':*/
                                regex = "images.*";
                                match = object.url.match(regex);
                                /*break;
                        }*/
                        
                        var currentImagePath = decodeURI(match.input);
                        if(currentImagePath !== oldImgPath){
			    var elementData = JSON.parse($element.attr('data-nge'));
			    var structureData = $element.closest('.ngeeditablestructure').data('nge');      

                            var storeInlineData = {
                                id : structureData.id,
                                type : structureData.type,
                                source : elementData.source,
                                value : decodeURI(match[0]),
                                callback : function(){
                                    var newElementDataNge = elementData;
                                    newElementDataNge.name = currentImagePath;
                                    $element.attr('data-nge', JSON.stringify(newElementDataNge));
                                    $element.find("img").attr("src", currentImagePath);
                                    $modal.find(".button-modalgeneral-cancel").trigger("click");
                                },
                                storeMessageCallback : function(){
                                    ngetools.showNotification("<?php echo JText::_('COM_NGE_JS_EDITING_CONTENT_SAVED'); ?>", "success", 2500, $element.closest("body"));
                                }
                            };

                            var ngeInline = new NgeInline(jQuery("body"));
                            ngeInline.store(storeInlineData);
			} 
                        
                        /*No activate the current event who launch preview in new window*/
                        return false;
                    }
                }).elfinder("instance");
            };
        </script>
    </body>
</html>