<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

// elfinder php file required
require_once NGEPATH_MEDIA . '/elfinder/php/autoload.php';

//User authorizations
    $user = JFactory::getUser();
    $userCanViewMedia = $user->authorise('core.edit', 'com_content');
    $userCanCreateMedia = $user->authorise('core.create', 'com_media');
    $userCanRemoveMedia = $user->authorise('core.delete', 'com_media');
    
//Joomla media settings
    $mediaParams = JComponentHelper::getParams( 'com_media' );
    $joomla_upload_maxsize =	    $mediaParams->get( 'upload_maxsize' );
    $joomla_image_path =	    $mediaParams->get( 'image_path' );
    
//Directories
//Main directory from Joomla media settings
$mediaDirectoryPath = JPATH_SITE . '/' . $joomla_image_path . '/';
$mediaDirectoryUrl = JURI::root() . '/' . $joomla_image_path . '/';

// thumbs cache, in Joomla cache directory
//Create cache directory if not exists. A warning is displayed when installing the extension, to allow this directory in admintools
//Todo : to be changed if JPATH_CACHE constant is modified in Joomla
if(!is_dir(JPATH_ROOT . "/cache/nge/elfinder")){
    jimport('joomla.filesystem.folder');
    JFolder::create(JPATH_ROOT . "/cache/nge/elfinder");
}
//Use cache directory or elfinder thumbs
if(is_dir(JPATH_ROOT . "/cache/nge/elfinder")){
    $cacheDirectoryPath = JPATH_ROOT . "/cache/nge/elfinder";
    $cacheDirectoryUrl = NGEURL_ROOT . "cache/nge/elfinder"; 
}
else { //If cache directory not available, use a subdirectory if images
    JFolder::create(JPATH_SITE . '/' . $joomla_image_path . '/nextgeneditor/cache');
    $cacheDirectoryPath = JPATH_SITE . '/' . $joomla_image_path . '/nextgeneditor/cache';
    $cacheDirectoryUrl = JURI::root() . '/' . $joomla_image_path . '/nextgeneditor/cache';
}

//Mime types	
//$filesType = JFactory::getApplication()->input->get('current_type', '');
//switch ($filesType) {
//    case 'video':
//        $mimeType = ["video"]; // display all images
//        break;
//    case 'image':
//        $mimeType = ["image"]; // display all videos
//        break;
//    case 'audio':
//        $mimeType = ["image"]; // display all videos
//        break;
//    case 'flash':
//        $mimeType = ["application/x-shockwave-flash"];
//        break;	    
//    case 'pdf':
//        $mimeType = ["application/pdf"];
//        break;	    
//    default	:
//        $mimeType = '';
//        break;
//}

// Documentation for connector options:
// https://github.com/Studio-42/elFinder/wiki/Connector-configuration-options

//Connector options for Joomla media Local files
    $joomlaMediaRoot = array(
            'driver'        => 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
            'path'          => $mediaDirectoryPath,         // path to files (REQUIRED)
            'URL'           => $mediaDirectoryUrl, // URL to files (REQUIRED)
            'uploadTempPath' => $cacheDirectoryPath, //Path relative because we are outside the current server. LOcked access to this folder if inside the current path folder
            'commonTempPath ' => $cacheDirectoryPath, //Path relative because we are outside the current server. LOcked access to this folder if inside the current path folder
            'tmbPath' => $cacheDirectoryPath, //Path relative because we are outside the current server. LOcked access to this folder if inside the current path folder
            'tmbURL'  => $cacheDirectoryUrl, //Url relative because we are outside the current server.
            'tmbSize'  => 192, 
            'uploadDeny'    => array('all'),                // All Mimetypes not allowed to upload
            'uploadOrder'   => array('deny', 'allow'),      // allowed Mimetype `image` only
            'accessControl' => 'access'                     // disable and hide dot starting files (OPTIONAL)
        );

    //ACL on create/edit/remove
    $disabledCommands = array();
    if ($userCanCreateMedia){
	//Allowed mime types
	$joomlaMediaRoot['uploadAllow'] = array('image',
	    'video',
	    'application/pdf pdf',
	    'application/x-shockwave-flash swf',
	    'application/msword doc dot',
	    'application/vnd.ms-excel xls xlm xla xlc xlt xlw'
	    );
	//Max upload size
	if ($joomla_upload_maxsize != 0){ //0 = unlimited size
	    $joomlaMediaRoot['uploadMaxSize'] = $joomla_upload_maxsize . 'M';
	}	
    }
    else { //Cannot create or edit, commands disabled
	$disabledCommands = array('mkdir', 'mkfile', 'upload', 'copy', 'cut', 'paste', 'duplicate',  'rename', 'edit', 'extract', 'archive', 'resize');
    }
    if (!$userCanRemoveMedia)
	$disabledCommands[] = 'rm';
    
    if (count($disabledCommands) != 0)
	$joomlaMediaRoot['disabled'] = $disabledCommands;    

    
$connectorOptions = array(
    'roots' => array(
       $joomlaMediaRoot
    )
);

// run elFinder
$connector = new elFinderConnector(new elFinder($connectorOptions));
$connector->run();