<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com

 */
// no direct access
defined('_JEXEC') or die;

$lang = JFactory::getLanguage();
$tag = explode("-", $lang->getTag());
$tagLang = $tag[0];

//To flush browser cache when NGE version changes
$ngeVersion = '?'. NGE::version();
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
    <head>
        <title>NGE elFinder manager</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2" />
	<?php
	echo '<link rel="stylesheet" type="text/css" href="' . NGEURL_ROOT . 'media/com_nge/jquery-ui/jquery-ui.min.css' . $ngeVersion .'" />';
	echo '<link rel="stylesheet" type="text/css" href="' . NGEURL_ROOT . 'media/com_nge/jquery-ui/themes/smoothness/jquery-ui.min.css' . $ngeVersion .'" />';
	?>
        <style>
            html, body{
                height:100%;
                margin: 0;
            };
        </style>
	<?php 
	echo '<script src="' . NGEURL_MEDIA . 'jquery/jquery.min.js"></script>';
	echo '<script src="' . NGEURL_MEDIA . 'jquery-ui/jquery-ui.min.js' . $ngeVersion .'"></script>';
	//Nb : no url suffix for cache flush. Doesn't work with elfinder
	echo '<script src="' . NGEURL_MEDIA . 'elfinder/js/elfinder.min.js"></script>';
	//Load language file except english that is already included in the main script
	if ($tagLang != 'en')
	    echo '<script src="' . NGEURL_MEDIA . 'elfinder/js/i18n/elfinder.' .$tagLang . '.js"></script>';
	?>
    </head>
    <body>
        <!-- Element where elFinder will be created (REQUIRED) -->
	<div id="ngeelfinder"></div>
        <script>
            jQuery(function() {
                var currentType = "image";
                jQuery('#ngeelfinder').elfinder({
                    url : "<?php echo JUri::base(); ?>index.php?option=com_nge&view=field_ngefilemanager&format=raw&layout=connector&current_type="+currentType + "&<?php echo NGE::token(); ?>=1",
                    lang: "<?php echo $tagLang; ?>",
                    height: jQuery('body').height(),
                    resizable: false,
                    onlyMimes: ["image"], /*display all images*/
                    cssAutoLoad  : [
                        '<?php echo NGEURL_MEDIA; ?>/elfinder/themes/nge/theme1/theme-nge.css' //Specific NGE theme based on Material with adjustement and fixed bug : https://github.com/RobiNN1/elFinder-Material-Theme
                    ],
	    uiOptions : {
		toolbar : [
		    ['search'],
		    ['view', 'sort', 'fullscreen'],
		    ['upload', 'mkdir'],
		    ['resize', 'rename', 'download', 'duplicate', 'rm', 'info', 'quicklook']
		]
	    },		    
                    getFileCallback: function(file) {
                        window.opener.CKEDITOR.tools.callFunction((function() {
                            var reParam = new RegExp('(?:[\?&]|&amp;)CKEditorFuncNum=([^&]+)', 'i') ;
                            var match = window.location.search.match(reParam) ;

                            return (match && match.length > 1) ? match[1] : '' ;
                        })(), file.path);
               		window.close();
                    }
                }).elfinder("instance");
            });
        </script>
    </body>
</html>