<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

// No direct access
defined('_JEXEC') or die;

/**
 * @param	array	A named array
 * @return	array
 * build the route for part
 */
function NgeBuildRoute(&$query)
{
    $db	= JFactory::getDBO();
	$segments = array();
    
    /**
	* 
	* route for view part
	* 
	*/ 
    // if view = part, search in nge_parts the part_id and set segment as part alias
	if (isset($query['view']) && $query['view']=='part' && isset($query['part_id'])) {
	   
        // search for part in bdd
        $db->setQuery( 'SELECT * FROM #__nge_parts WHERE id='.$query['part_id']) ;
        $part = $db->loadObject(  );

		// add part alias as segment ==> print /part_alias in url     
		// segment = viewname.'-'.$part->alias   
        $segments[] = $query['view'].'-'.$part->alias;
        
		unset($query['view']);
		unset($query['part_id']);
		
		// search if part_router exist (field router in part directory)
		$part_route_path = str_replace('.','/',$part->name);
		$part_route_file = 'components/com_nge/parts/'.$part_route_path.'/route.php';
		
        if(file_exists($part_route_file)) {
            include_once JPath::check($part_route_file);
            
            // file exist, run the buidroute function
            // buid route return some segments
            $part_segments = partBuildRoute($query);
            
            // push part segment to component segments
            $segments = array_merge($segments,$part_segments);       
        }
	
	}


	return $segments;
}

/**
 * @param	array	A named array
 * @param	array
 *
 * Formats:
 *
 * index.php?/nge/task/id/Itemid
 *
 * index.php?/nge/id/Itemid
 */
function NgeParseRoute($segments)
{
    
    $db	= JFactory::getDBO();

	$vars = array();
	// view is always the first element of the array
	$count = count($segments);

    // there is segments
    if ($count) {
        // explode first segment for view
        $segment_one = explode(':',$segments[0]);
        
        if($segment_one[0]=='part') {
            // view is = part
            $vars['view']='part';
            
            // then second is alias of the part
            $db->setQuery( 'SELECT * FROM #__nge_parts WHERE alias="'.$segment_one[1].'"') ;
            $part = $db->loadObject(  );
            
            $vars['id'] = $part->id;
            
            // last, search the product id to show in second segment,
            
            // call part router to get corresponding var
    		// search if part_router exist (field router in part directory)
    		$part_route_path = str_replace('.','/',$part->name);
    		$part_route_file = 'components/com_nge/parts/'.$part_route_path.'/route.php';
    		
            if(file_exists($part_route_file)) {
                include_once JPath::check($part_route_file);
                
                // file exist, run the buidroute function
                // buid route return some segments
                $part_vars = partParseRoute($segments);
                
                // push part segment to component segments
                $vars = array_merge($vars,$part_vars);       
            }
        }
        
        if($segments[0]=='download') {
            $vars['task']  = 'download.load' ;
            
            switch($segments[1]) {
                case 'nextgeneditor_full' :
                    $vars['file'] = 'pkg_nge_1.0.0.zip';
                    break;
                case 'jceaddon_nge' :
                    $vars['file'] = 'jceaddon_nge_1.0.0.zip';
                    break;
                case 'jckplugin_nge' :
                    $vars['file'] = 'jckplugin_nge_1.0.0.zip';
                    break;
                case 'arkplugin_nge' :
                    $vars['file'] = 'arkplugin_nge_1.0.0.zip';
                    break;
                
            }  
        }

    }

	return $vars;
}
