<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */


// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modelform');

/**
 * nge model.
 */
class NgeModelmodule extends JModelForm
{
    
	/**
	 * Method to get  form.
	 *
	 * The base form is loaded from XML 
     * 
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
       jForm::addFormPath(JPATH_ADMINISTRATOR.'/components/com_modules/models/forms');
        

        
        // Get the form.
		$form = parent::loadForm('module','module');
		if (empty($form)) {
			return false;
		}

		return $form;
	}
	
	public function getModuleForm(JForm $form) {
		
		jimport('joomla.filesystem.path');

		$app = JFactory::getApplication();
		$client   = JApplicationHelper::getClientInfo($app->getClientId());
        $jinput = JFactory::getApplication()->input;
        
        //  get module id, if exist     
        $module_id=$jinput->get('id',0);
        if($module_id) {
	        $module = $this->getModule($module_id);
	        
	        $module_name = $module->module;
			
		}
		else	
			$module_name = $jinput->get('element','');
			
			
		
        
       	$formFile = JPath::clean($client->path . '/modules/' . $module_name . '/' . $module_name . '.xml');

	// Load the core and/or local language file(s).
	$lang = JFactory::getLanguage();
		$lang->load($module_name, $client->path, null, false, true)
			||	$lang->load($module_name, $client->path . '/modules/' . $module_name, null, false, true);
	
        if (file_exists($formFile))
		{
			// Get the module form.
			if (!$form->loadFile($formFile, false, '//config'))
			{
				throw new Exception(JText::_('JERROR_LOADFILE_FAILED'));
			}

			// Attempt to load the xml file.
			if (!$xml = simplexml_load_file($formFile))
			{
				throw new Exception(JText::_('JERROR_LOADFILE_FAILED'));
			}

			// Get the help data from the XML file if present.
			$help = $xml->xpath('/extension/help');
			if (!empty($help))
			{
				$helpKey = trim((string) $help[0]['key']);
				$helpURL = trim((string) $help[0]['url']);

				$this->helpKey = $helpKey ? $helpKey : $this->helpKey;
		//		$this->helpURL = $helpURL ? $helpURL : $this->helpURL;
			}

		}

				// Load the default advanced params
		JForm::addFormPath(JPATH_ADMINISTRATOR . '/components/com_modules/models/forms');
		$form->loadFile('advanced', false);

		// Trigger the default form events.
		//parent::preprocessForm($form, $data, $group);

		return $form;
		
	}
	
	public function getModule($id=0) {
		
	   $db	= JFactory::getDBO();
       $db->setQuery('SELECT * FROM #__modules
                    where id=' . (int) $id); 	
		
       return $db->loadObject();
	}


	public function getItem($pk = null)
	{
		$pk = (!empty($pk)) ? (int) $pk : (int) $this->getState('module.id','');
		$db = $this->getDbo();

		if (!isset($this->_cache[$pk]))
		{
			$false = false;

			// Get a row instance.
			$table = $this->getTable('module','JTable');
			//$table = $this->getTable();

			// Attempt to load the row.
			$return = $table->load($pk);

			// Check for a table object error.
			if ($return === false && $error = $table->getError())
			{
				$this->setError($error);

				return $false;
			}

			// Check if we are creating a new extension.
			if (empty($pk))
			{
				if ($element = (string) $this->getState('extension.element'))
				{
					
					$query	= $db->getQuery(true)
						->select('*')
						->from('#__extensions')
						->where('element = ' . $db->quote($element))
						->where('type = ' . $db->quote('module'));
					$db->setQuery($query);

					try
					{
						$extension = $db->loadObject();
					}
					catch (RuntimeException $e)
					{
						$this->setError($e->getMessage);

						return false;
					}

					if (empty($extension))
					{
						$this->setError('COM_MODULES_ERROR_CANNOT_FIND_MODULE');

						return false;
					}

					// Extension found, prime some module values.
					$table->module    = $extension->element;
					$table->client_id = $extension->client_id;
				}
				else
				{
					$app = JFactory::getApplication();
					$app->redirect(JRoute::_('index.php?option=com_nge', false));

					return false;
				}
			}

			// Convert to the JObject before adding other data.
			$properties        = $table->getProperties(1);
			$this->_cache[$pk] = JArrayHelper::toObject($properties, 'JObject');

			// Convert the params field to an array.
			$registry = new JRegistry;
			$registry->loadString($table->params);
			$this->_cache[$pk]->params = $registry->toArray();

			// Determine the page assignment mode.
			$query	= $db->getQuery(true)
				->select($db->quoteName('menuid'))
				->from($db->quoteName('#__modules_menu'))
				->where($db->quoteName('moduleid') . ' = ' . (int) $pk);
			$db->setQuery($query);
			$assigned = $db->loadColumn();

			if (empty($pk))
			{
				// If this is a new module, assign to all pages.
				$assignment = 0;
			}
			elseif (empty($assigned))
			{
				// For an existing module it is assigned to none.
				$assignment = '-';
			}
			else
			{
				if ($assigned[0] > 0)
				{
					$assignment = 1;
				}
				elseif ($assigned[0] < 0)
				{
					$assignment = -1;
				}
				else
				{
					$assignment = 0;
				}
			}

			$this->_cache[$pk]->assigned   = $assigned;
			$this->_cache[$pk]->assignment = $assignment;

			// Get the module XML.
			$client = JApplicationHelper::getClientInfo($table->client_id);
			$path   = JPath::clean($client->path . '/modules/' . $table->module . '/' . $table->module . '.xml');

			if (file_exists($path))
			{
				$this->_cache[$pk]->xml = simplexml_load_file($path);
			}
			else
			{
				$this->_cache[$pk]->xml = null;
			}
		}

		return $this->_cache[$pk];
	}

	/**
	 * Method to get a single record.
	 *
	 * @param   integer  $a_id  The id of the primary key of the article.
	 *
	 * @return  string  new Position string
	 *
	 */
	public function getNewPositionInArticle($a_id)
	{
	    $db	= JFactory::getDBO();
	    $query	= $db->getQuery(true)
	    ->select($db->quoteName('alias'))
	    ->from($db->quoteName('#__content'))
	    ->where($db->quoteName('id') . ' = ' . (int) $a_id);
	    $db->setQuery($query);
	    $result = $db->loadObject();
	    if ($result)
		return $result->alias.'-'.rand(1000, 9999);
	    else
		return rand(100000, 999999);
	}
	
	/**
	 * Method to get a single record.
	 *
	 * @param   integer  $a_id  The id of the primary key of the article.
	 *
	 * @return  string  new Position string
	 *
	 */
	public function getNewPositionInK2item($a_id)
	{
	    $db	= JFactory::getDBO();
	    $query	= $db->getQuery(true)
	    ->select($db->quoteName('alias'))
	    ->from($db->quoteName('#__k2_items'))
	    ->where($db->quoteName('id') . ' = ' . (int) $a_id);
	    $db->setQuery($query);
	    $result = $db->loadObject();
	    if ($result)
		return $result->alias.'-'.rand(1000, 9999);
	    else
		return rand(100000, 999999);
	}
	
	
	/**
	 * Method to get a single record.
	 *
	 * @param   integer  $pk  The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 *
	 * @since   1.6
	 */
	public function getItem2($element)
	{
        // @todo not use, delete after complete tests
	    $pk = null;
		$pk = (!empty($pk)) ? (int) $pk : (int) $this->getState('module.id');
		$db = $this->getDbo();

		if (!isset($this->_cache[$pk]))
		{
			$false = false;
			//JTable::addIncludePath()
			// Get a row instance.
			$table = $this->getTable('module','JTable');

			// Attempt to load the row.
			$return = $table->load($pk);

			// Check for a table object error.
			if ($return === false && $error = $table->getError())
			{
				$this->setError($error);

				return $false;
			}

			
			// Check if we are creating a new extension.
			/*if (empty($pk))
			{
			
				if ($extensionId = (int) $this->getState('extension.id'))
				{
					$query	= $db->getQuery(true)
						->select('element, client_id')
						->from('#__extensions')
						->where('extension_id = ' . $extensionId)
						->where('type = ' . $db->quote('module'));
					$db->setQuery($query);

					try
					{
						$extension = $db->loadObject();
					}
					catch (RuntimeException $e)
					{
						$this->setError($e->getMessage);

						return false;
					}

					if (empty($extension))
					{
						$this->setError('COM_MODULES_ERROR_CANNOT_FIND_MODULE');

						return false;
					}

					// Extension found, prime some module values.
					$table->module    = $extension->element;
					$table->client_id = $extension->client_id;
				}
				else
				{
					$app = JFactory::getApplication();
					$app->redirect(JRoute::_('index.php?option=com_modules&view=modules', false));

					return false;
				}*/
			//}
		
			if(empty($element))
				$element=$table->module;
		
			$query	= $db->getQuery(true)
				->select('*')
				->from('#__extensions')
				->where('element = ' . $db->quote($element))
				->where('type = ' . $db->quote('module'));
			$db->setQuery($query);

			$module = $db->loadObject();
			$module->id = $module->extension_id;
			// Convert to the JObject before adding other data.
			$properties        = $table->getProperties(1);
			$this->_cache[$pk] = JArrayHelper::toObject($properties, 'JObject');
			$this->_cache[$pk] = $module;
			$this->_cache[$pk]->module = $element;
			
			
			// Convert the params field to an array.
			$registry = new JRegistry;
			$registry->loadString($module->params);
			$this->_cache[$pk]->params = $registry->toArray();

			// Determine the page assignment mode.
			$query	= $db->getQuery(true)
				->select($db->quoteName('menuid'))
				->from($db->quoteName('#__modules_menu'))
				->where($db->quoteName('moduleid') . ' = ' . (int) $pk);
			$db->setQuery($query);
			$assigned = $db->loadColumn();

			if (empty($pk))
			{
				// If this is a new module, assign to all pages.
				$assignment = 0;
			}
			elseif (empty($assigned))
			{
				// For an existing module it is assigned to none.
				$assignment = '-';
			}
			else
			{
				if ($assigned[0] > 0)
				{
					$assignment = 1;
				}
				elseif ($assigned[0] < 0)
				{
					$assignment = -1;
				}
				else
				{
					$assignment = 0;
				}
			}

			$this->_cache[$pk]->assigned   = $assigned;
			$this->_cache[$pk]->assignment = $assignment;

			// Get the module XML.
			//$client = JApplicationHelper::getClientInfo($table->client_id);
			$path   = JPath::clean(JPATH_ROOT . '/modules/' . $element . '/' . $element . '.xml');
			//$path   = JPath::clean($client->path . '/modules/' . $table->module . '/' . $table->module . '.xml');

			if (file_exists($path))
			{
				$this->_cache[$pk]->xml = simplexml_load_file($path);
			}
			else
			{
				$this->_cache[$pk]->xml = null;
			}
			 
			 
		}

		return $this->_cache[$pk];
	}

	
	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($data)
	{
		$input      = JFactory::getApplication()->input;
		//$table      = $this->getTable();
		$table = JTable::getInstance('Module', 'JTable', array());

		//$table = new ModuleTable
		$pk         = (!empty($data['id'])) ? (int) $data['id'] : (int) $this->getState('module.id');
		$isNew      = true;

		// Include the content modules for the onSave events.
		JPluginHelper::importPlugin('extension');

		// Load the row if saving an existing record.
		if ($pk > 0)
		{
			$table->load($pk);
			$isNew = false;
		}

		// Alter the title and published state for Save as Copy
		if ($input->get('task') == 'save2copy')
		{
			$orig_data  = $input->post->get('jform', array(), 'array');
			$orig_table = clone($this->getTable());
			$orig_table->load((int) $orig_data['id']);

			if ($data['title'] == $orig_table->title)
			{
				$data['title'] .= ' ' . JText::_('JGLOBAL_COPY');
				$data['published'] = 0;
			}
		}

		// Bind the data.
		if (!$table->bind($data))
		{
			$this->setError($table->getError());

			return false;
		}

		// Prepare the row for saving
		$this->prepareTable($table);

		// Check the data.
		if (!$table->check())
		{
			$this->setError($table->getError());

			return false;
		}

		// Trigger the onExtensionBeforeSave event.
		$result = NGE::triggerEvent('onExtensionBeforeSave', array('com_modules.module', &$table, $isNew));

		if (in_array(false, $result, true))
		{
			$this->setError($table->getError());

			return false;
		}

		// Store the data.
		if (!$table->store())
		{
			$this->setError($table->getError());

			return false;
		}
    
		// Process the menu link mappings.
		$assignment = isset($data['assignment']) ? $data['assignment'] : 0;

		// Delete old module to menu item associations
		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->delete('#__modules_menu')
			->where('moduleid = ' . (int) $table->id);
		$db->setQuery($query);

		try
		{
			$db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		// If the assignment is numeric, then something is selected (otherwise it's none).
		if (is_numeric($assignment))
		{
			// Variable is numeric, but could be a string.
			$assignment = (int) $assignment;

			// Logic check: if no module excluded then convert to display on all.
			if ($assignment == -1 && empty($data['assigned']))
			{
				$assignment = 0;
			}

			// Check needed to stop a module being assigned to `All`
			// and other menu items resulting in a module being displayed twice.
			if ($assignment === 0)
			{
				// Assign new module to `all` menu item associations.
				$query->clear()
					->insert('#__modules_menu')
					->columns(array($db->quoteName('moduleid'), $db->quoteName('menuid')))
					->values((int) $table->id . ', 0');
				$db->setQuery($query);

				try
				{
					$db->execute();
				}
				catch (RuntimeException $e)
				{
					$this->setError($e->getMessage());

					return false;
				}
			}
			elseif (!empty($data['assigned']))
			{
				// Get the sign of the number.
				$sign = $assignment < 0 ? -1 : 1;

				// Preprocess the assigned array.
				$tuples = array();

				foreach ($data['assigned'] as &$pk)
				{
					$tuples[] = '(' . (int) $table->id . ',' . (int) $pk * $sign . ')';
				}

				$this->_db->setQuery(
					'INSERT INTO #__modules_menu (moduleid, menuid) VALUES ' .
					implode(',', $tuples)
				);

				try
				{
					$db->execute();
				}
				catch (RuntimeException $e)
				{
					$this->setError($e->getMessage());

					return false;
				}
			}
		}

        // reordering modules after
        $reorder_conditions = $this->getReorderConditions($table);
        $table->reorder($reorder_conditions);

		// Trigger the onExtensionAfterSave event.
		NGE::triggerEvent('onExtensionAfterSave', array('com_modules.module', &$table, $isNew));

		// Compute the extension id of this module in case the controller wants it.
		$query	= $db->getQuery(true)
			->select('extension_id')
			->from('#__extensions AS e')
			->join('LEFT', '#__modules AS m ON e.element = m.module')
			->where('m.id = ' . (int) $table->id);
		$db->setQuery($query);

		try
		{
			$extensionId = $db->loadResult();
		}
		catch (RuntimeException $e)
		{
			NGE::message($db->getMessage() , 'warning');
			return false;
		}

		$this->setState('module.extension_id', $extensionId);
		$this->setState('module.id', $table->id);

		// Clear modules cache
		$this->cleanCache();

		// Clean module cache
		parent::cleanCache($table->module, $table->client_id);

		return true;
	}

		protected function prepareTable($table)
	{
		$table->title		= htmlspecialchars_decode($table->title, ENT_QUOTES);
		$table->position	= trim($table->position);
	}
    
    /**
     * NgeModelconfigmodule::reorder()
     * reorder module after module_id
     * @param mixed $module_id
     * @return void
     */
    public function reorderModulesAfter($module_id) {
        $db	= JFactory::getDBO();
        // module
        $module = $this->getItem($module_id);
        $ordering = $module->ordering;
        
        // module list after 
        $sql = 'SELECT * FROM #__modules WHERE ordering>=' . (int) $module->ordering . ' AND position=' . $db->quote($module->position) . ' AND id<>' . (int) $module_id.' 
                ORDER BY ordering,id';
        $db->setQuery( $sql) ;
        
        $list_to_reorder = $db->loadObjectList();
        
        if(count($list_to_reorder)) {
            foreach($list_to_reorder as $module_to_reorder) {
                $ordering++;
                $sql = 'UPDATE #__modules SET ordering=' . (int) $ordering . ' WHERE id=' . (int) $module_to_reorder->id;
                $db->setQuery($sql);
                
                $db->execute();
            }
        }
    }
	/**
	 * NgeModelconfigmodule::getReorderConditions()
	 * 
	 * @param mixed $table
	 * @return
	 */
	protected function getReorderConditions($table)
	{
		$condition = array();
		$condition[] = 'client_id = ' . (int) $table->client_id;
		$condition[] = 'position = ' . $this->_db->quote($table->position);

		return $condition;
	}

}