<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */


defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

/**
 * Media Component List Model
 *
 * @package     Joomla.Administrator
 * @subpackage  com_media
 * @since       1.5
 */
class NgeModelLibraryGallery extends JModelLegacy
{
	public function getState($property = null, $default = null)
	{
		static $set;

		if (!$set)
		{
			$input  = JFactory::getApplication()->input;
			//$category = $input->get('category', '', 'path');
			$category = $input->get('category', '');
			$this->setState('category', $category);
			$set = true;
		}

		return parent::getState($property, $default);
	}


	/**
	 * Build categoriesList
	 *
	 *
	 */
	public function getCategories()
	{
		$db = JFactory::getDbo();		
		$query = $db->getQuery(true);
		$user = JFactory::getUser();
		
		$query->select('a.id, a.title, a.name, a.published, a.plugin, a.parent_id, a.level, a.lft, a.rgt')
			->from($db->quoteName('#__nge_categories') . ' AS a');
		$query->where('a.published=1');
		//User access
		$groups = ArrayHelper::toInteger($user->getAuthorisedViewLevels());
		$query->where('a.access IN (' . implode(',', $groups) . ')');
		
		$query->order('a.lft');
		$db->setQuery($query);
		$list = $db->loadObjectList();

		return $list;
	}
	/**
	 * Build partsList
	 *
	 * @param integer $CategoryId 
	 *
	 */
	public function getParts()
	{
		static $list;

		// Only process the list once per request
		if (is_array($list))
		{
			return $list;
		}

		// Get current path from request
		$category = $this->getState('category');

		// If undefined, set to empty
		if ($category == 'undefined')
		{
			$category = '';
		}

		if ($category == '')
		{
			return Array();
		}	
		
		$db = JFactory::getDbo();		
		$query = $db->getQuery(true);
		$user = JFactory::getUser();
		
		$query->select('a.part as name, a.title, a.description, a.demo_link, c.plugin')
			->from($db->quoteName('#__nge_parts_library') . ' AS a')
			->join('LEFT', $db->quoteName('#__nge_categories', 'c') .  ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('c.id') . ')').
		$query->where('a.catid=' . (int) $category)
				->where('a.state=1');
		//User access
		$groups = ArrayHelper::toInteger($user->getAuthorisedViewLevels());
		$query->where('a.access IN (' . implode(',', $groups) . ')');
		
		$query->order('a.ordering');
		$db->setQuery($query);
		$list = $db->loadObjectList();

		return $list;
	}

	
	/**
	 * Loading language files for all installed Packs
	 *
	 * @param integer $CategoryId
	 *
	 */
	function loadPacksLanguage(){
		
    	// load pack language file
    	$lang = JFactory::getLanguage();
        $lang->load('com_nge_pack', JPATH_SITE);

	 	// get installed plugins
		$db	= JFactory::getDBO();
	 	$sql = "SELECT * FROM #__nge_plugins WHERE type='pack'";
	 	$db->setQuery( $sql) ;
	 	$packs = $db->loadObjectList(  );
	 	
	 	if(count($packs)) {
	    	$lang = JFactory::getLanguage();
	     	foreach($packs as $pack) {
	        	$filename = 'com_nge_'.$pack->name;
	         	$lang->load($filename, JPATH_SITE);
	     	}
	 	}	
	}
	
}