<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once NGEPATH_HELPERS . '/ngepartshelper.php';
require_once NGEPATH_HELPERS . '/parts/renderer/default.php';

/**
 * Categories helper.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_categories
 * @since       1.6
 */
class NgePartRendererThumbnails{
    
    public static function render($part_id){                       
        $html = "";

        $part = NgePartsHelper::getPart("[".$part_id."]"); // Parts in cache. Warning, partsInformation is not in same order

        if(isset($part->html) && $part->html != "" && $part->html != "null"){
            $result[] = '<div id="part-'.$part->id.'" class="part nge-workshop-thumbnails-items" data-part="'.$part->name.'" data-part-label="'.$part->title.'">';
            $result[] = $part->html;
            $result[] = '</div>';
        }else{
	//Rendering mode is fastview. We always display the part. No conditional display test before
            $result[] = NgePartRendererDefault::render($part);
        }

        $html = implode($result);

        return $html;
    }	
}
