<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once NGEPATH_HELPERS . '/ngepartshelper.php';
require_once NGEPATH_HELPERS . '/parts/renderer/default.php';

/**
 * Workshop renderer in fastview display
 *  The display depends on the widget. All widget store thumbnail representation inside the database. 
 *  - Charts : No animation
 *  - Tables : Truncated content for table (10 lines)
 *  - ...
 */
class NgePartRendererFastview
{	
    /**
     * Render return one or more widget html and returns the results as a string
     * @param $value Can be widget Id or string of div data-parts for multiple widget.
     * @param $multiple Used to know if we use string of data-parts or widget Id. Defaut true.
     * @return string Widget(s) HTML
     */
    public static function render($parts){
	
            foreach ($parts as $part){
	if ($part->preview == '')
	    $part->preview = self::getRenderer($part);
            }
        return $parts;
    }
    
    public static function getRenderer($part){
        $html = array();
        // Get part path
        $part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
        // If template exists (fastview.php), using template for rendering specific attributes for this part
        $templatePath = JPATH_SITE . '/components/com_nge/parts/' . implode('/', explode('.', $part->name)) . '/fastview.php';
        if(file_exists($templatePath)){
            ob_start();
                include JPath::check($templatePath);
                $html[] = ob_get_contents();
            ob_end_clean();
        }else {//Generic div
            //If cache html exists in file, displaying. If not building part content
            if(isset($part->thumbnail) && ($part->thumbnail != "") && ($part->thumbnail != "null")){
                $class = array();
                $class[] = JLayoutHelper::render('nge.parts.display_class', $part);
                $class[] = "part";
                $attributes = array();
                $attributes[] = ' id="part-'.$part->id.'"';
                $attributes[] = ' data-part="'.$part->name.'"';
                $attributes[] = ($part->title != '') ? ' data-part-label="'.$part->title.'"' : ' data-part-label="'.$part->library_title.'"';
                $attributes[] = JLayoutHelper::render('nge.parts.display_attribute', $part);
                $attributes[] = ' class="'.implode(' ', $class).'"';

                $html[] = '<div ' . implode(" ", $attributes) . '>';
                $html[] = $part->thumbnail;
                $html[] = '</div>';
            }else {
                /*Displays parts in fastview mode.
                Three available mechanisms : 
                     1 : if fastview.php files exists : loading it instead of part.php (template = fastview)
                     2 : rendering mode = fastview. In the current part.php, can be used (rendering_mode = fastview) to simplify the rendered content. For example only 10 first lines in a table
                     3 : in part.php if rendering_mode=fastview is not used, normal rendering is made and stored in cache
                 While rendering, the content is stored as cache in the thumbnail field (part table)
                */
                $attribs = new stdClass;
                $attribs->template = 'fastview'; //Use fastview.php if exists
                $attribs->rendering_mode = 'fastview'; //While building part content, adjust options
	//Rendering mode is fastview. We always display the part. No conditional display test		
                $html[] = NgePartRendererDefault::render($part, $attribs);
            }
        }
        
        return implode($html);
    }
}