<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS . '/html/bootstrap/bootstraptag.php');
//require_once NGEPATH_CLASSES . '/ngepartobject.php';


/*
 * 
 * template : file to use for building part. Can override default template (part => part.php file in the part directory), example fastview.php
 * rendering_mode : preview/edit/fastview... each part will adjust options while building content (edition capabilities...)
 * 
 */

class NgePartRendererDefault
{
		
    public static function render($part, $attribs = null, $content = null)
	{
		//extra css for parts
		$document = Jfactory::getDocument(); 
		$document->addStyleSheet(JUri::root(). 'components/com_nge/assets/css/all.css', 'all');		
		$document->addStyleSheet(JUri::root() . 'components/com_nge/assets/css/screen.css', 'screen');
		$document->addStyleSheet(JUri::root() . 'components/com_nge/assets/css/print.css', 'print');
		$document->addScript(JUri::root(). 'components/com_nge/assets/js/bootstrap_check.php');

		//If part is already an object with properties filled, no need to load informations.
		//If not load this part informations
		if (!is_object($part))
		{
			$title = isset($attribs->title) ? $attribs->title : null;
			require_once NGEPATH_HELPERS . '/ngepartshelper.php';
			$part = NgePartsHelper::getPart($part, $title);
			
			if (!is_object($part))
			{
				if (is_null($content))
				{
					return '';
				}
				else
				{
					/**
					 * If module isn't found in the database but data has been pushed in the buffer
					 * we want to render it
					 */
					$tmp = $part;
					$part = new stdClass;
					$part->title = '';
					$part->params = null;
					$part->name = $tmp;
					$part->id = 0;
					$part->user = 0;
				}
			}
		}
                if(!isset($part->rendering) && !isset($part->rendering->mode)){
                    $part->rendering = new stdClass();
                    $part->rendering->mode = 'view'; 
                }		
		if (isset($attribs->rendering_mode)){
			$part->rendering->mode = $attribs->rendering_mode; 
		}
		//Cache
		/*
		if ($part->id != '0'){
			$cache = JFactory::getCache('com_nge', '');
			$cache->setCaching(true);
			$cache->setLifeTime(14400); 
			//$lang = JFactory::getLanguage();
			//$lang->getTag(); 
			$rendering = isset($part->rendering->mode) ? $part->rendering->mode : '';
			$cacheId = 'part-'.$part->id.'-'.$rendering; 
			
			$cacheContent = $cache->get($cacheId);			
			if ($cacheContent != '')
				return $cacheContent;		
		}
		*/
		
		//If no cache : continue...
		
		// Get the user and configuration object
		// $user = JFactory::getUser();
		//$conf = JFactory::getConfig();

		// Set the part content
		if (!is_null($content))
		{
			$part->content = $content;
		}
		
		// Get parts parameters
		//Merge params in the params field and in the content field
		
		$params = new JRegistry;
		if ($part->content != ''){
		    $contentArray = (!is_array($part->content)) ? json_decode($part->content, true) : $part->content;
		    $paramsArray = (!is_array($part->params)) ? json_decode($part->params, true) : $part->params;
		    $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
		    $params->loadString(json_encode($mergedParams));
		}
		else
		    $params->loadString($part->params);
				
		$part->params = $params;
		// Use parameters from template
		if (isset($attribs->params))
		{ 
			$template_params = new JRegistry;
			$template_params->loadString(html_entity_decode($attribs['params'], ENT_COMPAT, 'UTF-8'));
			$params->merge($template_params);
			$part = clone $part;
			$part->params = (string) $params;
		}

		$canDisplay = true; //Can display or not in the page in view mode. Can always display, except if a condition has been set with a filter
		
		//Display conditions
		//In view mode, we apply display conditions
		//In edit mode in frontend we display only if the conditions are users groups, date... But not categories, components...
		//There would be too much widgets displayed, in particular in the modules in positions.
		//So in edit mode we display only the widgets that are in their page.
		//In preview mode or edit mode, no display restrictions
		
		    /*$display = $part->params->get('display');
		    if (isset($display->rules) && ($display->rules != 'always')){

			//User level
			//Visible in edit mode in front
			if (($part->rendering->mode == "view") && ($display->filters->userlevel->rule != 'all') && isset($display->filters->user->values) && count($display->filters->userlevel->values) != 0){
			    $currentUserLevels = JFactory::getUser()->getAuthorisedViewLevels();
			    if (count($currentUserLevels) > 0){
				$inValues = array_intersect($currentUserLevels, $display->filters->userlevel->values);
				if ((!$inValues && $display->filters->userlevel->rule == 'only') || ($inValues && $display->filters->userlevel->rule == 'except'))
				    $canDisplay = false;
			    }
			    else
				if ($display->filters->userlevel->rule == 'only') $canDisplay = false;
			}

			//User group
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->usergroup->rule != 'all') && isset($display->filters->usergroup->values) && count($display->filters->usergroup->values) != 0){
			    $currentUserGroups = JFactory::getUser()->getAuthorisedGroups();
			    if (count($currentUserGroups) > 0){
				$inValues = array_intersect($currentUserGroups, $display->filters->usergroup->values);
				if ((!$inValues && $display->filters->usergroup->rule == 'only') || ($inValues && $display->filters->usergroup->rule == 'except'))
				    $canDisplay = false;
			    }
			    else
				if ($display->filters->usergroup->rule == 'only') $canDisplay = false;
			}
			
			//User
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->user->rule != 'all') && isset($display->filters->user->values) && count($display->filters->user->values) != 0){
			    $currentUserId = JFactory::getUser()->id;
			    if ($currentUserId != 0){
				$inValues = in_array($currentUserId, $display->filters->user->values);
				if ((!$inValues && $display->filters->user->rule == 'only') || ($inValues && $display->filters->user->rule == 'except'))
				    $canDisplay = false;
			    }
			    else
				if ($display->filters->user->rule == 'only') $canDisplay = false;
			}
			

			//Menuitem Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->menuitem->rule != 'all') && isset($display->filters->menuitem->values) && count($display->filters->menuitem->values) != 0){
			    $currentMenu = JFactory::getApplication()->getMenu();
			    if (isset($currentMenu)){ 
				$activeMenu = $currentMenu->getActive();
				if (isset($activeMenu)){ 
				    $currentMenuId = $currentMenu->getActive()->id;
				    $inValues = in_array($currentMenuId, $display->filters->menuitem->values);
				    if ((!$inValues && $display->filters->menuitem->rule == 'only') || ($inValues && $display->filters->menuitem->rule == 'except'))
					$canDisplay = false;
				}
				else
				    if ($display->filters->menuitem->rule == 'only') $canDisplay = false;
			    }
			    else { //No current menu
				if ($display->filters->menuitem->rule == 'only') $canDisplay = false;
			    }
			}
			
			//Category.  Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->category->rule != 'all') && isset($display->filters->category->values) && count($display->filters->category->values) != 0){
			    $input=Jfactory::getApplication()->input;
			    if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){
				$db=JFactory::getDbo(); 
				$db->setQuery('select catid from #__content where id='.$input->getInt('id')); 
				$catid=$db->loadResult(); 
				if ($catid != 0){ 
				    $inValues = in_array($catid, $display->filters->category->values);
				    if ((!$inValues && $display->filters->category->rule == 'only') || ($inValues && $display->filters->category->rule == 'except'))
					$canDisplay = false;
				}
				else { //No current menu
				    if ($display->filters->category->rule == 'only') $canDisplay = false;
				}
			    }
			    else //No category
				if ($display->filters->category->rule == 'only') $canDisplay = false;			
			}

			//Tag.  Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->tag->rule != 'all') && isset($display->filters->tag->values) && count($display->filters->tag->values) != 0){
			    $input=Jfactory::getApplication()->input;
			    if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){
				$db=JFactory::getDbo(); 
				$db->setQuery('select tag_id from #__contentitem_tag_map where type_alias="com_content.article" AND content_item_id='.$input->getInt('id')); 
				$tagsid=$db->loadColumn(0); 
				if (count($tagsid) != 0){ 
				    $inValues = array_intersect($tagsid, $display->filters->tag->values);
				    if ((!$inValues && $display->filters->tag->rule == 'only') || ($inValues && $display->filters->tag->rule == 'except'))
					$canDisplay = false;
				}
				else { //No current menu
				    if ($display->filters->tag->rule == 'only') $canDisplay = false;
				}
			    }
			    else //No category
				if ($display->filters->tag->rule == 'only') $canDisplay = false;			
			}
			
			//Article.  Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->article->rule != 'all') && isset($display->filters->article->values) && count($display->filters->article->values) != 0){
			    $input=Jfactory::getApplication()->input;
			    if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){				
				$articleId = $input->getInt('id');
				    $inValues = in_array($articleId, $display->filters->article->values);
				    if ((!$inValues && $display->filters->article->rule == 'only') || ($inValues && $display->filters->article->rule == 'except'))
					$canDisplay = false;
			    }
			    else //No category
				if ($display->filters->article->rule == 'only') $canDisplay = false;			
			}
			
			//Component.  Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->component->rule != 'all') && isset($display->filters->component->values) && count($display->filters->component->values) != 0){
			    $input=Jfactory::getApplication()->input;			    
			    $component = $input->getCmd('option');
			    $inValues = in_array($component, $display->filters->component->values);
			    if ((!$inValues && $display->filters->component->rule == 'only') || ($inValues && $display->filters->component->rule == 'except'))
				$canDisplay = false;
			}
			
			//Language.  Hidden also in edit mode
			if ((in_array($part->rendering->mode, array("view", "edit"))) && ($canDisplay == true) && ($display->filters->language->rule != 'all') && isset($display->filters->language->values) && count($display->filters->language->values) != 0){
			    $lang = JFactory::getLanguage()->getTag();
			    $inValues = in_array($lang, $display->filters->language->values);
			    if ((!$inValues && $display->filters->language->rule == 'only') || ($inValues && $display->filters->language->rule == 'except'))
				$canDisplay = false;
			}

			//Date : format yyyy-mm-dd hh:mm:ss => 'Y-m-d H:i:s'
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->date->rule != 'all')){
			    if (isset($display->filters->date->from) && (trim($display->filters->date->from) != "")){
				$fromDate = $display->filters->date->from;
				$nowDate = (string) date('Y-m-d H:i:s');
				//String comparison. Is sufficient and prevents date format exceptions				
				if ((($nowDate < $fromDate) && $display->filters->date->rule == 'only') || ($nowDate >= $fromDate && $display->filters->date->rule == 'except'))
				    $canDisplay = false;
			    }
			    if (isset($display->filters->date->to) && ($display->filters->date->to != "")){
				$toDate = $display->filters->date->to;
				$nowDate = (string) date('Y-m-d H:i:s');
				//String comparison. Is sufficient and prevents date format exceptions				
				if (($nowDate >= $toDate && $display->filters->date->rule == 'only') || ($nowDate < $toDate && $display->filters->date->rule == 'except'))
				    $canDisplay = false;
			    }
			}

			//Time : format hh:mm:ss => 'H:i:s'
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->time->rule != 'all')){
			    if (isset($display->filters->time->from) && (trim($display->filters->time->from) != "")){
				$fromTime = $display->filters->time->from;
				$nowTime = (string) date('H:i:s');
				//String comparison. Is sufficient and prevents time format exceptions				
				if ((($nowTime < $fromTime) && $display->filters->time->rule == 'only') || ($nowTime >= $fromTime && $display->filters->time->rule == 'except'))
				    $canDisplay = false;
			    }
			    if (isset($display->filters->time->to) && ($display->filters->time->to != "")){
				$toTime = $display->filters->time->to;
				$nowTime = (string) date('H:i:s');
				//String comparison. Is sufficient and prevents date format exceptions				
				if (($nowTime >= $toTime && $display->filters->time->rule == 'only') || ($nowTime < $toTime && $display->filters->time->rule == 'except'))
				    $canDisplay = false;
			    }
			}

			//Month
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->month->rule != 'all') && isset($display->filters->month->values) && count($display->filters->month->values) != 0){
			    $currentMonth = (string) date('n'); 
			    $inValues = in_array($currentMonth, $display->filters->month->values);
			    if ((!$inValues && $display->filters->month->rule == 'only') || ($inValues && $display->filters->month->rule == 'except'))
				$canDisplay = false;
			}

			//Day of week			
			if (($part->rendering->mode == "view") && ($canDisplay == true) && ($display->filters->dayofweek->rule != 'all') && isset($display->filters->dayofweek->values) && count($display->filters->dayofweek->values) != 0){
			    $jd = cal_to_jd(CAL_GREGORIAN,date("m"),date("d"),date("Y"));
			    $dayOfWeek = jddayofweek($jd);
			    $inValues = in_array($dayOfWeek, $display->filters->dayofweek->values);
			    if ((!$inValues && $display->filters->dayofweek->rule == 'only') || ($inValues && $display->filters->dayofweek->rule == 'except'))
				$canDisplay = false;
			}
												
		    }*/
		//$canEdit  = true;
		//$canDisplay = false;
		//if ($canDisplay == true)
		    return self::_render($part, $attribs);
		/*else
		    if ($canEdit == true)
		    {
			return '<div class="visiblewhenunlocked">' . self::_render($part, $attribs) .'</div>';
		    }*/
		  //  else
		    //return '';
	}
    
	/**
	 * Render the part.
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public static function _render($part, $attribs = null)
	{
		//PartHelper usable in each part implementation
		//require_once $path = JPATH_ADMINISTRATOR . '/components/com_nge/helpers/parts.php';
		if (defined('JDEBUG'))
			JProfiler::getInstance('Application')->mark('beforeRenderPart ' . $part->name . ' (' . $part->id . ')');
	
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
		
		$directories = '';
		$name = "";
		$part->cacheable = false;
                
		//File to use to build the part
		$templateFilename = isset($attribs->template) ? $attribs->template.".php" : "part.php";
                
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
			$name .= $partpath[count($partpath)-1];
                        
			// If template not exists, using default template : file part.php
			if(!file_exists(JPATH_SITE . '/components/com_nge/parts/' . $directories . $templateFilename)){
			    $templateFilename = "part.php";
			}                        
			$templatePath = JPATH_SITE . '/components/com_nge/parts/'.$directories.$templateFilename;
			
			//If in edit mode, load Part Languages, for part title in the part toolbar
			//if(isset($part->rendering) && isset($part->rendering->mode) && ($part->rendering->mode == 'edit'));
			//    NgePartsHelper::loadLibraryPackLanguage($part->name);
			
			// Load the path
			if (file_exists($templatePath))
			{  //Todo load language before : only one call				
				//Addin warnings translations if in preview or edit mode
				if (($part->rendering->mode =="preview") || ($part->rendering->mode =="edit")){
				    $lang = JFactory::getLanguage();
				    $lang->load('com_nge_messages',JPATH_SITE);
				}				
	
				// 1.5 or Core then 1.6 3PD
				//Searching language in common com_nge languages files
				//Or in part subdirectories
				//$lang->load('com_nge', JPATH_BASE, null, false, true) ||
				//$lang->load($name, dirname($path), null, false, true);

				$content = '';						
				ob_start();
				include JPath::check($templatePath);
				$part->content = ob_get_contents(); // . $content;
				ob_end_clean();
			}

			if (!(isset($attribs->minify) && ($attribs->minify == false))) {				
				$part->content = NGE::minify($part->content);
			}
			
			//Cache
			//If used in a screen in thumbnail mode (workshop or search), saved in the parts table
			if ($part->rendering->mode == "fastview"){
				//Removing main div
				$partContent = $part->content;
				$firstDivEndPos = strpos($partContent, '>');
				$partContent = substr($partContent, $firstDivEndPos+1);
				$lastDivEndPos = strrpos($partContent, '</div');
				$partContent = substr($partContent, 0, $lastDivEndPos);
				require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
				NgeNgePartDriver::storeThumbnail($part->id, $partContent);
			}
			
			$part->cacheable = true;
			if ($part->cacheable == true){
/*				$cache = JFactory::getCache('com_nge', '');
				$cache->setCaching(true);
				$cache->setLifeTime(14400); 
//				$lang = JFactory::getLanguage();
//				$lang->getTag(); 
				//$cacheId = 'part-'.$part->id.'-'.$part->rendering->mode.'-'.$lang->getTag(); 
				$rendering = isset($part->rendering->mode) ? $part->rendering->mode : '';
				$cacheId = 'part-'.$part->id.'-'.$rendering; 
				$cache->store($part->content, $cacheId);*/
				//require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
				//NgeNgePartDriver::storeRender($part->id, $part->content);
			}
			
			if (defined('JDEBUG'))
				JProfiler::getInstance('Application')->mark('afterRenderPart ' . $part->name . ' (' . $part->id . ')');
			
			return $part->content;	
	}


	
}
