<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once NGEPATH_HELPERS . '/ngeparthelper.php';

/**
 * JDocument Module renderer
 *
 * @package     Joomla.Platform
 * @subpackage  Document
 * @since       11.1
 */
class JDocumentRendererCode extends JDocumentRenderer
{
	/**
	 * Renders a module script and returns the results as a string
	 *
	 * @param   string  $module   The name of the module to render
	 * @param   array   $attribs  Associative array of values
	 * @param   string  $content  If present, module information from the buffer will be used
	 *
	 * @return  string  The output of the script
	 *
	 * @since   11.1
	 */
	public function render($part, $attribs = array(), $content = null)
	{
		if (!is_object($part))
		{
			$title = isset($attribs['title']) ? $attribs['title'] : null;

			$part = NgePartsHelper::getPart($part, $title);

			if (!is_object($part))
			{
				if (is_null($content))
				{
					return '';
				}
				else
				{
					/**
					 * If module isn't found in the database but data has been pushed in the buffer
					 * we want to render it
					 */
					$tmp = $part;
					$part = new stdClass;
					$part->title = '';
					$part->params = null;
					$part->name = $tmp;
					$part->id = 0;
					$part->user = 0;
				}
			}
		}

		// Get the user and configuration object
		// $user = JFactory::getUser();
		$conf = JFactory::getConfig();

		// Set the part content
		if (!is_null($content))
		{
			$part->content = $content;
		}

		// Get module parameters
		$params = new JRegistry;
		$params->loadString($part->params);
		$params->loadString($part->content);

		// Use parameters from template
		if (isset($attribs['params']))
		{
			$template_params = new JRegistry;
			$template_params->loadString(html_entity_decode($attribs['params'], ENT_COMPAT, 'UTF-8'));
			$params->merge($template_params);
			$part = clone $part;
			$part->params = (string) $params;
		}

		// Default for compatibility purposes. Set cachemode parameter or use JModuleHelper::moduleCache from within the
		// module instead
// 		$cachemode = $params->get('cachemode', 'oldstatic');

// 		if ($params->get('cache', 0) == 1 && $conf->get('caching') >= 1 && $cachemode != 'id' && $cachemode != 'safeuri')
// 		{

// 			// Default to itemid creating method and workarounds on
// 			$cacheparams = new stdClass;
// 			$cacheparams->cachemode = $cachemode;
// 			$cacheparams->class = 'CodeHelper';
// 			$cacheparams->method = 'render';
// 			$cacheparams->methodparams = array($part, $attribs);

// 			$contents = NgePartsHelper::PartCache($part, $params, $cacheparams);

// 		}
// 		else
// 		{ 
			$contents = NgePartHelper::getCode($part, $attribs);
// 		}

		return $contents;
	}
}
