<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 */
abstract class NgePartsHistoryHelper {

   
    /**
     * Get part by name 
     *
     * @param   string  $name   The name of the part
     * @param   string  $title  The title of the part, optional
     *
     * @return  object  The Part object
     *
     */

    public static function &getPart($name) {
	$result = null;
	
	if (substr($name, 0, 1) == '[')  //Normal call : parts with id
	    $name = str_replace(array('[', ']'), '', $name);
	
	$db = JFactory::getDbo();

	$query = $db->getQuery(true)
		->select('h.id, h.part as name, h.title, h.alias, h.content, h.params, "" as html, "" as css, "" as js, "" as thumbnail, null as published, h.created, h.created_by, l.title as library_title, l.description as library_description, pl.version, l.params as library_params ')
		->from('#__nge_parts_history AS h')
		->join('LEFT', '#__nge_parts AS p ON p.part = h.part_id')
		->join('LEFT', '#__nge_parts_library AS l ON l.part = p.part')
		->join('LEFT', '#__nge_categories AS cat ON cat.id = l.catid')
		->join('LEFT', '#__nge_plugins AS pl ON pl.name = cat.plugin');
		$query->where('h.id =' . (int) $name);
	// Set the query		
	$db->setQuery($query);

	try {
	    $result = $db->loadObject();
	} catch (RuntimeException $e) {
	    JLog::add($query, JLog::WARNING, 'jerror');
	    JLog::add(JText::sprintf('NGE_APPLICATION_ERROR_PARTS_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	}		

	if (substr($name, 0, 1) == '[')
	    $partId = substr($name, 1, strlen($name) - 2);
	else
	    $partId = $name;
	if (isset($parts[$partId]))
	    $result = $parts[$partId];

	// If we didn't find it, and the name is part_something, create a dummy object
	if (is_null($result)) {
	    $result = new stdClass;
	    $result->id = 0;
	    $result->title = '';
	    $result->alias = '';
	    $result->name = $name;
	    $result->library_title='';
	    $result->library_description='';		
	    $result->position = '';
	    $result->content = '';
	    $result->showtitle = 0;
	    $result->control = '';
	    $result->params = '';
	    $result->published = '';
	    $result->created_by = '';
	}

	return $result;
    }
    /**
     * Load published parts.
     *
     * @return  array
     *
     */
    protected static function &load($hk) {

	$db = JFactory::getDbo();

	$query = $db->getQuery(true)
		->select('h.id, h.part as name, h.title, h.alias, h.content, h.params, "" as html, "" as css, "" as js, "" as thumbnail, null as published, h.created, h.created_by, l.title as library_title, l.description as library_description, pl.version, l.params as library_params ')
		->from('#__nge_parts_history AS h')
		->join('LEFT', '#__nge_parts AS p ON p.part = h.part_id')
		->join('LEFT', '#__nge_parts_library AS l ON l.part = p.part')
		->join('LEFT', '#__nge_categories AS cat ON cat.id = l.catid')
		->join('LEFT', '#__nge_plugins AS pl ON pl.name = cat.plugin');
		$query->where('h.id =' . (int) $hk);
	// Set the query		
	$db->setQuery($query);

	try {
	    $part = $db->loadObject();
	} catch (RuntimeException $e) {
	    JLog::add($query, JLog::WARNING, 'jerror');
	    JLog::add(JText::sprintf('NGE_APPLICATION_ERROR_PARTS_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	    return $part;
	}		
	return $part;
    }


    /**
     * Method to get the history stored versions for an existing parts.
     *
     * @param	int	$pk	Id of the part
     */
    public static function getHistory($pk) {
	if ($pk == '')
	    return array();

	$db = JFactory::getDBO();
	$query = $db->getQuery(true);
	
	$query->select('h.id, CASE WHEN h.modified is null
	    THEN
	    (
	      select h.created
	    )
	    ELSE
	    (
	      select h.modified

	    )  
	END as modified');
	//$query->select('h.id, h.modified');
	$query->from('#__nge_parts_history AS h');
	$query->where('part_id = ' . (int) $pk);
	$query->order('h.id desc');
	$db->setQuery($query);
	$history = $db->loadObjectList();
	return $history;
    }
    
    /**
     * Method to get the data for specific id
     *
     * @param	int	$h_id	Id of the stored history that we want
     */
    public static function getData($h_id) {
	$db = JFactory::getDBO();
	$query = $db->getQuery(true);
	
	$query->select('h.id, h.part_id, h.title, h.alias, h.part as name, h.content, h.params, h.created_by, h.modified_by, CASE WHEN h.modified is null
	    THEN
	    (
	      select h.created
	    )
	    ELSE
	    (
	      select h.modified

	    )  
	END as modified');
	$query->from('#__nge_parts_history AS h');
	$query->where('id = ' . (int) $h_id);
	$db->setQuery($query);
	$history = $db->loadObject();
	return $history;
    }
}
