<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

use Joomla\Utilities\ArrayHelper;

require_once NGEPATH_HELPERS . '/ngedata.php';
require_once NGEPATH_HELPERS . '/ngefeatures.php';

/**
 */
abstract class NgePartsHelper {

   
    /**
     * Get part by name 
     *
     * @param   string  $name   The name of the part
     * @param   string  $title  The title of the part, optional
     *
     * @return  object  The Part object
     *
     */

    public static function &getPart($name, $title = null) {
	$result = null;
	
	//Searching published parts by id or library parts by alias
	//TODO loading all parts can be problematic if they are huge 
	if (substr($name, 0, 1) == '[') { //Normal call : parts with id
	    $names = array(str_replace(array('[', ']'), '', $name));
	    $parts = & static::load($names);
	} else
	    $parts = & static::loadLibraryparts(); //Calling part with partname : ex {part text.label}

	if (substr($name, 0, 1) == '[')
	    $partId = substr($name, 1, strlen($name) - 2);
	else
	    $partId = $name;
	if (isset($parts[$partId]))
	    $result = $parts[$partId];

	// If we didn't find it, and the name is part_something, create a dummy object
	if (is_null($result)) {
	    $result = new stdClass;
	    $result->id = 0;
	    $result->title = '';
	    $result->alias = '';
	    $result->name = $name;
	    $result->library_title='';
	    $result->library_description='';		
	    $result->position = '';
	    $result->content = '';
	    $result->showtitle = 0;
	    $result->control = '';
	    $result->params = '';
	    $result->published = '';
	    $result->created_by = '';
	}

	return $result;
    }

    /**
     * Get parts by name
     *
     * @param   string  $name   The name of the module
     * @param   string  $title  The title of the module, optional
     *
     * @return  object  The Part object
     *
     */
    public static function &getParts($namesArray) {

	return static::load($namesArray);
    }

    /**
     * Load published parts.
     *
     * @return  array
     *
     */
    protected static function &load($names = array()) {
	static $partsList;

	//V0.7 No more cache. Parts are always loaded when necessary
// 		if (isset($partsList))
// 		{
// 			return $partsList;
// 		}

	$app = JFactory::getApplication();
	//$user = JFactory::getUser();
	//$groups = implode(',', $user->getAuthorisedViewLevels());
	$lang = JFactory::getLanguage()->getTag();
	//$clientId = (int) $app->getClientId();

	$partsList = array();
	$db = JFactory::getDbo();

	$query = $db->getQuery(true)
		->select('p.id, p.part as name, p.title, p.alias, p.content, p.params, p.html, p.css, p.js, p.thumbnail, p.published, p.created, p.created_by, l.title as library_title, l.description as library_description, pl.version, l.params as library_params ')
		->from('#__nge_parts AS p')
		->join('LEFT', '#__nge_parts_library AS l ON l.part = p.part')
		->join('LEFT', '#__nge_categories AS cat ON cat.id = l.catid')
		->join('LEFT', '#__nge_plugins AS pl ON pl.name = cat.plugin')
		->where('l.state = 1')
		->where('p.published = 1');
	if (count($names) > 1){
	    $names = ArrayHelper::toInteger($names);
	    $query->where('p.id in("' . implode('", "', $names) . '")');
	}
	else
	if (count($names) == 1)
	    $query->where('p.id =' . (int) $names[0]);

	// Filter by language
	if ($app->isSite() && $app->getLanguageFilter()) {
	    $query->where('p.language IN (' . $db->quote($lang) . ',' . $db->quote('*') . ')');
	}
	//$query->order('p.id');

	try {
	    $parts = NGEDATA::loadObjectList($query);
	} catch (RuntimeException $e) {
	    JLog::add($query, JLog::WARNING, 'jerror');
	    JLog::add(JText::sprintf('NGE_APPLICATION_ERROR_PARTS_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	    return $partsList;
	}
	
	//warning : now order is not initial order, but select ids order
	for ($i = 0, $n = count($parts); $i < $n; $i++) {
	    $part = $parts[$i];
	    //$part->params = html_entity_decode($part->params);
	    $part->content = htmlspecialchars_decode($part->content);
	    $part->params = htmlspecialchars_decode($part->params);
	    $part->library_params = json_decode($part->library_params);
       
	    // part assets (permissions)
	    $part->asset_id = '';
	    if (NGEFeatures::enabled('nge.premium')){
		$sqlAssets = 'SELECT id FROM #__assets WHERE name=\'com_nge.part.' . (int) $part->id.'\'';
		$assetsId = NGEDATA::loadObject($sqlAssets);
		if($assetsId)
		    $part->asset_id = $assetsId->id;
	    }
	    
	    //$part->name = '[' . $part->id . ']';
	    $part->style = null;
	    $partsList[$part->id] = $part;
	}
	
	return $partsList;
    }


    /**
     * Load library parts.
     *
     * @return  array
     *
     */
    protected static function &loadLibraryparts() {
	static $cleanLibraryparts;

	if (isset($cleanLibraryparts)) {
	    return $cleanLibraryparts;
	}

	$app = JFactory::getApplication();
	$Itemid = $app->input->getInt('Itemid');
	$user = JFactory::getUser();
	$groups = implode(',', $user->getAuthorisedViewLevels());
	$lang = JFactory::getLanguage()->getTag();
	$clientId = (int) $app->getClientId();

	$db = JFactory::getDbo();

// 		$query = $db->getQuery(true)
// 		->select('l.id, l.part, pp.params')
// 		->from('#__nge_parts_library AS l')
// 		->join('LEFT', '#__nge_parts_library_patterns AS pp ON pp.part_library_id = l.id')
// 		->where('pp.pattern = "demo"')
// 		->where('l.state = 1');
	$query = $db->getQuery(true)
		//->select('l.part, l.default_params as params')
		->select('l.part as name, l.title as library_title')
		->from('#__nge_parts_library AS l')
		->join('LEFT', '#__nge_categories AS cat ON cat.id = l.catid')
		->where('l.state = 1');

	$cleanLibraryparts = array();

	try {
	    $parts = NGEDATA::loadObjectList($query);
	} catch (RuntimeException $e) {
	    JLog::add(JText::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	    return $cleanLibraryparts;
	}

	// Apply negative selections and eliminate duplicates
	$negId = $Itemid ? -(int) $Itemid : false;
	$dupes = array();
	for ($i = 0, $n = count($parts); $i < $n; $i++) {
	    $part = &$parts[$i];


	    if (isset($dupes[$part->name])) {
		// If this item has been excluded, keep the duplicate flag set,
		// but remove any item from the cleaned array.
		if ($negHit) {
		    unset($cleanLibraryparts[$part->name]);
		}
		continue;
	    }

	    $dupes[$part->name] = true;

	    // Only accept modules without explicit exclusions.
	    $part->style = null;
	    //$module->position = strtolower($part->position);
	    $cleanLibraryparts[$part->name] = $part;
	}

	unset($dupes);

	// Return to simple indexing that matches the query order.
	$cleanLibraryparts = array_values($cleanLibraryparts);

	return $cleanLibraryparts;
    }

    /**
     * Method to get the categories for an existing parts.
     *
     * @param	stringc	$plname		Name of the part
     */
    public static function getCategories($plname) {
	if ($plname == '')
	    return array();

	$db = JFactory::getDBO();

	// Get the part path from database
	$query = $db->getQuery(true);
	
	//Load the part title, and category
	$query->select('p.catid, p.title');
	$query->from('#__nge_parts_library AS p');
	$query->where('part = ' . $db->quote($plname));
	$partRow = NGEDATA::loadObject($query);
	
	//Load the parent categories
	$query = $db->getQuery(true);
	$query->select('c.id, c.title');
	$query->from('#__nge_categories AS c, #__nge_categories AS parent');
	$query->where('c.lft <= parent.lft AND c.rgt >= parent.rgt');
	$query->where('parent.published = 1');
	$query->where('c.published = 1');
	$query->where('parent.id = ' . (int) $partRow->catid);
	$query->order('c.lft');
	$categories = NGEDATA::loadAssocList($query);
	//Adding part title to end the path
	$categories[] = array('id' => '', 'title' => $partRow->title);
	return $categories;
    }

    /**
     * Load language file for the Pack of the part type (part library)
     *
     * @param	string	$plname		Name of the part
     */
    public static function loadPackConfigLanguage($plname) {

	$lang = JFactory::getLanguage();	
	// loading main language file if we are in backoffice
	$app = JFactory::getApplication();		
	if($app->isAdmin()) 
	    $lang->load('com_nge', JPATH_SITE);
	// load common pack config language file
	$lang->load('com_nge_pack', JPATH_SITE);
	
	//load specific language config file for a pack if exists
	// Searching plugin name for this part type
	$db = JFactory::getDBO();
	$query = $db->getQuery(true);
	$query->select('pc.plugin as name');
	$query->from('#__nge_parts_library AS pl');
	$query->join('inner', '#__nge_categories AS pc on pc.id = pl.catid');
	$query->where('pl.part = ' . $db->quote($plname));
	$pack = NGEDATA::loadObject($query);
	if (isset($pack)) {
	    //TODO loadlanguage in administration
	    $filename = 'com_nge_' . $pack->name;
	    $lang->load($filename, JPATH_SITE);
	}
    }
    
/**
 * Version of the pat, ie of the Pack
 * @param type $partname
 * @return type
 */
	public static function getVersion($partname) {
		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('pl.version');
		$query->from('#__nge_parts_library AS p');
		$query->join('left', '#__nge_categories AS pc on pc.id = p.catid');
		$query->join('left', '#__nge_plugins AS pl on pl.name = pc.plugin');
		$query->where('p.part = ' . $db->quote($partname));
		$version = NGEDATA::loadResult($query);
		return $version;		
	}
	
	
	public static function getLibraryGallery($partname) {
		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('p.title, p.description, pl.version');
		$query->from('#__nge_parts_library AS p');
		$query->join('left', '#__nge_categories AS pc on pc.id = p.catid');
		$query->join('left', '#__nge_plugins AS pl on pl.name = pc.plugin');
		$query->where('p.part = ' . $db->quote($partname));
		$data = NGEDATA::loadObject($query);
		return $data;		
	}
}