<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS . '/html/bootstrap/bootstraptag.php');
require_once NGEPATH_HELPERS . '/ngedata.php';

use Joomla\Utilities\ArrayHelper;

/**
 * Categories helper.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_categories
 * @since       1.6
 */
class NGEParts
{

    public static function load($names){
	
	$sql = 'SELECT p.id, p.part as name, p.title, p.alias, p.content, p.params, p.html, p.css, p.js, p.render, p.published, p.created, p.created_by, l.title as library_title, l.description as library_description, pl.version, l.params as library_params ';
	$sql .= 'FROM #__nge_parts AS p ';
	$sql .= 'LEFT JOIN kutah_nge_parts_library AS l ON l.part = p.part ';
	$sql .= 'LEFT JOIN kutah_nge_categories AS cat ON cat.id = l.catid ';
	$sql .= 'LEFT JOIN kutah_nge_plugins AS pl ON pl.name = cat.plugin ';
	$sql .= 'WHERE l.state = 1 ';
	$sql .= 'AND p.published = 1 ';
	if (count($names) > 1){
	    $names = ArrayHelper::toInteger($names);
	    $sql .= 'AND p.id in("' . implode('", "', $names) . '")';
	}
	else
	if (count($names) == 1)
	    $sql .= 'AND p.id =' . (int) $names;

	// Filter by language
/*	if ($app->isSite() && $app->getLanguageFilter()) {
	    $query->where('p.language IN (' . $db->quote($lang) . ',' . $db->quote('*') . ')');
	}*/

	try {
	    $part = NGEDATA::loadObject($sql);
	    return $part;
	} catch (RuntimeException $e) {
	//    JLog::add($query, JLog::WARNING, 'jerror');
	//    JLog::add(JText::sprintf('NGE_APPLICATION_ERROR_PARTS_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	    return $part;
	    
	}
}
	
    public static function display($id, $attribs = null){
	echo self::render($id, $attribs);
    }

    public static function render($id, $attribs = null)
	{
		//extra css for parts
		/*$document = Jfactory::getDocument(); 
		$document->addStyleSheet(JUri::root(). 'components/com_nge/assets/css/all.css', 'all');		
		$document->addStyleSheet(JUri::root() . 'components/com_nge/assets/css/screen.css', 'screen');
		$document->addStyleSheet(JUri::root() . 'components/com_nge/assets/css/print.css', 'print');
		$document->addScript(JUri::root(). 'components/com_nge/assets/js/bootstrap_check.php');
		 */

		$part = self::load($id);
		
		if (isset($attribs->rendering_mode)){
				$part->rendering = new stdClass();
				$part->rendering->mode = $attribs->rendering_mode; 
		}
		
				
		// Get parts parameters
		//Merge params in the params field and in the content field
		require_once NGEPATH_CLASSES . '/ngeparams.php';
		$params = new NgeParams();
		if ($part->content != ''){
		    $contentArray = json_decode($part->content, true);
		    $paramsArray = json_decode($part->params, true);
		    $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
		    $params->loadString(json_encode($mergedParams));
		}
		else
		    $params->loadString($part->params);

		$part->params = $params;
		// Use parameters from template

		$contents = self::_render($part, $attribs);						

		/*19/10/2015 $contents = NgeContentHelper::parse($contents, $attribs);*/
		
		return $contents;
	}
    
	/**
	 * Render the part.
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public static function _render($part, $attribs = null)
	{
		//PartHelper usable in each part implementation
		//require_once $path = JPATH_ADMINISTRATOR . '/components/com_nge/helpers/parts.php';
	
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
		
		$directories = '';
		$name = "";
		$part->cacheable = false;
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
			$name .= $partpath[count($partpath)-1];
			$path = NGEPATH_PARTS . '/'.$directories.'part.php';

			//If in edit mode, load Part Languages, for part title in the part toolbar
			/*if(isset($part->rendering) && isset($part->rendering->mode) && ($part->rendering->mode == 'edit'));
			    NgePartsHelper::loadLibraryPackLanguage($part->name);*/
			
			// Load the path
			if (file_exists($path))
			{  //Todo load language before : only one call
				//$lang = JFactory::getLanguage();
	
				// 1.5 or Core then 1.6 3PD
				//Searching language in common com_nge languages files
				//Or in part subdirectories
				//$lang->load('com_nge', JPATH_BASE, null, false, true) ||
				//$lang->load($name, dirname($path), null, false, true);

				$content = '';						
				ob_start();
				include JPath::check($path);
				$part->content = ob_get_contents(); // . $content;
				ob_end_clean();
			}

			if (!(isset($attribs->minify) && ($attribs->minify == false))) {				
				$part->content = NGE::minify($part->content);
			}
						
			return $part->content;	
	}


	
}