<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS . '/html/bootstrap/bootstraptag.php');
require_once NGEPATH_CLASSES . '/ngepartobject.php';
require_once NGEPATH_HELPERS . '/ngedata.php';

/**
 */
class NgePartHelper
{
	
    /**
     * NgePartHelper::getPart()
     *
     * @param int $pk
     * @return $part object
     */
    public static function getPart($pk) {
    	$sql = 'SELECT * FROM #__nge_parts WHERE id=' . (int) $pk;
	$data = NGEDATA::loadObject($sql);
    	$part = new NgePartObject($data);
    	return $part;
    }
	
	/**
	 * Generate action for a part
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public static function generate($part, $attribs = array())
	{
		//PartHelper usable in each part implementation
		//require_once $path = JPATH_ADMINISTRATOR . '/components/com_nge/helpers/parts.php';
	
		if (defined('JDEBUG'))
		{
			JProfiler::getInstance('Application')->mark('beforeGeneratePart ' . $part->name . ' (' . $part->id . ')');
		}
	
		$app = JFactory::getApplication();
	
		// Record the scope.
		$scope = $app->scope;
	
		// Set scope to component name
		$app->scope = $part->name;
	
		// Get parts parameters
		//Merge params in the params field and in the content field
		//Loading content params
		$contentParams = new JRegistry;		
		$contentParams->loadString($part->content);
		//Loading params
		$params = new JRegistry;
		$params->loadString($part->params);
		//Merge content params
		$params->merge($contentParams);
	
	
		// Get the template
		//$template = $app->getTemplate();
	
		//Generation result object
		$generation = new StdClass();
		$generation->result = '1';
		$generation->message = 'MEssage OK';
		$generation->html = 'XXXXXX';
		
		
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
	
		$directories = '';
		$name = "";
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
		$name .= $partpath[count($partpath)-1];
	
		$path = JPATH_SITE . '/components/com_nge/parts/'.$directories.'generate.php';
		
					// Load the path
					if (file_exists($path)){
						$lang = JFactory::getLanguage();
	
						// 1.5 or Core then 1.6 3PD
						//Searching language in common com_nge languages files
						//Or in part subdirectories
						$lang->load('com_nge', JPATH_BASE, null, false, true) ||
						$lang->load($name, dirname($path), null, false, true);
	
						$content = '';
						//ob_start();
						include JPath::check($path);
						//$result = ob_get_contents();
						//ob_end_clean();
					}
	
	
		// Revert the scope
		$app->scope = $scope;
	
		if (defined('JDEBUG'))
		{
			JProfiler::getInstance('Application')->mark('afterGeneratePart ' . $part->name . ' (' . $part->id . ')');
		}
	
		//return $result;
		return $generation;
	
	}

	/**
	 * Help preview for a part
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public static function help($part, $attribs = array())
	{
	
		// Get parts parameters
		//Merge params in the params field and in the content field
		//Loading content params
		$contentParams = new JRegistry;		
		$contentParams->loadString($part->content);
		//Loading params
		$params = new JRegistry;
		$params->loadString($part->params);
		//Merge content params
		$params->merge($contentParams);
				
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
	
		$directories = '';
		$name = "";
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
		$name .= $partpath[count($partpath)-1];
	
		$path = JPATH_SITE . '/components/com_nge/parts/'.$directories.'help.php';
		
		// Load the path
		if (file_exists($path)){
			$lang = JFactory::getLanguage();

			// 1.5 or Core then 1.6 3PD
			//Searching language in common com_nge languages files
			//Or in part subdirectories
			$lang->load('com_nge', JPATH_BASE, null, false, true) ||
			$lang->load($name, dirname($path), null, false, true);

			//load Pack language
			NgePartsHelper::loadPackConfigLanguage($part->name);

			$content = '';
			ob_start();
			include JPath::check($path);
			$content = ob_get_contents();
			ob_end_clean();
		}
		else 
			$content = 'No help available';
		
		//return $result;
		return $content;
	
	}

	/**
	 * Custom function for a part
	 *
	 * @param   string  $task   Name of the task
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public static function customtask($task, $part, $attribs = array())
	{
	
		$app = JFactory::getApplication();
	
		// Record the scope.
		$scope = $app->scope;
	
		// Set scope to component name
		$app->scope = $part->name;
	
		// Get parts parameters
		//Merge params in the params field and in the content field
		//Loading content params
		$contentParams = new JRegistry;		
		$contentParams->loadString($part->content);
		//Loading params
		$params = new JRegistry;
		
                if ($part->content != ''){
		    $contentArray = json_decode($part->content, true);
		    $paramsArray = json_decode($part->params, true);
		    $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
		    $params->loadString(json_encode($mergedParams));
		}
		else
		    $params->loadString($part->params);
                
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
	
		$directories = '';
		$name = "";
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
		$name .= $partpath[count($partpath)-1];

		$path = JPATH_SITE . '/components/com_nge/parts/'.$directories.$task.'.php';

		// Load the path
		if (file_exists($path)){
			$lang = JFactory::getLanguage();

			// 1.5 or Core then 1.6 3PD
			//Searching language in common com_nge languages files
			//Or in part subdirectories
			$lang->load('com_nge', JPATH_BASE, null, false, true) ||
			$lang->load($name, dirname($path), null, false, true);

			$content = '';
			ob_start();
			include JPath::check($path);
			$content = ob_get_contents();
			ob_end_clean();
		}
		else 
			$content = 'No customtask file found : ' . $path;
	
		// Revert the scope
		$app->scope = $scope;
		
		//return $result;
		return $content;
	
	}
	
    /**
     * Duplicate part : direct duplication from one media to another, without config form screen
     *
     */
    public static function duplicate($part_id, $medium, $medium_id, $return) {
       
	$db = JFactory::getDbo();
	$user = JFactory::getUser();
	
	//Loading existing part
	$query = 'SELECT p.id, p.title, p.alias, p.part, p.content, p.params, p.html, p.css, p.js, p.language, p.publish_up, p.publish_down, p.published FROM #__nge_parts AS p WHERE id=' . (int) $part_id;
	$oldpart = NGEDATA::loadObject($query);

	//Change alias if necessary for the new duplicate part
	if ($oldpart->alias != '' && $oldpart->alias != null) {
	    $oldpart->alias = explode("_", $oldpart->alias);
	    $oldpart->alias = $oldpart->alias[0] . "_" . mt_rand();
	}

	//Duplicate all children part and change the content for the new duplicate part
	preg_match_all("/data-part=\"([^\"]*)\"/", stripslashes($oldpart->content), $matches_part);

	$new_part_id = array();
	$new_part_content = $oldpart->content;
	if (isset($matches_part) && !empty($matches_part)) {
	    foreach ($matches_part[1] as $key => $children_part_id) {
		$new_part_id[$key] = self::duplicate($children_part_id, "", "", "");
	    }

	    $new_part_content = str_replace($matches_part[1], $new_part_id, $oldpart->content);
	}

	//Creating new part
	$columns = array('part', 'title', 'alias', 'content', 'params', 'language', 'publish_up', 'publish_down', 'published', 'created', 'created_by');
	$values = array($db->quote($oldpart->part), $db->quote($oldpart->title), $db->quote($oldpart->alias), $db->quote($new_part_content), $db->quote($oldpart->params), $db->quote($oldpart->language), $db->quote($oldpart->publish_up), $db->quote($oldpart->publish_down),  (int) $oldpart->published, 'NOW()', (int) $user->id);
	$query = $db->getQuery(true)
		->insert($db->quoteName('#__nge_parts'))
		->columns($db->quoteName($columns))
		->values(implode(',', $values));	
	$db->setQuery($query);
	$result = $db->execute();

	//Finding the new part id
	$query->clear();
	$query
		->select('id')
		->from('`#__nge_parts`')
		->order('ID Desc')
		->limit('0,1');
	$db->setQuery($query);
	$row = $db->loadObject();
	$idpart = $row->id;

	//If medium exists, the new part must be created in the medium
	if ($medium != '') {

	    //Assigning the new part to the medium
	    if ($medium == 'workshop') {

		if ($medium_id == '') { //No workshop id, finding default value : the most recent workshop id
		    $query->clear();
		    $query
			    ->select('id')
			    ->from('`#__nge_parutions`')
			    ->order('ID Desc')
			    ->limit('0,1');
		    if ($publication_id != '')
			$query->where('id_publication=' . (int) $publication_id);
		    $db->setQuery($query);
		    $row = $db->loadObject();
		    $medium_id = $row->id;
		}

		//Adding the new part to the most recent workshop					
		$query = $db->getQuery(true);
		$columns = array('id_parution', 'id_part', 'actif');
		//$values = array($medium_id, $this->idpart, 1);
		$values = array($medium_id, $idpart, 1);
		$query
			->insert($db->quoteName('#__nge_parution_parts'))
			->columns($db->quoteName($columns))
			->values(implode(',', $values));
		$db->setQuery($query);
		$result = $db->execute();
	    }
	}

	return $idpart;
    }

    
    /**
     * Restore part from old history
     *
     */
    public static function restore($part_id, $medium, $medium_id, $return) {
       
        $user = JFactory::getUser();
	//Loading existing part
	$db = JFactory::getDbo();
	$query = $db->getQuery(true)
		->select('p.part_id, p.title, p.title, p.alias, p.part, p.content, p.params, p.language')
		->from('#__nge_parts_history AS p')
		->where('id=' . (int) $part_id);
	$db->setQuery($query);
	$oldpart = $db->loadObject();

	//Duplicate all children part and change the content for the new duplicate part
	preg_match_all("/data-part=\"([^\"]*)\"/", stripslashes($oldpart->content), $matches_part);

	$new_part_id = array();
	$new_part_content = $oldpart->content;
	if (isset($matches_part) && !empty($matches_part)) {
	    foreach ($matches_part[1] as $key => $children_part_id) {
		$new_part_id[$key] = self::duplicate($children_part_id, "", "", "");
	    }

	    $new_part_content = str_replace($matches_part[1], $new_part_id, $oldpart->content);
	}

	//Updating the current part
	$query->clear();
	$columns = array('part', 'title', 'alias', 'content', 'params', 'html', 'css', 'js', 'language', 'modified', 'modified_by');
	$values = array("'" . $oldpart->part . "', '" . addslashes($oldpart->title) . "', '" . $oldpart->alias . "', '" . addslashes($oldpart->content) . "', '" . addslashes($oldpart->params) . "', '', '', '', '" . $oldpart->language . "', 'NOW()", $user->id);
	$query	->insert($db->quoteName('#__nge_parts'))
		->columns($db->quoteName($columns))
		->values(implode(',', $values));

	$db->setQuery($query);
	$result = $db->execute();

	return $result;
    }
    
    
	/**
	 * Get php code for creating part
	 *
	 * @param   object  $module   A module object.
	 * @param   array   $attribs  An array of attributes for the module (probably from the XML).
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 * @since   1.5
	 */
	public static function getCode($part, $attribs = null)
	{
	
		$app = JFactory::getApplication();
	
		// Record the scope.
		$scope = $app->scope;
	
		// Set scope to component name
		$app->scope = $part->name;
	
		// Get parts parameters
		//Merge params in the params field and in the content field
		//Loading content params
		$contentParams = new JRegistry;		
		$contentParams->loadString($part->content);
		//Loading params
		$params = new JRegistry;
		$params->loadString($part->params);
		//Merge content params
		$params->merge($contentParams);	
	
		// Get the template
		$template = $app->getTemplate();
	
		// Get part path
		$part->name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
		//Part name contains directory + name
		$partpath = explode('.', $part->name);
		$directories = '';
		$name = "";
		for ($i=0; $i<count($partpath); $i++)
			$directories .= $partpath[$i].'/';
			$name .= $partpath[count($partpath)-1];
	
			$path = JPATH_SITE . '/components/com_nge/parts/'.$directories.'code.php';

			// Load the path
			if (file_exists($path))	{
				$lang = JFactory::getLanguage();
	
				//Searching language in common com_nge languages files
				//Or in part subdirectories
				$lang->load('com_nge', JPATH_BASE, null, false, true) ||
				$lang->load($name, dirname($path), null, false, true);

				$code = '';
				ob_start();
				include JPath::check($path);
				$part->code = ob_get_contents() . $code;
				ob_end_clean();
			}
			else
				$part->code = '';
		
			return $part->code;
	
	}
	

	
    /**
     * Load language file for the Pack of the part
     *
     * @param	numeric	$pk		Id of the part
     */
    public static function loadPartConfigLanguage($pk) {

	$lang = JFactory::getLanguage();	
	// loading main language file if we are in backoffice
	$app = JFactory::getApplication();		
	if($app->isAdmin()) 
	    $lang->load('com_nge', JPATH_SITE);
	// load common pack config language file
	$lang->load('com_nge_pack', JPATH_SITE);

	//load specific language config file for the pack of this part if exists
	// Searching plugin name for this part type
	$db = JFactory::getDBO();
	$query = $db->getQuery(true);
	$query->select('pc.plugin as name');
	$query->from('#__nge_parts AS p');
	$query->join('inner', '#__nge_parts_library AS pl on pl.part = p.part');
	$query->join('inner', '#__nge_categories AS pc on pc.id = pl.catid');
	$query->where('p.id = ' . (int) $pk);
	$db->setQuery($query);
	$pack = $db->loadObject();	
	if (isset($pack)) {
	    //TODO loadlanguage in administration
	    $filename = 'com_nge_' . $pack->name;
	    $lang->load($filename, JPATH_SITE);
	}
    }
	
}
