<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * Nge Features
 *
 */
class NGEFeatures
{

    private static $_features = null;

    public static function enabled($name){
	if (self::$_features == null) {
	    self::_getFeatures(); 
	}
	return (isset(self::$_features[$name]) && self::$_features[$name]);
    }	

    //Package level for internal directories
    public static function package(){
	return 'free';
    }
    
    private static function _getFeatures(){
	
	$user = JFactory::getUser();
	self::$_features = array();
	
	//Front editing for authors
	self::$_features['frontediting.edit'] = $user->authorise('core.admin') || $user->authorise('core.edit', 'com_content') || $user->authorise('core.edit', 'com_modules');
	self::$_features['editing.dropediting'] = true;
	self::$_features['editing.inlineediting'] = true;
	
	self::$_features['parts.editing'] = true;
	self::$_features['parts.dropediting'] = true;
	
	//Modules management
	    $user = JFactory::getUser();
	    $canCreateModules = $user->authorise('core.create', 'com_modules');
	    $canEditModules = $user->authorise('core.edit', 'com_modules');
	    $canDeleteModules = $user->authorise('core.delete', 'com_modules');
	    self::$_features['editing.joomla.modules'] = ($canCreateModules || $canEditModules || $canDeleteModules);
	//Articles management
	self::$_features['editing.joomla.articles'] = true;	
	self::$_features['editing.toolbar'] = true;	
	
	//Joomla elements management (article or modules titles, images, ....
	self::$_features['editing.joomla.elements'] = true;

	//Widgets
	self::$_features['nge.free'] = true;
    }	    
    
}