<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(JPATH_ROOT.'/components/com_payplans/xiframework/base/helper/utils.php');


/**
 * Categories helper.
 *
 * @package     NextGenEditor.helpers
 * @subpackage  front
 * @since       1.1.0
 */
class NGEDownload
{
    private static $freeVersionAlias      = 'nextgeneditor-full-free';
    //private static $freeVersionAlias      = 'nextgeneditor-free';
    private static $essentialVersionAlias = 'nextgeneditor-full-essential';
    private static $proVersionAlias       = 'nextgeneditor-full-pro';
    private static $premiumVersionAlias   = 'nextgeneditor-full-premium';
    
    private static $freeVersionFile      = 'nextgeneditor_full_free.zip';
    private static $essentialVersionFile = 'nextgeneditor_full_essential.zip';
    private static $proVersionFile       = 'nextgeneditor_full_pro.zip';
    private static $premiumVersionFile   = 'nextgeneditor_full_premium.zip';

    private static $downloadSourceDirectory = '/download/current/';
    private static $freeSourceDirectory = 'free/';
    
    private static $payplansPlans = Array('1'=>'essential', '2'=>"essential", '3'=>'pro', '4'=>'premium');

    /**
     * NGEDownload::getFileToDownload()
     * 
     * @param mixed $subscription_id
     * @return file name and path 
     */
    public static function getFileToDownload($cryptedSubscriptionId) {
        
        // decrypt crypted subscription id
        $subscription_id =  XiHelperUtils::getIdFromKey($cryptedSubscriptionId);       

        
        // $subscription_id = '', download free version
        if($subscription_id=='') {
            $fileToDownload = new stdClass();
            $packageXml = simplexml_load_file(JPATH_BASE . self::$downloadSourceDirectory . self::$freeSourceDirectory . 'pkg_nge.xml');

            $fileToDownload->filename      = JPATH_BASE . self::$downloadSourceDirectory . self::$freeSourceDirectory . self::$freeVersionFile; 
            $fileToDownload->shortFilename = self::$freeVersionFile; 
            $fileToDownload->version       = (string)$packageXml->version;; 
        }
        else {
			// get running subscription 
			$runningSubscription = self::_getRunningSubscription($subscription_id);

			// running subscription is null, return nothing to install
			if($runningSubscription===false)
				$fileToDownload=false;	
			else { // prepare package
				$fileToDownload = self::_getPackageToDownload($runningSubscription);
			}
			
		}
        
        
        
        return $fileToDownload;
        
    }
    
    /**
     * NGEDownload::getJDownloadFileToDownload()
     * 
     * @return
     */
    public static function getJDownloadFileToDownload() {
        
        $user = JFactory::getUser();
        $freeNgeVersion = $fileToDownload = JPATH_BASE . self::$downloadSourceDirectory . self::$freeSourceDirectory . self::$freeVersionFile;
        
        // user is guest, download free version
        if( $user->guest ) {
            
            $fileToDownload = $freeNgeVersion; 
        }
        else {
			// get running subscription 
			$userRunningSubscription = self::_getUserRunningSubscription($user->id);

			// running subscription is null, return free version
			if($userRunningSubscription===false)
				$fileToDownload==$freeNgeVersion;	
			else { // prepare package
				$fileToDownload = self::_getPackageToDownload($userRunningSubscription);
			}
			
		}
        
        
        
        return $fileToDownload;
        
    }
    
     /**
      * NGEDownload::_getRunningSubscription()
      * 
      * @param mixed $subscription_id
      * @return false or plan id
      */
     private static function _getRunningSubscription($subscription_id) {
        $db	= JFactory::getDBO();

        // user id for subscription id
        $sql = sprintf('SELECT user_id FROM 
                    #__payplans_subscription WHERE subscription_id=%d',$subscription_id);
        $db->setQuery( $sql) ;
        $user_id = $db->loadResult();
        
        if(!$user_id)
            return false;
        
        // running plan for this user id ?    
        $plan = self::_getUserRunningSubscription($user_id);
        
        if(!$plan) {
            return false;
        }
        else {
            return $plan;
        }
        
        
	 }
     
     /**
      * NGEDownload::_getUserRunningSubscription()
      * 
      * @param mixed $user_id
      * @return
      */
     private static function _getUserRunningSubscription($user_id) {
        $db	= JFactory::getDBO();  

        // running plan for this user id ?
        $sql = sprintf('SELECT subscription_id, plan_id FROM #__payplans_subscription
                            WHERE user_id=%s AND expiration_date>=NOW() 
                                AND (cancel_date="0000-00-00 00:00:00" OR (!cancel_date="0000-00-00 00:00:00" AND cancel_date>=NOW() ))', (int) $user_id);
        $db->setQuery( $sql) ;
        $plan = $db->loadObject();

        if(!$plan) {
            return false;
        }
        else {
            return $plan;
        }

     }
    
    /**
     * NGEDownload::_getPackageToDownload()
     * 
     * @param mixed $Subscription
     * @return void
     */
    private static function _getPackageToDownload($subscription) {
        
        // made encrypt payplan subscription id
        $cryptedSubscriptionKey = XiHelperUtils::getKeyFromId($subscription->subscription_id);

        // plan source directory
        $planDir = self::$payplansPlans[ $subscription->plan_id ];
        
        $sourceDir = JPATH_BASE . self::$downloadSourceDirectory . $planDir;
        
        // dest tmp directory
        
        $tmpDir = JPATH_BASE . '/tmp/' . $cryptedSubscriptionKey;
        $zipTmpDir = JPATH_BASE . '/tmp/zip/';
        if(!JFolder::exists($zipTmpDir)) {
            JFolder::create($zipTmpDir);
           
        }
        
        // copy package to tmp dir
        if(JFolder::exists($tmpDir))
            JFolder::delete($tmpDir);

         $e = JFolder::copy($sourceDir,$tmpDir);

        if(!file_exists($tmpDir . '/pkg_nge.xml')) {
            exit('error');
        }
         
        // update nge_subscription.json with subscription id
        $subscriptionArray['subscription_id'] = $cryptedSubscriptionKey;

		$zip = new ZipArchive();
        $packageXml = simplexml_load_file($tmpDir . '/pkg_nge.xml');
		$zipFilename = $tmpDir . '/packages/com_nge_'.(string)$packageXml->version.'.zip';
		
		if($zip->open($zipFilename,ZipArchive::CREATE) !== true )
			exit('impossible d\'ouvrir l\'archive');
			
		if($zip->addFromString('admin/nge_subscription.json',json_encode($subscriptionArray))!==true)
			exit('no create');
            
		$zip->close();
		
		// create the zip to download
		$ListeFile = JFolder::files($tmpDir,'.',TRUE,true);

		$zipDestinationFilemame = $zipTmpDir . 'nextgeneditor_full_'.$planDir.'_'.$cryptedSubscriptionKey.'.zip';
		
		$opened = $zip->open($zipDestinationFilemame,ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE);
        if( $opened !== true ){
            $zip->open($zipDestinationFilemame,ZIPARCHIVE::CREATE );
        }
        
		foreach($ListeFile as $file) {
		  
		    $filedest = str_replace(str_replace('/','\\',$tmpDir).'\\' , '' ,str_replace('/','\\',$file));
			$zip->addFile($file,$filedest);
		}
		$zip->close();
        
        // file to download object
        // get package version
        $packageXml = simplexml_load_file($tmpDir . '/pkg_nge.xml');

        $fileToDownload = new stdClass();
        $fileToDownload->filename      = $zipDestinationFilemame; 
        $fileToDownload->shortFilename = 'nextgeneditor_full_'.$planDir.'.zip'; 
        $fileToDownload->version       = (string)$packageXml->version; 

        JFolder::delete($tmpDir);
        
        return $fileToDownload;
        
    }
    
    

}