<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once NGEPATH_HELPERS . '/ngedata.php';

/**
 * Display restrictions helper.
 *
 */
abstract class NgeDisplaytHelper
{
	

    /**
     * Can view part : always / never / onlyedit
     */
    public static function canViewPart($displayParams, $renderingMode) {
	
	$canDisplay = true;
	$canEdit = true;
	
	if (isset($displayParams->rules) && ($displayParams->rules != 'always')){

	    //User level
	    //Visible in edit mode in front
	    if (($renderingMode == "view") && ($displayParams->filters->userlevel->rule != 'all') && isset($displayParams->filters->user->values) && count($displayParams->filters->userlevel->values) != 0){
		$currentUserLevels = JFactory::getUser()->getAuthorisedViewLevels();
		if (count($currentUserLevels) > 0){
		    $inValues = array_intersect($currentUserLevels, $displayParams->filters->userlevel->values);
		    if ((!$inValues && $displayParams->filters->userlevel->rule == 'only') || ($inValues && $displayParams->filters->userlevel->rule == 'except'))
			$canDisplay = false;
		}
		else
		    if ($displayParams->filters->userlevel->rule == 'only') $canDisplay = false;
	    }

	    //User group
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->usergroup->rule != 'all') && isset($displayParams->filters->usergroup->values) && count($displayParams->filters->usergroup->values) != 0){
		$currentUserGroups = JFactory::getUser()->getAuthorisedGroups();
		if (count($currentUserGroups) > 0){
		    $inValues = array_intersect($currentUserGroups, $displayParams->filters->usergroup->values);
		    if ((!$inValues && $displayParams->filters->usergroup->rule == 'only') || ($inValues && $displayParams->filters->usergroup->rule == 'except'))
			$canDisplay = false;
		}
		else
		    if ($displayParams->filters->usergroup->rule == 'only') $canDisplay = false;
	    }

	    //User
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->user->rule != 'all') && isset($displayParams->filters->user->values) && count($displayParams->filters->user->values) != 0){
		$currentUserId = JFactory::getUser()->id;
		if ($currentUserId != 0){
		    $inValues = in_array($currentUserId, $displayParams->filters->user->values);
		    if ((!$inValues && $displayParams->filters->user->rule == 'only') || ($inValues && $displayParams->filters->user->rule == 'except'))
			$canDisplay = false;
		}
		else
		    if ($displayParams->filters->user->rule == 'only') $canDisplay = false;
	    }


	    //Menuitem Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->menuitem->rule != 'all') && isset($displayParams->filters->menuitem->values) && count($displayParams->filters->menuitem->values) != 0){
		$currentMenu = JFactory::getApplication()->getMenu();
		if (isset($currentMenu)){ 
		    $activeMenu = $currentMenu->getActive();
		    if (isset($activeMenu)){ 
			$currentMenuId = $currentMenu->getActive()->id;
			$inValues = in_array($currentMenuId, $displayParams->filters->menuitem->values);
			if ((!$inValues && $displayParams->filters->menuitem->rule == 'only') || ($inValues && $displayParams->filters->menuitem->rule == 'except'))
			    $canDisplay = false;
		    }
		    else
			if ($displayParams->filters->menuitem->rule == 'only') $canDisplay = false;
		}
		else { //No current menu
		    if ($displayParams->filters->menuitem->rule == 'only') $canDisplay = false;
		}
	    }

	    //Category.  Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->category->rule != 'all') && isset($displayParams->filters->category->values) && count($displayParams->filters->category->values) != 0){
		$input=Jfactory::getApplication()->input;
		$id = $input->getInt('id');
		if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){
		    $db=JFactory::getDbo(); 
		    $db->setQuery('select catid from #__content where id=' . (int) $id); 
		    $catid=$db->loadResult(); 
		    if ($catid != 0){ 
			//Searching subcategories. To find if the current article is inside the selected categores or inside one of their subcategories
			/*$categoriesIds = array();
			$categories = JCategories::getInstance('Content');
			    foreach ($displayParams->filters->category->values as $categoryId){
			    $categoriesIds[] = $categoryId;			    
			    $category = $categories->get($categoryId);
			    $children = $category->getChildren(true);
			    foreach ($children as $child) {
				$categoriesIds[] = $child->id;
			    }			    
			}*/
			$categoriesIds = $displayParams->filters->category->values;
			$inValues = in_array($catid, $categoriesIds);
			if ((!$inValues && $displayParams->filters->category->rule == 'only') || ($inValues && $displayParams->filters->category->rule == 'except'))
			    $canDisplay = false;
		    }
		    else { //No current menu
			if ($displayParams->filters->category->rule == 'only') $canDisplay = false;
		    }
		}
		else //No category
		    if ($displayParams->filters->category->rule == 'only') $canDisplay = false;			
	    }

	    //Tag.  Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->tag->rule != 'all') && isset($displayParams->filters->tag->values) && count($displayParams->filters->tag->values) != 0){
		$input=Jfactory::getApplication()->input;
		$id = $input->getInt('id');
		if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){
		    $db=JFactory::getDbo(); 
		    $db->setQuery('select tag_id from #__contentitem_tag_map where type_alias="com_content.article" AND content_item_id=' . (int) $id); 
		    $tagsid=$db->loadColumn(0); 
		    if (count($tagsid) != 0){ 
			$inValues = array_intersect($tagsid, $displayParams->filters->tag->values);
			if ((!$inValues && $displayParams->filters->tag->rule == 'only') || ($inValues && $displayParams->filters->tag->rule == 'except'))
			    $canDisplay = false;
		    }
		    else { //No current menu
			if ($displayParams->filters->tag->rule == 'only') $canDisplay = false;
		    }
		}
		else //No category
		    if ($displayParams->filters->tag->rule == 'only') $canDisplay = false;			
	    }

	    //Article.  Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->article->rule != 'all') && isset($displayParams->filters->article->values) && count($displayParams->filters->article->values) != 0){
		$input=Jfactory::getApplication()->input;
		if($input->getCmd('option')=='com_content' && $input->getCmd('view')=='article' ){				
		    $articleId = $input->getInt('id');
			$inValues = in_array($articleId, $displayParams->filters->article->values);
			if ((!$inValues && $displayParams->filters->article->rule == 'only') || ($inValues && $displayParams->filters->article->rule == 'except'))
			    $canDisplay = false;
		}
		else //No category
		    if ($displayParams->filters->article->rule == 'only') $canDisplay = false;			
	    }

	    //Component.  Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->component->rule != 'all') && isset($displayParams->filters->component->values) && count($displayParams->filters->component->values) != 0){
		$input=Jfactory::getApplication()->input;			    
		$component = $input->getCmd('option');
		$inValues = in_array($component, $displayParams->filters->component->values);
		if ((!$inValues && $displayParams->filters->component->rule == 'only') || ($inValues && $displayParams->filters->component->rule == 'except'))
		    $canDisplay = false;
	    }

	    //Language.  Hidden also in edit mode
	    if ((in_array($renderingMode, array("view", "edit"))) && ($canDisplay == true) && ($displayParams->filters->language->rule != 'all') && isset($displayParams->filters->language->values) && count($displayParams->filters->language->values) != 0){
		$lang = JFactory::getLanguage()->getTag();
		$inValues = in_array($lang, $displayParams->filters->language->values);
		if ((!$inValues && $displayParams->filters->language->rule == 'only') || ($inValues && $displayParams->filters->language->rule == 'except'))
		    $canDisplay = false;
	    }

	    //Date : format yyyy-mm-dd hh:mm:ss => 'Y-m-d H:i:s'
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->date->rule != 'all')){
		if (isset($displayParams->filters->date->from) && (trim($displayParams->filters->date->from) != "")){
		    $fromDate = $displayParams->filters->date->from;
		    $nowDate = (string) date('Y-m-d H:i:s');
		    //String comparison. Is sufficient and prevents date format exceptions				
		    if ((($nowDate < $fromDate) && $displayParams->filters->date->rule == 'only') || ($nowDate >= $fromDate && $displayParams->filters->date->rule == 'except'))
			$canDisplay = false;
		}
		if (isset($displayParams->filters->date->to) && ($displayParams->filters->date->to != "")){
		    $toDate = $displayParams->filters->date->to;
		    $nowDate = (string) date('Y-m-d H:i:s');
		    //String comparison. Is sufficient and prevents date format exceptions				
		    if (($nowDate >= $toDate && $displayParams->filters->date->rule == 'only') || ($nowDate < $toDate && $displayParams->filters->date->rule == 'except'))
			$canDisplay = false;
		}
	    }

	    //Time : format hh:mm:ss => 'H:i:s'
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->time->rule != 'all')){
		if (isset($displayParams->filters->time->from) && (trim($displayParams->filters->time->from) != "")){
		    $fromTime = $displayParams->filters->time->from;
		    $nowTime = (string) date('H:i:s');
		    //String comparison. Is sufficient and prevents time format exceptions				
		    if ((($nowTime < $fromTime) && $displayParams->filters->time->rule == 'only') || ($nowTime >= $fromTime && $displayParams->filters->time->rule == 'except'))
			$canDisplay = false;
		}
		if (isset($displayParams->filters->time->to) && ($displayParams->filters->time->to != "")){
		    $toTime = $displayParams->filters->time->to;
		    $nowTime = (string) date('H:i:s');
		    //String comparison. Is sufficient and prevents date format exceptions				
		    if (($nowTime >= $toTime && $displayParams->filters->time->rule == 'only') || ($nowTime < $toTime && $displayParams->filters->time->rule == 'except'))
			$canDisplay = false;
		}
	    }

	    //Month
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->month->rule != 'all') && isset($displayParams->filters->month->values) && count($displayParams->filters->month->values) != 0){
		$currentMonth = (string) date('n'); 
		$inValues = in_array($currentMonth, $displayParams->filters->month->values);
		if ((!$inValues && $displayParams->filters->month->rule == 'only') || ($inValues && $displayParams->filters->month->rule == 'except'))
		    $canDisplay = false;
	    }

	    //Day of week			
	    if (($renderingMode == "view") && ($canDisplay == true) && ($displayParams->filters->dayofweek->rule != 'all') && isset($displayParams->filters->dayofweek->values) && count($displayParams->filters->dayofweek->values) != 0){
		$jd = cal_to_jd(CAL_GREGORIAN,date("m"),date("d"),date("Y"));
		$dayOfWeek = jddayofweek($jd);
		$inValues = in_array($dayOfWeek, $displayParams->filters->dayofweek->values);
		if ((!$inValues && $displayParams->filters->dayofweek->rule == 'only') || ($inValues && $displayParams->filters->dayofweek->rule == 'except'))
		    $canDisplay = false;
	    }
	}
	return $canDisplay;

    }
	
	
}
