<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once NGEPATH_HELPERS . '/ngedata.php';

/**
 * Nge Content helper class
 *
 * @package   
 * @subpackage 
 * @since       $_contentPluginLayouts
 */
abstract class NgeContentHelper {

	static $_currentArticle; //article information in the current page (cf Content plugin)
	static $_scripts; //Scripts pool for all parts to be rendered in the current Joomla document	
	static $_styleSheets; //Stylesheets pool for all parts to be rendered in the current Joomla document
	static $_styles; //Styles pool for all parts to be rendered in the current Joomla document
	static $_fonts; //Fonts pool for all parts to be rendered in the current Joomla document	
	static $_contentPluginContexts; //array for all nge content plugin instances
	static $_contentPluginLayouts; //array for all nge content plugin instances
	static $_contentPluginCanEditParts; //for nge content plugin instances, user has access to modify article or at least one part 
    
    /**
     * Parse content String to render part tags
     * @param type $content
     * @return type
     */
    public static function parse($content, $params = null){	
	require_once NGEPATH_HELPERS . '/ngepartshelper.php';
	
	$frontEditing = NGE::user()->authorise('frontediting.edit', 'com_nge');	
	
	$minifyOutput = NGE::params('output_minify', true);
	$userLevels = NGE::user()->getAuthorisedViewLevels();
	
	// Expression to search for(parts)
	$regexpart = '/<part.*?>.*?<\/part>/is';
	preg_match_all($regexpart, $content, $matches, PREG_SET_ORDER);

	//If at least one part exist, set isPartExist to true
	/*
	if(NGE::params()->isPartExist != true){
		if(count($matches) > 0){
			NGE::params()->isPartExist = true;
		}
	}
	 */
	$loop = 0;
	    while ($matches && $loop < 10) {
		$content = self::_replaceMatches($content, $matches, $params, $frontEditing, $minifyOutput, $userLevels);
		preg_match_all($regexpart, $content, $matches, PREG_SET_ORDER);
		$loop++;
	    }
	return $content;
    }

    /**
     * Render one part (with recursive content and condition display)
     * @param type $content
     * @return type
     */
    public static function renderPart($partId){
	//simpliest way is to simulate part tag
	return self::parse('<part data-part="' . $partId . '">&nbsp</part>');
    }
    
    
 public static function setCurrentArticle($article)	{
	 self::$_currentArticle = $article;
 }

 public static function currentArticle()	{
	 return self::$_currentArticle;
 }
	
	
    /**
     * Parse content String and duplicate inside parts
     * @param type $content
     * @return type
     */
     public static function duplicateParts($content){
    
	preg_match_all("/data-part=\"([^\"]*)\"/", stripslashes($content), $matches_part);

	    $new_part_id = array();
	    if (isset($matches_part) && !empty($matches_part)) {
		require_once NGEPATH_HELPERS . '/ngeparthelper.php';
    		foreach($matches_part[1] as $key => $children_part_id){
    			//$new_part_id[$key] = $model_part->duplicate($children_part_id, "", "", "");
			$new_part_id[$key] = NgePartHelper::duplicate($children_part_id, "", "", "");
    		}

		$content = str_replace($matches_part[1], $new_part_id, $content);
	    }	    
	    return $content;
     }
    
    
    /**
     * Replace part matches with part contents
     */
    private static function _replaceMatches($text, $matches, $params, $frontEditing, $minifyOutput, $userLevels) {

	//$partTobeModified = false; //Is there some part that can be modified ?
	$names = array();
	$nbMatches = count($matches);
	for ($i = 0; $i < $nbMatches; $i++) {
	    preg_match("/data-part=\"([^\"]*)\"/", $matches[$i][0], $matchespartlist);
	    if (array_key_exists(1, $matchespartlist)) {
		$matches[$i][1] = trim($matchespartlist[1]);
		$names[] = trim($matchespartlist[1]);
	    }
	}

	//Loading all parts general informations
	$partsInformation = NgePartsHelper::getParts($names); // Parts in cache

	if (empty($params) || is_null($params))
		$params = new stdClass();

	/* Minify. Warning, params can be string (com_tags) */
	if ((gettype($params) == 'object') && ($minifyOutput == false))
	    $params->minify = false;

	foreach ($matches as $match) {

	    // $match[0] is full pattern match, $match[1] is the part,$match[2] is the part name
	    $match[0] = str_replace("[", "\\[", $match [0]);
	    $match[0] = str_replace("]", "\\]", $match [0]);

	    //Loading corresponding part 
	    if (isset($partsInformation[$match[1]])) {
		$part = $partsInformation[$match[1]];

		// access level an publish information for rendering
		$partParams = new JRegistry;
		$partParams->loadString($part->params);
		$access = $partParams->get('access');
		if (!isset($access)) {
		    //If no value stored, set default value
		    include_once(NGEPATH_HELPERS . '/api/access.php');
		    $access = new PartAccess();
		}
				
		//View restrictions if any
		$displayParams = $partParams->get('display');
		$canViewPart = true;
		
		if ($canViewPart == true)
		    $canViewPart = (isset($access->display) && in_array($access->display, $userLevels));
		$canModifyPart = (isset($access->content) && in_array($access->content, $userLevels)) || (isset($access->options) && in_array($access->options, $userLevels));
		if ($canModifyPart) {
		    NgeContentHelper:: $_contentPluginCanEditParts = true;
		}
		//				self::$partTobeModified = true; //There is at least one part to be modified
		//Layouts used
		if ($part->name == 'layouts.page')
		    NgeContenthelper::addContentPluginLayout('layout.page');
		else
		if ($part->name == 'layouts.grid')
		    NgeContenthelper::addContentPluginLayout('layout.grid');
		else
		if ($part->name == 'layouts.wall')
		    NgeContenthelper::addContentPluginLayout('layout.wall');

		if ($canViewPart && $part->published) {
		    //Rendering mode

		    if (isset($params) && isset($params->medium))
				$medium = $params->medium;
		    else
				$medium = '';

		    $part->rendering = new StdClass();
		    
		    /* Setting rendering mode, except if $params is not an object : params can be string (com_tags) */
		    if (gettype($params) == 'object'){
			if ($medium == 'document.page')
			    $params->rendering_mode = "edit";//Part can be edited
			else{	
				if ($frontEditing && $canModifyPart)
					$params->rendering_mode = "edit";//Part can be edited
				else
					$params->rendering_mode = "view";//Part can be edited
			}
		    }
		    // loading main nge language file (for inline editing)
		    if ($params->rendering_mode == "edit"){
			$lang = JFactory::getLanguage();				
			$lang->load('com_nge');
		    }

		    //loading part content
			//If cache render exists, use it
			//if (($params->rendering_mode == "view") && ($part->render != '')){
			//    $partContent = $part->render;
			//}
			//else {
		    
		    
		/*if (isset($displayParams->filters) && count($displayParams->filters) >0){
			require_once NGEPATH_HELPERS . '/ngedisplayhelper.php';
			$canViewPart = NgeDisplaytHelper::canViewPart($displayParams, $params->rendering_mode);
		    $canViewPart = false;
		}*/
		    //Test conditional display, in view mode and edit mode (front) if there are some rules (rules != always)
		    $displayParams = $partParams->get('display');
		    //If caller is inline, we display all parts, even with conditional display, content can be an article text
		    //If not, we check conditional display
		    if (!(isset($params->caller) && ($params->caller == 'inline')))
			if (isset($displayParams->rules) && ($displayParams->rules != 'always') && in_array($params->rendering_mode, array("view", "edit"))){
			    require_once NGEPATH_HELPERS . '/ngedisplayhelper.php';
			    $canViewPart = NgeDisplaytHelper::canViewPart($displayParams, $params->rendering_mode);
			}
		    if ($canViewPart){
			//Change settings before rendering part
			NGE::triggerEvent('onRenderPart', array( &$part, &$params));
			require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
			$partContent = NgePartRendererDefault::render($part, $params);
			//change part content while displaying, or adding content before and after
			NGE::triggerEvent('onDisplayPart', array(&$partContent, $part, $params));
			// We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
			$text = preg_replace("|$match[0]|", addcslashes($partContent, '\\$'), $text, 1);
		    }
		    else
			$text = preg_replace("|$match[0]|", '', $text, 1);

		} else //No sufficient access to display. Part tag is deleted
		    $text = preg_replace("|$match[0]|", '', $text, 1);
	    } else //No part found for this tag : Part not found : does not exists, or not published or wrong language
		$text = preg_replace("|$match[0]|", '', $text, 1);
	}		    			
	return $text;
    }

     
    /**
     * Add script reference in the scripts library pool
     *
     *
     */
    public static function addScript($url) {
	if (!isset(self::$_scripts))
	    self::$_scripts = array();
	self::$_scripts[$url] = '';
    }

    public static function addContentPluginContext($context) {
	if (!isset(self::$_contentPluginContexts))
	    self::$_contentPluginContexts = array();
	self::$_contentPluginContexts[] = $context;
    }
    public static function addContentPluginLayout($layout) {
	if (!isset(self::$_contentPluginLayouts))
	    self::$_contentPluginLayouts = array();
	self::$_contentPluginLayouts[$layout] = 0; //0 = editing scripts not yet loaded
    }
    
    
    /**
     * Add style reference in the scripts library pool
     *
     *
     */
    public static function addStyleSheet($url) {
	if (!isset(self::$_styleSheets))
	    self::$_styleSheets = array();
	self::$_styleSheets[$url] = '';
    }

/**
     * Add style content in the style library pool
     *
     *
     */
    public static function addStyle($ref, $content) {
	if (!isset(self::$_styles))
	    self::$_styles = array();
	self::$_styles[$ref] = $content;
    }
    
    
        /**
     * Add style reference in the scripts library pool
     *
     *
     */
    public static function addFont($name) {
	if (!isset(self::$_fonts))
	    self::$_fonts = array();
	self::$_fonts[$name] = '';
    }

    
    /**
     * Render scripts from the script pool
     *
     *
     */
    public static function renderScripts() {
	$scripts = array();
	if (isset(self::$_scripts)) {
	    foreach (self::$_scripts as $url => $nothing)
		$scripts[] = '<script class="ngenosave" src="' . $url . '" type="text/javascript"></script>';
	    //ngenosave class, in an editable content, these tags will not be saved.
	    //Used when adding new parts by drag & drop, scripts tags are embeded in the displayed content inside the current edited content
	    self::$_scripts = array(); //Scripts have been rendered in the current document. Clearing current Pool
	}
	return implode($scripts);
    }

    /**
     * Render scripts from the script pool
     *
     *
     */
    /*public static function renderParallelScripts() {
	$scripts = array();
	if (isset(self::$_scripts)) {	
	    $scripts[] = 'ngetools.loadScripts([';
	    foreach (self::$_scripts as $url => $nothing)
		$scripts[] = '{path : "' . $url . '"},';
		//ngenosave class, in an editable content, these tags will not be saved.
		//Used when adding new parts by drag & drop, scripts tags are embeded in the displayed content inside the current edited content
	    self::$_scripts = array(); //Scripts have been rendered in the current document. Clearing current Pool
	    $scripts[] = '], function(){});';
	}	
	
	return implode($scripts);
    }
    */
    /**
     * Render scripts from the style pool
     *
     *
     */
    public static function renderStyleSheets() {
	$styles = array();
	if (isset(self::$_styleSheets)) {
	    foreach (self::$_styleSheets as $url => $nothing)
		$styles[] = '<link class="ngenosave" data-tags-nge="true" rel="stylesheet" href="' . $url . '" type="text/css" />';
	    //ngenosave class, in an editable content, these tags will not be saved.
	    //Used when adding new parts by drag & drop, link tags are embeded in the displayed content inside the current edited content
	    self::$_styleSheets = array(); //Styles have been rendered in the current document. Clearing current Pool			    
	}
	if (isset(self::$_styles)) {
	    $styles[] = '<style>';
	    foreach (self::$_styles as $ref => $content)
		$styles[] = $content;
	    $styles[] = '</style>';
	    //ngenosave class, in an editable content, these tags will not be saved.
	    //Used when adding new parts by drag & drop, link tags are embeded in the displayed content inside the current edited content
	    self::$_styleSheets = array(); //Styles have been rendered in the current document. Clearing current Pool			    
	}
	
	return implode($styles);
    }

        /**
     * Render scripts from the style pool
     *
     *
     */
    public static function renderFonts() {
	$fonts = array();
	if (isset(self::$_fonts)) {
	    foreach (self::$_styleSheets as $url => $nothing)
		$styles[] = '<link class="ngenosave" data-tags-nge="true" rel="stylesheet" href="' . $url . '" type="text/css" />';
	    self::$_styleSheets = array(); //Styles have been rendered in the current document. Clearing current Pool			    
	}
	return implode($fonts);
    }

    
    /**
     * Load library parts.
     *
     * @return  array
     *
     */
    protected static function &loadLibraryparts() {
	static $cleanLibraryparts;

	if (isset($cleanLibraryparts)) {
	    return $cleanLibraryparts;
	}

	$app = JFactory::getApplication();
	$Itemid = $app->input->getInt('Itemid');
	$user = JFactory::getUser();
	$groups = implode(',', $user->getAuthorisedViewLevels());
	//$lang = JFactory::getLanguage()->getTag();
	$clientId = (int) $app->getClientId();

	$query= 'SELECT l.part, l.title as library_title FROM #__nge_parts_library AS l LEFT JOIN #__nge_categories AS cat ON cat.id = l.catid WHERE l.state = 1';

	$cleanLibraryparts = array();

	try {
	    $parts = NGEDATA::loadObjectList($query);
	} catch (RuntimeException $e) {
	    JLog::add(JText::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');
	    return $cleanLibraryparts;
	}

	// Apply negative selections and eliminate duplicates
	$negId = $Itemid ? -(int) $Itemid : false;
	$dupes = array();
	for ($i = 0, $n = count($parts); $i < $n; $i++) {
	    $part = &$parts[$i];


	    if (isset($dupes[$part->name])) {
		// If this item has been excluded, keep the duplicate flag set,
		// but remove any item from the cleaned array.
		if ($negHit) {
		    unset($cleanLibraryparts[$part->name]);
		}
		continue;
	    }

	    $dupes[$part->name] = true;

	    // Only accept parts without explicit exclusions.
	    $part->style = null;
	    //$module->position = strtolower($part->position);
	    $cleanLibraryparts[$part->name] = $part;
	}

	unset($dupes);

	// Return to simple indexing that matches the query order.
	$cleanLibraryparts = array_values($cleanLibraryparts);

	return $cleanLibraryparts;
    }

}
