<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php';
/**
 * Module helper class
 *
 * @package     Joomla.Libraries
 * @subpackage  Module
 * @since       1.5
 */
abstract class NgeConfigHelper {

    static $_scripts; //Scripts pool for all parts to be rendered in the current Joomla document
    static $_styleSheets; //Scripts pool for all parts to be rendered in the current Joomla document
    static $_contentPluginContexts; //array for all nge content plugin instances
    static $_contentPluginLayouts; //array for all nge content plugin instances
    static $_contentPluginCanEditParts; //for nge content plugin instances, user has access to modify article or at least one part 
    
    
    
    
	/**
	 * Method to get a form object.
	 *
	 * @param   string   $formname     The name of the form.
	 * @param   object   $part      The part object.
	 * @param   array    $options  Optional array of options for the form creation.
	 *
	 * @return  mixed  JForm object on success, False on error.
	 *
	 */
	static function loadForm($formname, $part, $options = array())
	{	
		//Part name contains directory + name		
		if (isset($part->name))
			$partpath = explode('.', $part->name);
		else
			$partpath = array();
		
		$directories = '';

		for ($i=0; $i<count($partpath)-1; $i++)
			$directories .= $partpath[$i].'/';
		
			//$path = JPATH_COMPONENT_SITE . '/parts/'.$directories;
			// Get the form.
		if (isset($part->name)){	
			JForm::addFormPath(JPATH_SITE . '/components/com_nge/parts/'.strtr($part->name, '.', '/'));
			JForm::addFormPath(JPATH_SITE . '/components/com_nge/models/forms/'.$directories);
			JForm::addFieldPath(JPATH_SITE . '/components/com_nge/models/fields/'.$directories);			
		}
		JForm::addFormPath(JPATH_SITE . '/components/com_nge/models/forms/');
		try
		{ 
			if (isset($part->name))
				$form = JForm::getInstance($part->name.'.'.$formname, $formname, $options);
			else
				$form = JForm::getInstance($formname, $formname, $options);

				if (isset($part->params)){
					// If content params defined, merging with classic params
					if ((isset($part->content)) && ($part->content != '')){ //null when creation, (from nge_parts_library table	
						//Notice Json decoded as array
						$contentArray = json_decode($part->content, true);
						$paramsArray = json_decode($part->params, true);
                                                if(substr($part->name, 0, strlen("charts.")) === "charts."){
                                                    $paramsArrayTmp = array();
                                                    foreach($paramsArray as $key => $value){
                                                        $key_with_dot = strtr ($key, "_", ".");
                                                        $paramsArrayTmp[$key_with_dot] = $value;
                                                    }
                                                    $paramsArray = $paramsArrayTmp;
                                                }
						$mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
						$part->params = json_encode($mergedParams);
						$part->content = '';
					}
				    
					$jregistryparams = new JRegistry;
					$jregistryparams->loadString($part->params);														
					if (isset($part->title))
						$jregistryparams->set('title', $part->title);

					
					// Load the data into the form after the plugins have operated.
					$form->bind($jregistryparams);
				}
			}
			catch (Exception $e)
			{
			//			$this->setError($e->getMessage());
				return false;
			}
	
			// Store the form for later.
//			$this->_forms[$hash] = $form;
	
			return $form;
	}
	
	/**
	 * Method to get a form object in Ajax with new value
	 *
	 * @param   string   $nameForm	The name of the form
	 * @param   string   $nameField	The name of the field in the form
	 * @param   string   $newValue	New default value of the field
	 * @param   array    $options	Optional array of options for the form creation.
	 *
	 * @return  mixed  JForm object on success, False on error.
	 *
	 */
	static function loadFormAjax($nameForm, $pathForm, $nameField, $newValue, $options = array()){
		$partpath = explode('.', $pathForm);

		$directories = '';
	
		for ($i=0; $i<count($partpath)-1; $i++)
			$directories .= $partpath[$i].'/';

		// Get the form.
		if (isset($pathForm)){
			JForm::addFormPath(JPATH_SITE . '/components/com_nge/parts/'.strtr($pathForm, '.', '/'));
			JForm::addFormPath(JPATH_SITE . '/components/com_nge/models/forms/'.$directories);
			JForm::addFieldPath(JPATH_SITE . '/components/com_nge/models/fields/'.$directories);
			JForm::addFormPath(JPATH_SITE . '/components/com_nge/models/forms/');
		}
		
		try{
			if (isset($pathForm))
				$form = JForm::getInstance($pathForm.'.'.$nameForm, $nameForm, $options);
			else
				$form = JForm::getInstance($nameForm, $nameForm, $options);

			$newData = (object) array(
			    (string)$nameField => $newValue
			);
			
			$form->bind($newData);
		}catch (Exception $e){
			return false;
		}
	
		return $form;
	}
	
	
    
    
    /**
     * Method to get the editing form.
     *
     * @param	array	$data		An optional array of data for the form to interogate.
     * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
     * @return	JForm	A JForm object on success, false on failure
     * @since	1.6
     */
    public static function getForm($data = array(), $loadData = true, $subpart = '') {
	//Some differents modes :
	// - creating a new part : a partlibrary id, and then wizard.php if exists or config.php
	// - editing existing part : a part id
	// - duplicating an existing part : the old part id
	if (isset($data['mode']) && ($data['mode'] == 'create'))
	    return static::getCreationForm($data, $loadData, $subpart);
	else
	    return static::getEditionForm($data, $loadData, $subpart);
    }

    /**
     * Method to get the edit form for new parts.
     *
     * @param	array	$data		An optional array of data for the form to interogate.
     * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
     * @return	JForm	A JForm object on success, false on failure
     * @since	1.6
     */
    private static function getCreationForm($data = array(), $loadData = true, $subpart = '') {
	// Initialise variables.
	//$app = JFactory::getApplication();
	//$db = JFactory::getDBO();
	
	// Get the part path from database
	//$query = $db->getQuery(true);
// 		$query->select('pl.part, pl.default_params as params');
// 		$query->from('#__nge_parts_library AS pl');
// 		$query->where('pl.part = "'.$data['plname'].'"');
//		$db->setQuery($query);
//		$part = $db->loadObject();

	//Available vars for all config forms 
	//$formData : default data in the config
	//$part : part values
	//options : display options for the form
	
	$part = new stdClass();
	$part->name = $data['plname'];
	$options = $data['options'];

	//Setting key property. It will be used in the part forms to load ajax subforms. In Edition mode  $data['key'] = $data['pk'];
	$data['key'] = $data['plname'];
	
	//Initial selected text in the current editor before calling the widget form
	//We set the selected text as defaut value for any new widget
	if (isset($data['selection'])  && $data['selection'] != '') { //Default selected text when called from an editor
	    $formData = array();
	    
	    switch($part->name){
		case 'text.title':
		    $formData['label'] = array();
		    $formData['label']['html'] = strip_tags($data['selection']);
		    break;
		case 'text.label':
		    $formData['content'] = array();
		    $formData['content']['html'] = strip_tags($data['selection']);
		    break;
		case 'text.dropcap':
		    $selection = strip_tags($data['selection']);
		    $formData['label'] = array();
		    $formData['label']['html'] = substr($selection,0,1);
		    $formData['previewtext'] = substr($selection,1);
		    break;
		case 'text.label':
		case 'text.columns':
		case 'text.transform':
		case 'text.expandable':
		case 'panels.panel':
		    $formData['content'] = array();
		    $formData['content']['html'] = $data['selection'];
		    break;
		case 'navigation.buttonbar':
		case 'navigation.list':
		case 'navigation.dropdown':
		    //Multiple widgets
		    $formData['content']['items'] = array();	    
		    $formData['content']['count'] = 0;
		    //splitting <p> tags into multiple widget contents
		    $ptags = preg_split('#<p([^>])*>#', $data['selection']);
		    if (count($ptags) >0){
			//Reading tags, except first (empty)
			for ($i=1; $i<count($ptags);$i++){
			    $formData['content']['items'][$i-1] = array();
			    $formData['content']['items'][$i-1]['label'] = strip_tags($ptags[$i]);
			    $formData['content']['count']++;
			}
		    }
		    else{
			$formData['content']['items'][0] = array();
			$formData['content']['items'][0]['label'] = $data['selection'];
			$formData['content']['count'] = 1;
		    }		    
		    break;
		case 'panels.grid':
		case 'panels.tabs':
		case 'panels.accordion':
		case 'panels.slider':
		case 'panels.carousel':
		    //Multiple widgets
		    $formData['content']['items'] = array();	    
		    $formData['content']['count'] = 0;
		    //splitting <p> tags into multiple widget contents
		    $ptags = preg_split('#<p([^>])*>#', $data['selection']);
		    if (count($ptags) >0){
			//Reading tags, except first (empty)
			for ($i=1; $i<count($ptags);$i++){
			    if (trim(str_replace('&nbsp;', '', strip_tags($ptags[$i]))) != ""){
				$formData['content']['items'][$i-1] = array();
				$formData['content']['items'][$i-1]['html'] = strip_tags($ptags[$i]);
				$formData['content']['count']++;
			    }
			}
		    }
		    else{
			$formData['content']['items'][0] = array();
			$formData['content']['items'][0]['html'] = $data['selection'];
			$formData['content']['count'] = 1;
		    }		    
		    break;
		case 'images.grid' :
		case 'images.slider' :
		case 'images.carousel' :
		case 'images.gallery' :
		case 'images.ticker' :
		    //Finding img tags
		    preg_match_all('/<img.*?src="(.*?)".*?>/', $data['selection'], $matches);
		    if (count($matches[1]) >0){
			    $formData['content']['count'] = 0;
			    for ($i=0; $i<count($matches[1]);$i++){
				$formData['content']['items'][$i] = array();
				$formData['content']['items'][$i]['image'] = $matches[1][$i];
				$formData['content']['count']++;
			    }
		    }
		    break;
		case 'images.image' :
		    preg_match_all('/<img.*?src="(.*?)".*?>/', $data['selection'], $matches);
		    if (count($matches[1]) >0){
			//Single widgets : first image src
			$formData['image'] = $matches[1][0];
		    }		    
		    break;		    
	    }
	    	    	    
	    
	    //Multiple widgets
	    /*
	    $formData['content']['items'] = array();	    
	    $formData['content']['count'] = 0;
	    //splitting <p> tags into multiple widget contents
	    $ptags = preg_split('#<p([^>])*>#', $data['selection']);
	    echo 'uuuuuuuuuuuuuuuuuuuuuuuuuuuu';
	    echo count($ptags);
	    if (count($ptags) >0){
		//Reading tags, except first (empty)
		for ($i=1; $i<count($ptags);$i++){
		    $formData['content']['items'][$i-1] = array();
		    if (in_array($part->name, array("navigation.buttonbar", "navigation.list", "navigation.dropdown")))
			$formData['content']['items'][$i-1]['label'] = strip_tags($ptags[$i]);
		    else
			$formData['content']['items'][$i-1]['html'] = $ptags[$i];
		    $formData['content']['count']++;
		}
	    }
	    else{
		$formData['content']['items'][0] = array();
		$formData['content']['items'][0]['html'] = $data['selection'];
		$formData['content']['count'] = 1;
	    }
	    */	    	    
	    //Image widgets
	    /*
	    preg_match_all('/<img.*?src="(.*?)".*?>/', $data['selection'], $matches);
	    if (count($matches[1]) >0){
		//Single widgets : first image src
		$formData['image'] = $matches[1][0];
		//Multiple widgets images. Only if images widgets, if not : content count will override paragraphs content input
		if (in_array($part->name, array("images.grid", "images.slider", "images.carousel", "images.gallery", "images.ticker"))){
	    	    $formData['content']['count'] = 0;
		    for ($i=0; $i<count($matches[1]);$i++){
			$formData['content']['items'][$i] = array();
			$formData['content']['items'][$i]['image'] = $matches[1][$i];
			$formData['content']['count']++;
		    }		    
		}
	    }
	    */
	    NGEFields::setData($formData);
	    
	}
	
	//Rendering layout
	$caller = $data['caller'];
	if (isset($caller) && substr($caller,0,6) == 'layout'){
	    $callerArray = explode('.', $caller);
	    if (isset($callerArray[1])){
		$part->rendering = new StdClass();
		$part->rendering->layout = $callerArray[1];
	    }
	}
	
	$partname = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);

	//Part name contains directory + name
	$partpath = explode('.', $partname);
	$directories = '';
	$name = "";
	for ($i = 0; $i < count($partpath); $i++)
	    $directories .= $partpath[$i] . '/';

	$path = JPATH_SITE . '/components/com_nge/parts/' . $directories;
	//$pathCache = JPATH_SITE . '/components/com_nge/parts/cache/';

	$config_form = new stdClass();
	$config_form->isWizard = false;
	$config_form->formcontent = '';

	switch ($subpart) {
	    case '' : //Default view, all config form
		//If a wizards exists, take it in priority, if not : classic config file
// 					if (file_exists($path.'wizard.php'))
// 						include $path.'wizard.php';
//TODO remplacer le style par un fichier css propre au config.php
/*		echo "
		<style>
		#content .tab-content{
			min-height:450px;
		}
		</style>
		";*/
		//If "create" file exists, using it, for wizards for example.
		//Otherwise, current config file
			//Cache for create
			/*
 		if (file_exists($pathCache . $partname.'.create.php')){
 			ob_start();
 			include $pathCache . $partname.'.create.php';
			//$content.= '<script>var formValues="xxxx";</Script>';
 			$content = ob_get_contents();
 			ob_end_clean();
 		}	
 		else //No cache for create*/
		//Specifig form or subform,for example config_options
			
		if(isset($data['form']) && $data['form'] != '') {
		    //requested form in part directory if exists
		    //If not, load in default parts directory
		    $filename = '';
		    if(file_exists($path . $data['form'].'.php')){
			$filename = $path . $data['form'].'.php';
		    }
		    else
		    if(file_exists($path = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $data['form'].'.php'))
			    $filename = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $data['form'].'.php';
		    if ($filename != ''){
			ob_start();
			include JPath::check($filename);
			$config_form->formcontent = ob_get_contents();
			ob_end_clean();
		    }
		}
		else {		
		    if (file_exists($path . 'create.php')){
			$config_form->isWizard = true;
			    ob_start();
			    include JPath::check($path . 'create.php');
			    $config_form->formcontent = ob_get_contents();
			    ob_end_clean();
		    }	
		    else
		    if (file_exists($path . 'config.php')){
			    ob_start();
			    include JPath::check($path . 'config.php');
			    if (isset($mainConfigTabs))
				    $config_form->mainConfigTabs = $mainConfigTabs; 
			    $config_form->formcontent = ob_get_contents();
			    ob_end_clean();
		    }	
		}
		break;
	    case 'display' : //Only sub part display of the main config form
		if (file_exists($path . 'display.php')) //override display file
		    include JPath::check($path . 'display.php');
		else //Default display	
		    require_once(JPATH_SITE . 'components/com_nge/parts/nge/config/config_display.php');
		break;
	}

	return $config_form;
    }

    /**
     * Method to get the edit form for existing parts.
     *
     * @param	array	$data		An optional array of data for the form to interogate.
     * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
     * @return	JForm	A JForm object on success, false on failure
     */
    private static function getEditionForm($data = array(), $loadData = true, $subpart = '') {
	
	//Available vars for all config forms 
	//$part : part values
	//options : display options for the form	
	
	// Initialise variables.
	$name = '[' . $data['pk'] . ']';
	$part = NgePartsHelper::getPart($name);

	//Display options for the main tabs in the configuration screen
	$options = $data['options'];
	
	//Setting key property. It will be used in the part forms to load ajax subforms. In Creation mode  $data['key'] = $data['plname'];
	$data['key'] = $data['pk'];

	//Params
	if (isset($part->params)){
		// If content params defined, merging with classic params
		if ((isset($part->content)) && ($part->content != '')){ //null when creation, (from nge_parts_library table					
		    $contentArray = json_decode($part->content, true);
		    //Old format V1.0
		    if (isset($contentArray['sources']) || isset($contentArray['link_types'])){
			require_once NGEPATH_HELPERS . '/config/paramsupgrade.php';
			$contentArray = NgeParamsUpgrade::upgrade10($part->name, $contentArray);
		    }
		    
		    $paramsArray = json_decode($part->params, true);
                                 if(substr($part->name, 0, strlen("charts.")) === "charts."){
			$paramsArrayTmp = array();
                                           foreach($paramsArray as $key => $value){
			        $key_with_dot = strtr ($key, "_", ".");
                                                        $paramsArrayTmp[$key_with_dot] = $value;
                                           }
                                           $paramsArray = $paramsArrayTmp;
                                 }
		//$mergeParams contains params from content field and params field
		    $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
		    //Adding title field
		    if (isset($part->title))
			$mergedParams['title'] = $part->title;
		    //Adding assets field
		    if (isset($part->asset_id))
			$mergedParams['asset_id'] = $part->asset_id;
		    
		    $formData = $mergedParams;

		    //Old format V1.0
		    /*if (isset($formData['sources']) || isset($formData['link_types'])){
			require_once NGEPATH_HELPERS . '/config/paramsupgrade.php';
			$formData = NgeParamsUpgrade::upgrade10($part->name, $formData);
		    }*/
		    
		    NGEFields::setData($formData);
		}
	}
	
	//Rendering layout
	$caller = isset($data['caller']) ? $data['caller'] : '';
	if (isset($caller) && substr($caller,0,6) == 'layout'){
	    $callerArray = explode('.', $caller);
	    if (isset($callerArray[1])){
		$part->rendering = new StdClass();
		$part->rendering->layout = $callerArray[1];
	    }
	}		
	$partname = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
	//Part name contains directory + name
	$partpath = explode('.', $partname);
	$directories = '';
	$name = "";
	for ($i = 0; $i < count($partpath); $i++)
	    $directories .= $partpath[$i] . '/';

	$path = JPATH_SITE . '/components/com_nge/parts/' . $directories;
	$config_form = new stdClass();

	ob_start();
	switch ($subpart) {
	    case '' : //Default view, all config form
		//TODO remplacer le style par un fichier css propre au config.php
		echo "
						<style>
						#content .tab-content{
							min-height:450px;
						}
						</style>
						";
		//Include config form : given by "form" param, or default.
		//Form is optionnal. If not found, not displayed
		//Forms are named here, for security reasons
		if (isset($data['form']) && $data['form'] != '') {
		    //if (in_array($data['form'], array('addcontent', 'toolbar', 'subconfig', 'fieldset'))){

			    //requested form in part directory if exists
			    //If not, load in default parts directory
			    $filename = '';
			    if(file_exists($path . $data['form'].'.php')){
				$filename = $path . $data['form'].'.php';
			    }
			    else
			    if(file_exists($path = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $data['form'].'.php'))
				    $filename = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $data['form'].'.php';
			    else
			    if(file_exists(NGEPATH_HELPERS . '/forms/parts/' . $data['form'].'.php'))
				    $filename = NGEPATH_HELPERS . '/forms/parts/' . $data['form'].'.php';
			    if ($filename != ''){
				include JPath::check($filename);
			    }
			else 
			    switch($data['form']){
				case 'toolbar' :
				    //If no toolbar.php and if metaform.xml exists, using it as default toolbar definition
				    if(file_exists($path . 'metaform.xml')) {
					require_once ('components/com_nge/helpers/metaform/metaformparttoolbar.php');
					$metaformPartToolbar = new MetaformPartToolbar($path.'/metaform.xml');
					echo $metaformPartToolbar->render($part);	
				    }
				    break;
				case 'subconfig' :
				    //If no toolbar.php and if metaform.xml exists, using it as default subconfig definition
				    if(file_exists($path . 'metaform.xml')) {
					$subform =	$data['subform'];
					$liPosition =	$data['liposition'];
					require_once ('components/com_nge/helpers/metaform/metaformpartsubconfig.php');
					$metaformPartSubconfig = new MetaformPartSubconfig($path.'/metaform.xml');
					echo $metaformPartSubconfig->renderSubconfig($part, $subform, $liPosition);	
				    }
				    break;    
			    }
		    //}
		}
		else{/*
	 		if (file_exists($pathCache . $partname.'.create.php')){
                                $script = <<<EOF
                                        <script>
                                            var formContentValues = {$part->content};
                                            var formParamValues   = {$part->params} ;
                                        
                                        
                                            function loadNGEFormsFromJson(currentForm, formValues, parent, depth) {
                                                var valueName;

                                                for (valueName in formValues) {
                                                    if( Object.prototype.toString.call( formValues[valueName] ) === '[object Object]' ){
                                                        parent[depth] = valueName;
                                                        loadNGEFormsFromJson(currentForm, formValues[valueName], parent, depth+1);
                                                    }
                                                    else {
                                                        var shortValueName = valueName;
                                                        if(parent.length > 0){
                                                            var tmpValueName = "";
                                                            for(var i=0; i<depth; i++){
                                                                tmpValueName += parent[i] + "[";
                                                            }   
                                                            tmpValueName += valueName;
                                                            for(var i=0; i<depth; i++){
                                                                tmpValueName += "]";
                                                            }   
                                                            valueName = tmpValueName;
                                                        }
                                                        if (valueName in currentForm.elements) {
                                                            var current_type = currentForm.elements[valueName].type;
                                                            if(current_type == "select-one") {
                                                                //currentForm.elements[valueName].select = formValues[shortValueName];
                                                            }else if(current_type == "select-multiple") {
                                                            }else if(current_type == "radio") {
                                                            }else if(current_type == "checkbox") {
                                                            }else{
                                                                currentForm.elements[valueName].value = formValues[shortValueName];
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            jQuery(function () {
                                                var contentForm = document.getElementById("contentform");
                                                var optionsForm = document.getElementById("optionsform");
                                                var displayForm = document.getElementById("displayform");
                                                loadNGEFormsFromJson(contentForm, formContentValues, [], 0);
                                                loadNGEFormsFromJson(optionsForm, formParamValues, [], 0);
                                                loadNGEFormsFromJson(displayForm, formParamValues, [], 0);
                                            });
                                        </script>
EOF;
                                
				echo $script;
				include $pathCache . $partname.'.create.php';
			}	
			else //No cache for create*/
			if (file_exists($path . 'config.php')){
				include JPath::check($path . 'config.php');
				if (isset($mainConfigTabs))
					$config_form->mainConfigTabs = $mainConfigTabs; 
			}	
			else
			if(file_exists($path . 'metaform.xml')) {
				//If no config.php and if metaform.xml, using it for building default config form
				require_once ('components/com_nge/helpers/metaform/metaformpartconfig.php');
				$metaformPartConfig = new MetaformPartConfig($path.'/metaform.xml');
				echo $metaformPartConfig->render($part);	
				}
		}
		$content = ob_get_contents();
		break;
	    case 'display' : //Only sub part display of the main config form
		if (file_exists($path . 'display.php')) //override display file
		    include JPath::check($path . 'display.php');
		else //Default display
		    require_once(JPATH_SITE . '/components/com_nge/parts/nge/config/config_display.php');
		$content = ob_get_contents();
		break;
	}
	ob_end_clean();

	
	
    $config_form->isWizard = false;
    $config_form->formcontent = $content;

	return $config_form;
    }
	
	
	
	
	
}
