<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

define('NGEPATH_NGE', JPATH_SITE . '/components/com_nge');
define('NGEPATH_HELPERS', JPATH_SITE . '/components/com_nge/helpers');
define('NGEPATH_CLASSES', JPATH_SITE . '/components/com_nge/classes');
define('NGEPATH_PARTS', JPATH_SITE . '/components/com_nge/parts');
define('NGEPATH_ITEMS', JPATH_SITE . '/components/com_nge/items');
define('NGEPATH_CONTENTS', JPATH_SITE . '/components/com_nge/contents');
define('NGEPATH_LAYOUTS', JPATH_SITE . '/layouts/nge');
define('NGEPATH_MEDIA', JPATH_SITE . '/media/com_nge');
define('NGEPATH_LIBRARIES', JPATH_SITE . '/media/com_nge');
define('NGEPATH_ASSETS', JPATH_SITE . '/components/com_nge/assets');

define ('NGEURL_ROOT', JUri::root()); //Absolute root url
define ('NGEURL_BASE', JUri::base()); //Relative root url, for front or backoffice
define ('NGEURL_TASKS', NGEURL_ROOT . 'index.php?option=com_nge');
define ('NGEURL_VIEWS', NGEURL_ROOT . 'index.php?option=com_nge');
define ('NGEURL_ASSETS', NGEURL_ROOT . 'components/com_nge/assets/');
define ('NGEURL_MEDIA', NGEURL_ROOT . 'media/com_nge/');
define('NGEURL_HELPERS', NGEURL_ROOT . 'components/com_nge/helpers/');

define('NGECOLORS_NGE_HEADER', "#555D83");
define('NGECOLORS_NGE_BAR', "#646D9C");
define('NGECOLORS_NGE_ACTIVE', "#8B92B3");

define('NGECOLORS_MEDIA_HEADER', "#C2185B");
define('NGECOLORS_MEDIA_BAR', "#E91E63");

define('NGECOLORS_MODULE_HEADER', "#F77");
define('NGECOLORS_MODULE_BAR', "#FF9191");

require_once NGEPATH_CLASSES . '/ngecontent.php';


//todo NGEPATH_MEDIA to change towards NGEPATH_LIBRARIES


/**
 * class Nge
 * @author Alexandre Froger
 *
 */
class NGE {

    private static $_user = null;
    private static $_params = null;
    private static $_document = null;
    private static $_version = null;
    private static $_joomlaVersion = null;    
    private static $_versionAlpha = null;
    private static $_versionBeta = null;
    private static $_cache = null;
	
    private static $_urls = null;    

    private static $_dispatcher = null;
    
    private static $_time_elapsed_last = null;
    private static $_time_elapsed_start = null;
    

	/**
	 * 
	 * @param string $name
	 * @return \className
	 * Used to display part in API mode
	 * $partTable = NGE::part('tables.table');
	//$partTable->loadPart($part);
	$partTable->content->source = "data";
	$partTable->content->data = $articles;
	$partTable->navigation->paging->display = "0";
	$partTable->navigation->searching = "1";
	$partTable->navigation->ordering = "1";
	$partTable->navigation->resizing = "1";
	$partTable->navigation->info = "1";
	$result .= $partTable->render();
	 */
	public static function part($name) {
		
		$partpath = explode('.', $name);
		$directories = '';
		$className = 'NgePart';
		$name = "";
		for ($i=0; $i<count($partpath); $i++) {
			$directories .= $partpath[$i].'/';
			$className .= ucfirst($partpath[$i]);
		}

		$filename = JPath::check(NGEPATH_HELPERS . '/api/part/'.$directories.$partpath[count($partpath)-1].'.php');
		
		try{
			require_once($filename);
			return new $className();
		}
		catch (Exception $e){
			NGE::message('Class '.$className. ' not found in '. filename , 'error');
		}
			
	}

	public static function item($name) {

		$partpath = explode('.', $name);
		$directories = '';
		$className = 'NgeItem';
		$name = "";
		for ($i=0; $i<count($partpath); $i++) {
			$directories .= $partpath[$i].'/';
			$className .= ucfirst($partpath[$i]);
		}

		$filename = JPath::check(NGEPATH_HELPERS . '/api/item/'.$directories.$partpath[count($partpath)-1].'.php');

		try{
			require_once($filename);
			return new $className();
		}
		catch (Exception $e){
			NGE::message('Class '.$className. ' not found in '. filename , 'error');
		}
			
	}

	/**
	 * 
	 * @param type $id
	 * @return type
	 * Direct rendering for an existing part id
	 */	
	public static function renderPart($id) {
		
		try{
		    require_once NGEPATH_HELPERS . '/ngeparts.php';
		    return NGEParts::render($id);
		}
		catch (Exception $e){
			NGE::message('Part '.$id. ' not found' , 'error');
		}			
	}
	
	/**
	 * 
	 * @param type $name
	 * @return type
	 * wether feature by name is allowed
	 */	
	public static function features($name) {
		
		try{
		    require_once NGEPATH_HELPERS . '/ngefeatures.php';
		    return NgeFeatures::enabled($name);
		}
		catch (Exception $e){
			NGE::message('Feature  '.$name. ' not found' , 'error');
		}			
	}
	
/**
	 * 
	 * @param type $name
	 * @return type
	 * wether feature by name is allowed
	 */	
	public static function package() {
		
		try{
		    require_once NGEPATH_HELPERS . '/ngefeatures.php';
		    return NgeFeatures::package();
		}
		catch (Exception $e){
			NGE::message('Package not found' , 'error');
		}			
	}
	
	
	/* Calling main editor class for displaying html, css and scripts to do front editing */
	public static function editor(){
	    require_once JPATH_SITE . '/plugins/content/nge_content/nge/editor.php';
	    return new NgeEditor();
	}
	
	
	public static function layout($name, $data) {
	    return JLayoutHelper::render($name, $data);
	}
	
	public static function translate($text){
	    return JText::_($text);
	}
	
/*	public static function url($name){
	    self::$_urls = array();
	    self::$_urls['root'] = '/'; //JUri::root();
	    return self::$_urls[$name];
	}*/
	public static function url($name){
	    self::$_urls = array();
	    self::$_urls['root'] = JUri::root();
	    return self::$_urls[$name];
	}
	
	
	public static function path($name){
	    self::$_paths = array();
	    self::$_parts['root'] = '';
	    return self::$_paths[$name];
	}
	
	
    public static function document() {
	if (self::$_document == null) {
	    self::$_document = JFactory::getDocument();
	}

	return self::$_document;
    }

    public static function user() {
	if (self::$_user == null) {
	    self::$_user = JFactory::getUser();
	    self::$_user->canManageModules = (self::$_user->authorise('core.create', 'com_modules') || self::$_user->authorise('core.edit', 'com_modules') || self::$_user->authorise('core.delete', 'com_modules'));
	    self::$_user->canManageMenus = (self::$_user->authorise('core.create', 'com_menus') || self::$_user->authorise('core.edit', 'com_menus') || self::$_user->authorise('core.delete', 'com_menus'));
	    self::$_user->canManageContent = (self::$_user->authorise('core.create', 'com_content') || self::$_user->authorise('core.edit', 'com_content') || self::$_user->authorise('core.delete', 'com_content'));
	}
	return self::$_user;
    }

    /*
    public static function params() {
		if (self::$_params == null) {
		    $_params = new Stdclass();
		    $_params->isPartExist = false;
		    $_params->frontEditing = JComponentHelper::getParams('com_nge')->get('front-editing', true);
		    $_params->minifyOutput = JComponentHelper::getParams('com_nge')->get('output_minify', true);
		    
		    self::$_params = $_params;
		}

		return self::$_params;
    }     
     */
    
    public static function params($name, $default){
	if (self::$_params == null)
		    self::$_params = array();
	//Caching params
	if (!isset(self::$_params[$name])) {
	    $paramsNextGenEditor= JComponentHelper::getParams('com_nge');
	    self::$_params[$name] = $paramsNextGenEditor->get($name, $default);	    
	}
	return self::$_params[$name];
    }
    
    

        public static function version() {

            if (self::$_version == null) {
                $db = JFactory::getDbo();
                $query = $db->getQuery(true)
                ->select('sc.version_id')
                ->from($db->quoteName('#__extensions', 'ex'))
                ->join('LEFT', $db->quoteName('#__schemas', 'sc') . ' ON (' . $db->quoteName('ex.extension_id') . ' = ' . $db->quoteName('sc.extension_id') . ')')
                ->where($db->quoteName('ex.name') . ' LIKE \'com_nge\'');
                $db->setQuery($query);
                $result = $db->loadResult();

                self::$_version = $result;
            }

            return self::$_version;
        }

/**
 *  Get Joomla shortversion
 * @return type
 */
    public static function joomlaVersion() {
	if (self::$_joomlaVersion == null) {
	    jimport( 'joomla.version' );
	    $jVersion = new JVersion() ; 
	    self::$_joomlaVersion = $versionJoomla = $jVersion->getShortVersion(); 
	}
	return self::$_joomlaVersion;
    }	
	

    public static function isVersionAlpha() {
    	if (self::$_versionAlpha == null) {
    	    $db = JFactory::getDbo();
    
    		// Set the query and get the result list.
    		//$db->setQuery('SELECT id, title, params FROM #__nge_parts_patterns WHERE part = "'.$this->getAttribute("part").'"');
    		$query = $db->getQuery(true)
    		//->select('l.part, l.default_params as params')
    		->select('name')
    		->from('#__nge_plugins')
    		->where('name = "alpha"')
    		->where('type = "core"');
    		$db->setQuery($query);
    		$data = $db->loadObject();
    		self::$_versionAlpha = isset($data);
    	    //self::$_versionBeta = false;
    	}
    
    	return self::$_versionAlpha;
    }


        public static function isVersionBeta() {
	if (self::$_versionBeta == null) {
	    $db = JFactory::getDbo();

		// Set the query and get the result list.
		//$db->setQuery('SELECT id, title, params FROM #__nge_parts_patterns WHERE part = "'.$this->getAttribute("part").'"');
		$query = $db->getQuery(true)
		//->select('l.part, l.default_params as params')
		->select('name')
		->from('#__nge_plugins')
		->where('name = "beta"')
		->where('type = "core"');
		$db->setQuery($query);
		$data = $db->loadObject();
		self::$_versionBeta = isset($data);
	    //self::$_versionBeta = false;
	}

	return self::$_versionBeta;
    }

    /*
     * get a session token for ajax security
     */
    public static function token() {
	if (version_compare(JVERSION, '4') < 0){
	    $session = JFactory::getSession();
	    return $session->getFormToken();
	}
	else
	    return \JSession::getFormToken();
    }
    
    /*
     * get a hidden input with session token for ajax security
     */
    public static function tokenInput() {
	$session = JFactory::getSession();
	$token = $session->getFormToken();
	return JHtml::_('form.token');
    }
    
    /*
     * trigger event
     */
    public static function triggerEvent($eventName, $args = []){
	if (version_compare(JVERSION, '4') < 0){
	    if (self::$_dispatcher == null)
		self::$_dispatcher = JEventDispatcher::getInstance();
	    //Change settings before rendering part
	    return self::$_dispatcher->trigger($eventName, $args);
	}
	else {
	    return \JFactory::getApplication()->triggerEvent($eventName,$args);
	}
    }
    

    static function stringURLSafe($url){
	if (version_compare(JVERSION, '4') < 0){
	    return JApplication::stringURLSafe($url);
	}
	else {
	    return JApplicationHelper::stringURLSafe($url);
	}
    }
    
    /*
     * Recursive Merge of arrays properties
     * 1rst argument : original array.
     * Other arguments, added arrays
     */

    static function array_merge_recursive_replace() {

	$arrays = func_get_args();
	$base = array_shift($arrays);
	if (isset($base)) {
	    foreach ($arrays as $array) {
		reset($base);
		while (list($key, $value) = @each($array)) {
		    if (is_array($value) && @is_array($base[$key])) {
			//If sequential array => reset, for example border placements are sequential array, if not all default values are keeped
			if (!(array_values($base[$key]) !== $base[$key])) //Sequential
			    $base[$key] = array();
			$base[$key] = self::array_merge_recursive_replace($base[$key], $value);
		    } else {
			$base[$key] = $value;
		    }
		}
	    }
	}
	return $base;
    }

    /*
     * recursive_array_search()
     * Used to find all key who contains specific value.
     * @params String $needle, String to find in the array
     * @params Array $haystack, Array where the values are
     * @params Array $keyArrayJson, return value if key exist 
     * @return $keyArrayJson array of key or false is no key exist
     */
    static function recursive_array_search($needle,$haystack,$keyArrayJson=array()) {
        $ret = false;

        if (is_array($haystack))
        foreach($haystack as $key=>$value) {
            $current_key = $key;

            if((is_array($value) && self::recursive_array_search($needle,$value) !== false) || (!is_array($value) && strpos($value, $needle) !== false)) {
                $keyArrayJson[] = $current_key;
                $ret = true;
            }
        }

        if($ret === false){
            return false;
        }else{
            return $keyArrayJson;   
        }
    }
    
    /*
     * recursive_array_load_preset()
     * If preset key exist load pattern with presetId and set preset to '' when return pattern properties
     * @params Array $array Array where the values are
     * @return Array $array_modified
     */
    static function array_load_preset($array) {
        require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
        $ret = false;

        if(isset($array['options'])){
            if(isset($array['options']['preset']) && $array['options']['preset'] !== ""){ // Specific for general options
                $pattern = NgePatternDriver::load($array['options']['preset']);
                //Main data : params of the part 
                if(isset($pattern->params)){
                    $paramsObject = json_decode($pattern->params, true);
                    $paramsArray = NGE::array_merge_recursive_replace($paramsObject, $array);

                    $array = $paramsArray;
                    $array['options']['preset'] = "";
                    $ret = true;
                }
            }

            //Remove current options temporary
            $tmp_options = $array['options'];
            $tmp_array = $array;
            unset($array['options']);
        }

        $array_preset = self::recursive_array_load_preset($array);
        
        if($array_preset !== false){
            if(isset($tmp_options)){
                $array_preset["options"] = $tmp_options;
            }
            $ret = true;
        }else{
            if(isset($tmp_array) && $ret === true){
                $array_preset = $tmp_array;
            }
        }
        
        if($ret === false){
            return false;
        }else{
            return $array_preset;
        }
    }
    
    static function recursive_array_load_preset($array) {
        require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
        $ret = false;
        
        foreach($array as $key => $value) {
            $current_key = $key;
            
            if($current_key === "preset" && $array[$current_key] !== ""){ 
                $pattern = NgePatternDriver::load($array[$current_key]);
                
                if(isset($pattern->params)){
                    //Main data : params of the part 
                    $paramsObject = json_decode($pattern->params, true);

                    $paramsArray = NGE::array_merge_recursive_replace($paramsObject, $array);
                    $array = $paramsArray;
                    $array[$current_key] = "";
                    $ret = true;
                }
            }else{
                if(is_array($value)){
                    $recursive_array = self::recursive_array_load_preset($value,$current_key);
                    if($recursive_array !== false){
                      $array[$current_key] = $recursive_array;
                      $ret = true;
                    }
                }
            }
        }

        if($ret === false){
            return false;
        }else{
            return $array;
        }
    }
	//From Joomla. Moved in 3.8    
	/**
	 * Method to extract key/value pairs out of a string with XML style attributes
	 *
	 * @param   string  $string  String containing XML style attributes
	 *
	 * @return  array  Key/Value pairs for the attributes
	 *
	 * @since   11.1
	 */
	public static function parseAttributes($string)
	{
		$attr = array();
		$retarray = array();

		// Let's grab all the key/value pairs using a regular expression
		preg_match_all('/([\w:-]+)[\s]?=[\s]?"([^"]*)"/i', $string, $attr);

		if (is_array($attr))
		{
			$numPairs = count($attr[1]);

			for ($i = 0; $i < $numPairs; $i++)
			{
				$retarray[$attr[1][$i]] = $attr[2][$i];
			}
		}

		return $retarray;
	}    
    
    /*
     * decode_json_string()
     * Used to decode all json string in the current object.
     * @params String $object
     * @return $object with decode json string
     */
    static function decode_json_string($object, $keyArrayJson) {    
        foreach($keyArrayJson as $key) {
            if (isset($object[$key])){
                if(is_array($object[$key])){
                    $keyArrayJsonRecursive = NGE::recursive_array_search('ngejson::',$object[$key]);
                }else{
                    $keyArrayJsonRecursive = false;
                }
                
                if($keyArrayJsonRecursive !== false){/*If value with json object string exist*/
                    $object[$key] = NGE::decode_json_string($object[$key], $keyArrayJsonRecursive);
                }else{
                    $value_without_json = str_replace("ngejson::", "", $object[$key]);
                    $object[$key] = json_decode($value_without_json);
                }
            }
        }
        
        return $object;
    }

 /**
 * Create script tag in the document for loading js resource in the media directory
 * @param type $path
 * @param type $async
 */
    public static function loadMediaScript($path, $async = false) {
	self::document()->addScript(Juri::root() . 'media/com_nge/'.$path, 'text/javascript', false, $async);
    }
    /**
 * Create script tag in the document for loading js resource in the helpers directory
 * @param type $path
 * @param type $async
 */
    public static function loadHelpersScript($path, $async = false) {
	self::document()->addScript(Juri::root() . 'components/com_nge/helpers/'.$path, 'text/javascript', false, $async);
    }
    public static function loadMediaCss($path, $async = true) {
	self::document()->addScript(Juri::root() . 'media/com_nge/'.$path, 'text/javascript', false, $async);
    }

    public static function loadHelpersCss($path, $async = true) {
	self::document()->addScript(Juri::root() . 'components/com_nge/helpers/'.$path, 'text/javascript', false, $async);
    }
    
    public static function getExternalFont($fontname, $fontweight = "normal", $isitalic = 0) {
        $browserFonts = array(
            "Georgia",
            "'Palatino Linotype', 'Book Antiqua', Palatino",
            "'Times New Roman', Times",
            "Arial, Helvetica",
            "'Arial Black', Gadget",
            "'Comic Sans MS', cursive",
            "Impact, Charcoal",
            "'Lucida Sans Unicode', 'Lucida Grande'",
            "Tahoma, Geneva",
            "'Trebuchet MS', Helvetica",
            "Verdana, Geneva",
            "'Courier New', Courier",
            "'Lucida Console', Monaco"
        );

        // Is an external font
        if (!in_array($fontname, $browserFonts)){
            require_once (NGEPATH_CLASSES . '/ngegooglefont.php');
            $google_font_object = NgeGoogleFont::getFont($fontname, $fontweight, $isitalic);
            if($google_font_object !== false){
                $font_name = $google_font_object->family.$google_font_object->variant;
                $font_url = $google_font_object->files->{$google_font_object->variant};

                return array(
                    "name" => $font_name,
                    "url" => $font_url
                );
            }else{
                return null;
            }
        }else{
            return null;
        }
    }
        
	public static function minify($content) {
  		/*$content = preg_replace('!/\*[^*]*\*+([^/][^*]*     \       *+)*                    /!', '', $content); //Comments 
                             $content = preg_replace("/\t/", " ", $content); //tabs
  		$content = strtr($content, ': ', ':'); //spaces in css
  		$content = str_replace(array("\r\n", "\r", "\n", "\t"), '', $content); //End of lines
  		$content = str_replace(array('  ', '    ', '    '), ' ', $content); //more than one space
		*/		
				/* require_once NGEPATH_MEDIA . '/jshrink/minifier.php';
				$content = \JShrink\Minifier::minify($content);*/
		return $content;		
	}	
	
	public static function message($msg, $type){
	JFactory::getApplication()->enqueueMessage($msg, $type);  //'message', 'notice', 'warning', 'error'  default ='message'
	}
	
	public static function loadCache($cacheId){
		if (self::$_cache == null){
			self::$_cache = JFactory::getCache('com_nge', '');
			self::$_cache->setCaching(true);
			self::$_cache->setLifeTime(8640000); //100 days
		}	
		return self::$_cache->get($cacheId);
	}
	
	public static function storeCache($content, $cacheId, $minify=true){
		if (self::$_cache == null){
			self::$_cache = JFactory::getCache('com_nge', '');
			self::$_cache->setCaching(true);
			self::$_cache->setLifeTime(8640000); //100 days
		}	
		
		return self::$_cache->store($minify ? self::minify($content) : $content, $cacheId);
	}
	
	public static function time_elapsed($comment) 
	    {

	    // $unit="s"; $scale=1000000; // output in seconds
	    // $unit="ms"; $scale=1000; // output in milliseconds
	    $unit="s"; $scale=1000000; // output in microseconds

	    $now = microtime(true);

	    if (self::$_time_elapsed_last != null) {
		echo "\n";
//		echo '<!-- ';
		echo "$comment: Time elapsed: ";
		echo round(($now - self::$_time_elapsed_last)*1000000)/$scale;
		echo " $unit, total time: ";
		echo round(($now - self::$_time_elapsed_start)*1000000)/$scale;
//		echo " $unit -->";
		echo "\n";
	    } else {
		self::$_time_elapsed_start=$now;
	    }

	    self::$_time_elapsed_last = $now;
	}         
	
        public static function mb_ucfirst($str, $encoding = "UTF-8", $lower_str_end = false) {
            $first_letter = mb_strtoupper(mb_substr($str, 0, 1, $encoding), $encoding);
            $str_end = "";
            if ($lower_str_end) {
                $str_end = mb_strtolower(mb_substr($str, 1, mb_strlen($str, $encoding), $encoding), $encoding);
            }
            else {
                $str_end = mb_substr($str, 1, mb_strlen($str, $encoding), $encoding);
            }
            $str = $first_letter . $str_end;
            return $str;
        }
    
    /**
    * NgeFields::colorcmyk()
    * 
    * @param mixed $name
    * @param mixed $label
    * @param mixed $help
    * @param string $defaultValue
    * @param array() $options
    * @return
    */
    private static function CMYKtoRGB($cyan, $magenta, $yellow, $key) {
        $result = array("r" => 0, "g" => 0, "b"=> 0);

        $c = $cyan / 100;
        $m = $magenta / 100;
        $y = $yellow / 100;
        $k = $key / 100;

        $result['r'] = 1 - min( 1, ($c * ( 1 - $k ) + $k) );
        $result['g'] = 1 - min( 1, ($m * ( 1 - $k ) + $k) );
        $result['b'] = 1 - min( 1, ($y * ( 1 - $k ) + $k) );

        $result['r'] = round( $result['r'] * 255 );
        $result['g'] = round( $result['g'] * 255 );
        $result['b'] = round( $result['b'] * 255 );

        return $result;
    }

    /**
    * Convert a hexa decimal color code to its RGB equivalent
    *
    * @param string $hexStr (hexadecimal color value)
    * @param boolean $returnAsString (if set true, returns the value separated by the separator character. Otherwise returns associative array)
    * @param string $seperator (to separate RGB values. Applicable only if second parameter is true.)
    * @return array or string (depending on second parameter. Returns False if invalid hex color value)
    */                                                                                                 
    private static function HEXtoRGB($hexStr, $returnAsString = false, $seperator = ',') {
        $hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
        $rgbArray = array();
        if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
            $colorVal = hexdec($hexStr);
            $rgbArray['r'] = 0xFF & ($colorVal >> 0x10);
            $rgbArray['g'] = 0xFF & ($colorVal >> 0x8);
            $rgbArray['b'] = 0xFF & $colorVal;
        } elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
            $rgbArray['r'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
            $rgbArray['g'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
            $rgbArray['b'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
        } else {
            return null; //Invalid hex color code
        }

        return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
    }

    /**
    * Convert a rgb color code to its HEX equivalent
    *
    * @param array RGB
    * @return string HEX
    */                                                                                                 
    private static function RGBtoHEX($array_rgb) {
        if(is_array($array_rgb) && isset($array_rgb['r']) && isset($array_rgb['g']) && isset($array_rgb['b'])){
            return sprintf("#%02x%02x%02x", $array_rgb['r'], $array_rgb['g'], $array_rgb['b']);
        }else{
            return null;
        }
    }
    
    private static function RGBtoCMYK ($array_rgb){
        if(is_array($array_rgb) && isset($array_rgb['r']) && isset($array_rgb['g']) && isset($array_rgb['b'])){
            $result = array("cyan" => 0, "magenta" => 0, "yellow"=> 0, "key"=> 0);
            
            $c = (255 - $array_rgb['r']) / 255.0 * 100;
            $m = (255 - $array_rgb['g']) / 255.0 * 100;
            $y = (255 - $array_rgb['b']) / 255.0 * 100;

            $k = min(array($c,$m,$y));
            $c = $c - $k; 
            $m = $m - $k; 
            $y = $y - $k;
            
            $result['key']      = $k;
            $result['cyan']     = $c;
            $result['magenta']  = $m;
            $result['yellow']   = $y;

            return $result;
        }else{
            return null;
        }
    }
            
    /**
     * NgeFields::parseColor()
     * 
     * @param Array or String or Object $color_value
     * @param Array Options for the output result
     * @return Array or String RGB,RGBA,HEX
     */
    public static function parseColor($color_value = "#000000", $options = array()) {
        $color = null;
        
        if($color_value === ""){
            /*Color transparent*/
            return '';
        }else{
            /*DEFAULT OPTIONS*/
            $color_input_type = (isset($options['input_type']) && is_string($options['input_type'])) ? $options['input_type'] : "hex"; /*DEFAULT INPUT HEX*/
            $color_output_type = (isset($options['output_type']) && is_string($options['output_type'])) ? $options['output_type'] : "rgb"; /*DEFAULT OUTPUT RGB*/
            $return_as_string = (isset($options['return_as_string']) && is_bool($options['return_as_string'])) ? $options['return_as_string'] : true; /*DEFAULT True its string else return array when we can*/
            $opacity = (isset($options['opacity']) && $options['opacity'] !== "") ? $options['opacity'] : 1; /*DEFAULT 1 only work with rgba output 0 to 1*/

            switch ($color_input_type) {
                case "cmyk": /*INPUT CMYK*/
                    switch ($color_output_type) {
                        case "hex": /*OUTPUT HEX*/
                            $color = self::RGBtoHEX(self::CMYKtoRGB($color_value->cyan, $color_value->magenta, $color_value->yellow, $color_value->key));
                            break;
                        default: /*DEFAULT OUTPUT RGB even for rgba because CMYK doesn't work with opacity*/
                            $rgb_array = self::CMYKtoRGB($color_value->cyan, $color_value->magenta, $color_value->yellow, $color_value->key);
                            $color = ($return_as_string) ? 'rgb('.$rgb_array['r'].','.$rgb_array['g'].','.$rgb_array['b'].')' : $rgb_array;
                            break;
                    }
                    break;
                default: /*DEFAULT INPUT HEX*/
                    switch ($color_output_type) {
                        case "cmyk": /*OUTPUT CMYK*/
                            $color = self::RGBtoCMYK(self::HEXtoRGB($color_value));
                            break;
                        case "hex": /*OUTPUT HEX*/
                            $color = $color_value;
                            break;
                        case "rgba": /*OUTPUT RGBA*/
                            $rgb_array = self::HEXtoRGB($color_value);
                            $rgba_array = $rgb_array;
                            array_push($rgba_array, $opacity);
                            $color = ($return_as_string) ? 'rgba('.$rgb_array['r'].','.$rgb_array['g'].','.$rgb_array['b'].', '.$opacity.')' : $rgba_array;
                            break;
                        default: /*DEFAULT OUTPUT RGB*/
                            $rgb_array = self::HEXtoRGB($color_value);
                            $color = ($return_as_string) ? 'rgb('.$rgb_array['r'].','.$rgb_array['g'].','.$rgb_array['b'].')' : $rgb_array;
                            break;
                    }
                    break;
            }

            return $color;
        }
    }
    
    /*Format string number to float for numbers with dots or commas as decimals*/
    public static function floatvalue($val){
        $val = str_replace(",",".",$val);
        $val = preg_replace('/\.(?=.*\.)/', '', $val);
        return floatval($val);
    }
}
