

<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

abstract class CssHelper
{
	public static function hex2rgb($hex) {
		$hex = str_replace("#", "", $hex);
	
		if(strlen($hex) == 3) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}
		$rgb = array($r, $g, $b);
		//return implode(",", $rgb); // returns the rgb values separated by commas
		return $rgb; // returns an array with the rgb values
	}
	
	public static function rgb2hex($r, $g, $b) {
		//String padding bug found and the solution put forth by Pete Williams (http://snipplr.com/users/PeteW)
		$hex = "#";
		$hex.= str_pad(dechex($r), 2, "0", STR_PAD_LEFT);
		$hex.= str_pad(dechex($g), 2, "0", STR_PAD_LEFT);
		$hex.= str_pad(dechex($b), 2, "0", STR_PAD_LEFT);
	
		return $hex;
	}
	
	public static function lightenColor($rgb, $coefficient) {
		$r = self::isDec(intval($rgb[0]/(float)$coefficient));
		$g = self::isDec(intval($rgb[1]/(float)$coefficient));
		$b = self::isDec(intval($rgb[2]/(float)$coefficient));
	
		$thinned_color = self::rgb2hex($r, $g, $b);
		return $thinned_color; // returns an array with the rgb values
	}
	
	public static function isDec($dec){
		if($dec > 255){
			$dec = 255;
		}else if($dec < 0){
			$dec = 0;
		}
	
		return $dec;
	}
	
	public static function getButtonCustomColorHex($color){
		$arrayButtonColorHex = array();
		
		$arrayButtonColorHex['dark'] = self::lightenColor(self::hex2rgb($color), 1.1);
		$arrayButtonColorHex['normal'] = self::lightenColor(self::hex2rgb($color), 1.1);
		$arrayButtonColorHex['light'] = self::lightenColor(self::hex2rgb($color), 0.9);
		
		return $arrayButtonColorHex;
	}
}



