<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

/**
 * class NgeBootstrapTag
 * tag reader for compatibility between bootstrap versions 
 * @author jean-marc
 *
 */

class NgeBootstrapTag {

	
	static $_version; //current bootstrap version (loaded in params, or setted manually)
	static $bootstrapTags;
	/*
	 * Getting tag in the current Bootstrap version
	 */
	static function _($tag, $version = null){

		
 		
		
// 		if (isset($partsList))
// 		{
// 			return $partsList;
// 		}
 		
		if ($version == null){
			if (self::$_version == null)
				self::$_version = self::getVersion();
			$version = self::$_version;
		}	
		
		//If data in cache
		if (isset($bootstrapTags) && isset($bootstrapTags[$version]) && is_array($bootstrapTags[$version])){
			return $bootstrapTags[$version][strtoupper($tag)];
		}	
		else {
			if (!isset($bootstrapTags))
				$bootstrapTags = array();
			if ((!isset($bootstrapTags[$version])) || (!is_array($bootstrapTags[$version]))){
				//$filename = 'bootstrap_'.$version.'.ini';
			
				$filename = NGEPATH_HELPERS . '/html/bootstrap/bootstrap_'.$version.'.ini';
				if (file_exists($filename)) {
					$contents = self::parse($filename);
					if (is_array($contents)){
						$bootstrapTags[$version] = $contents;
						return $bootstrapTags[$version][strtoupper($tag)];
					}
					else
						return '';
				}
					return '';		
			}
		}
	
	}
		static function parse($filename){			
			$contents = file_get_contents($filename);
			$strings = @parse_ini_string($contents);
			return $strings;
		}
	
	static function getVersion(){
		if (self::$_version == null){
			//Default Bootstrap version in component params
			//$paramsNextGenEditor= JComponentHelper::getParams('com_nge');
			//self::$_version = $paramsNextGenEditor->get('bootstrap_version',2); //Default version 2
			self::$_version = NGE::params('bootstrap_version',2);			
		}
		return self::$_version;		
	}
	
	static function setVersion($version){
		//Force bootstrap version
		self::$_version = $version;
	}
	
}
