<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

class JoomlaSelect {

    
    /**
     * JoomlaSelect::checkAccess()
     * Check user acces for this action
     * @param string $action, assetname
     * @return none
     */    
    private static function checkAccess($action, $assetname = null) {   
    	$user = JFactory::getUser();
	if (!$user->authorise($action, $assetname)){
	    header("HTTP/1.0 403 Forbidden");
	    exit(JText::_('JERROR_ALERTNOAUTHOR'));
	}
    }
    
    /**
     * JoomlaSelect::accesslevels()
     * 
     * @param string $search
     * @return Array
     */
    public static function accesslevels($search = '') {
	
        self::checkAccess('core.admin');
	
        $db = JFactory::getDbo();        
        $sql = 'SELECT id, title as text from #__viewlevels';        
        if(trim($search) != ''){
            $search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
            $sql .= ' WHERE title LIKE ' . $search;
        }
        $sql .= ' order by ordering,title';        	
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }
    
    /**
     * JoomlaSelect::users()
     * 
     * @param string $search
     * @return Array
     */
    public static function users($search = '') {
	
        self::checkAccess('core.admin');
	
        $db = JFactory::getDbo();
        $sql = 'SELECT id, name as text from #__users';
        if(trim($search) != ''){
            $search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
            $sql .= ' WHERE name LIKE ' . $search;
    }
        $sql .= ' order by name';
        $db->setQuery($sql);
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }

    /**
     * JoomlaSelect::usergroups()
     * 
     * @param string $search
     * @return Array
     */
    public static function usergroups($search = '') {
	
        self::checkAccess('core.admin');
	
        $db = JFactory::getDbo();
        $sql = 'SELECT id, title as text from #__usergroups';        
        if(trim($search) != ''){
            $search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
            $sql .= ' WHERE title LIKE ' . $search;
        }
        $sql .= ' order by title';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }
    
    
    /**
     * JoomlaSelect::menuitems()
     * 
     * @param string $search
     * @return Array
     */
    public static function menuitems($search = '') {

        self::checkAccess('core.edit', 'com_content');
	
        $db = JFactory::getDbo();
        $sql = 'SELECT menu.id, menu.title as text, menutype.title as menutype, menu.level  
                from #__menu menu RIGHT JOIN #__menu_types menutype ON menutype.menutype=menu.menutype';
        $sql .= ' WHERE menu.published != -2';
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
	$sql .= ' AND menu.title LIKE ' . $search . ' AND menu.published != -2';
        }
        $sql .= ' ORDER by menutype.title, menu.lft';
        $db->setQuery($sql);
        $queryResult = $db->loadObjectList();
        
        // parse result to separate groups
        $menuTree = array(); 
        foreach($queryResult as $menuitem) {
            $menuTree[$menuitem->menutype]['text'] = $menuitem->menutype;
            if($menuitem->level -1 > 0) {
                $levelstring = str_pad('',($menuitem->level -1)*2, '- ',STR_PAD_LEFT);
                $menuitem->text = $levelstring . $menuitem->text ;
            }
            $menuTree[$menuitem->menutype]['children'][] = $menuitem;
        }

        // format an array with  result
        $result['total_count'] = count($queryResult);
        $result['items'] = array_values($menuTree);
        return $result;
    }

    /**
     * JoomlaSelect::menus()
     * 
     * @param string $search
     * @return Array
     */
    public static function menus($search = '') {
	
        self::checkAccess('core.edit', 'com_content');
	
        $db = JFactory::getDbo();
        $sql = 'SELECT menutype as id, title as text from #__menu_types';
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
        	$sql .= ' WHERE title LIKE ' . $search;
	}	    
        $sql .= ' order by title';
        $db->setQuery($sql);
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;
    }

    /**
     * JoomlaSelect::contentcategories()
     * 
     * @param string $search
     * @return Array
     */
    public static function contentcategories($search = '') {
	
        self::checkAccess('core.edit', 'com_content');
	
        $db = JFactory::getDbo();
        $sql = 'SELECT id, title as text, level from #__categories
                    WHERE extension="com_content" AND level>0 ';
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
	$sql .= ' AND title LIKE ' . $search;
        }
        $sql .= ' order by path';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // parse result to add - before sub category
        $catsTree = array(); 
        foreach($queryResult as $catItem) {            
            if($catItem->level - 1 > 0) {
                $levelstring = str_pad('',($catItem->level -1)*2, '- ',STR_PAD_LEFT);
                $catItem->text = $levelstring . $catItem->text ;
            }
            $tagsTree[] = $catItem;
        }

        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }

    /**
     * JoomlaSelect::contentcategories()
     * 
     * @param string $search
     * @return Array
     */
    public static function mediafolders($search = '') {
	
        self::checkAccess('core.edit', 'com_content');
	
	
    $dataFolders = array();
    $path = '/images';
    
    $folders = JFolder::listFolderTree(JPATH_ROOT . $path, '', 1);
        foreach($folders as $folder) {
	    $folderName = trim(str_replace('\\', '/', $folder['relname']));
	    $folderName = trim(str_replace($path, '', $folderName), '/');
	    
	    $option = new stdClass();
	    $option->id = $folderName;
	    if ($folder['parent'] !=0){
		$folderName = '-' . $folderName;
	    }
	    $option->text = $folderName;
            $dataFolders[] = $option;
        }
/*	
    $folders = JFolder::folders(JPATH_ROOT . $path, '', false);
        foreach($folders as $folder) {
	    $option = new stdClass();
	    $option->id = $folder;
	    $option->text = $folder;
            $dataFolders[] = $option;
        }
*/	
	
        // format an array with  result
        $result['total_count'] = count($dataFolders);        
        $result['items'] = $dataFolders;
        return $result;        
    }
    
    
    /**
     * JoomlaSelect::content()
     * 
     * @param string $search
     * @return Array
     */
    public static function content($search = '') {
	
        self::checkAccess('core.edit', 'com_content');	
	
        $db = JFactory::getDbo();
        $sql = 'SELECT id, title as text from #__content';        
        if(trim($search) != ''){
            $search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
            $sql .= ' WHERE title LIKE ' . $search;
        }
        $sql .= ' order by title';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }

    /**
     * JoomlaSelect::extensions()
     * 
     * @param string $search
     * @return Array
     */
    public static function extensions($search = '') {
	
        self::checkAccess('core.admin');	
	
        $db = JFactory::getDbo();
        $sql = 'SELECT element as id, name as text from #__extensions
                    WHERE type="component"';
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
	$sql .= ' AND name LIKE ' . $search;
        }
        $sql .= ' order by name';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }

    /**
     * JoomlaSelect::languages()
     * 
     * @param string $search
     * @return Array
     */
    public static function languages($search = '') {
	
        self::checkAccess('core.edit', 'com_content');	
	
        $db = JFactory::getDbo();
        $sql = 'SELECT lang_code as id, title as text from #__languages';        
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
	$sql .= ' WHERE title LIKE ' . $search;
        }
        $sql .= ' order by title';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // format an array with  result
        $result['total_count'] = count($queryResult);        
        $result['items'] = $queryResult;
        return $result;        
    }
    
    /**
     * JoomlaSelect::tags()
     * 
     * @param string $search
     * @return
     */
    public static function tags($search = '') {
	
        self::checkAccess('core.edit', 'com_content');	
	
        $db = JFactory::getDbo();
        $sql = 'SELECT tags.id, tags.title as text, tags.level  
                from #__tags tags';                
        $sql .= ' WHERE level>0 ';        
        if(trim($search) != ''){
	$search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);	                    
	$sql .= ' AND tags.title LIKE ' . $search;
        }
        $sql .= ' order by tags.path';
        $db->setQuery($sql);        
        $queryResult = $db->loadObjectList();
        
        // parse result to add - before sub tags
        $tagsTree = array(); 
        foreach($queryResult as $tagitem) {
            
            if($tagitem->level - 1 > 0) {
                $levelstring = str_pad('',($tagitem->level -1)*2, '- ',STR_PAD_LEFT);
                $tagitem->text = $levelstring . $tagitem->text ;
            }
            $tagsTree[] = $tagitem;
        }

        // format an array with  result
        $result['total_count'] = count($queryResult);
        $result['items'] = array_values($tagsTree);
        return $result;    
    }
          
}