<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

$counterparts = array();
//text
$counterparts['text.label'] = array('text.title', 'navigation.link', 'navigation.button');
$counterparts['text.dropcap'] = array();
$counterparts['text.title'] = array('navigation.link', 'navigation.button');
$counterparts['text.columns'] = array('panels.panel', 'text.expandable', 'panels.grid', 'panels.tabs', 'panels.accordion', 'panels.slider', 'panels.carousel');
$counterparts['text.expandable'] = array('panels.panel', 'text.columns', 'panels.grid', 'panels.tabs', 'panels.accordion', 'panels.slider', 'panels.carousel');
//Panels
$counterparts['panels.panel'] = array('panels.panel', 'text.columns', 'panels.grid', 'panels.tabs', 'panels.accordion', 'panels.slider', 'panels.carousel');
$counterparts['panels.grid'] = array('panels.tabs', 'panels.accordion', 'panels.slider', 'panels.carousel');
$counterparts['panels.tabs'] = array('panels.grid', 'panels.accordion', 'panels.slider', 'panels.carousel');
$counterparts['panels.accordion'] = array('panels.tabs', 'panels.grid', 'panels.slider', 'panels.carousel');
$counterparts['panels.slider'] = array('panels.carousel', 'panels.tabs', 'panels.grid', 'panels.accordion');
$counterparts['panels.carousel'] = array('panels.slider', 'panels.tabs', 'panels.grid', 'panels.accordion');
//Images
$counterparts['images.image'] = array('images.magnification', 'images.grid', 'images.slider', 'images.carousel');
$counterparts['images.magnification'] = array('images.image', 'images.grid', 'images.slider', 'images.carousel');
$counterparts['images.grid'] = array('images.slider', 'images.carousel', 'images.image', 'images.magnification');
$counterparts['images.slider'] = array('images.carousel', 'images.grid', 'images.image', 'images.magnification');
$counterparts['images.carousel'] = array('images.slider', 'images.grid', 'images.image', 'images.magnification');
$counterparts['images.ticker'] = array('images.grid', 'images.slider', 'images.carousel', 'images.image', 'images.magnification');
$counterparts['media.video'] = array();
$counterparts['media.audio'] = array();
$counterparts['media.flash'] = array();
$counterparts['media.svg'] = array();
//Navigation
$counterparts['navigation.link'] = array('navigation.button', 'navigation.buttonbar', 'navigation.dropdown', 'navigation.list', 'text.label', 'text.title');
$counterparts['navigation.button'] = array('navigation.link', 'navigation.buttonbar', 'navigation.dropdown', 'navigation.list', 'text.label', 'text.title');
$counterparts['navigation.buttonbar'] = array('navigation.button', 'navigation.link', 'navigation.dropdown', 'navigation.list');
$counterparts['navigation.list'] = array('navigation.buttonbar', 'navigation.dropdown', 'navigation.link');
$counterparts['navigation.dropdown'] = array('navigation.buttonbar', 'navigation.list', 'navigation.button', 'navigation.link');
$counterparts['joomla.menus.dropdown'] = array('joomla.menus.list', 'joomla.menus.columns');
$counterparts['joomla.menus.list'] = array('joomla.menus.dropdown', 'joomla.menus.columns');
$counterparts['joomla.menus.columns'] = array('joomla.menus.dropdown', 'joomla.menus.list');
//Blog
$counterparts['joomla.blog.nav.buttonbar'] = array('joomla.blog.nav.list', 'joomla.blog.nav.dropdown', 'joomla.blog.display.grid', 'joomla.blog.display.tabs', 'joomla.blog.display.slider', 'joomla.blog.display.carousel');
$counterparts['joomla.blog.nav.list'] = array('joomla.blog.nav.buttonbar', 'joomla.blog.nav.dropdown', 'joomla.blog.display.grid', 'joomla.blog.display.tabs', 'joomla.blog.display.slider', 'joomla.blog.display.carousel');
$counterparts['joomla.blog.nav.dropdown'] = array('joomla.blog.nav.buttonbar', 'joomla.blog.nav.list', 'joomla.blog.display.grid', 'joomla.blog.display.tabs', 'joomla.blog.display.slider', 'joomla.blog.display.carousel');
$counterparts['joomla.blog.display.grid'] = array('joomla.blog.display.tabs', 'joomla.blog.display.slider', 'joomla.blog.display.carousel', 'joomla.blog.nav.buttonbar', 'joomla.blog.nav.list', 'joomla.blog.nav.dropdown');
$counterparts['joomla.blog.display.tabs'] = array('joomla.blog.display.grid', 'joomla.blog.display.slider', 'joomla.blog.display.carousel', 'joomla.blog.nav.buttonbar', 'joomla.blog.nav.list', 'joomla.blog.nav.dropdown');
$counterparts['joomla.blog.display.slider'] = array('joomla.blog.display.grid', 'joomla.blog.display.tabs', 'joomla.blog.display.carousel', 'joomla.blog.nav.buttonbar', 'joomla.blog.nav.list', 'joomla.blog.nav.dropdown');
$counterparts['joomla.blog.display.carousel'] = array('joomla.blog.display.grid', 'joomla.blog.display.tabs', 'joomla.blog.display.slider', 'joomla.blog.nav.buttonbar', 'joomla.blog.nav.list', 'joomla.blog.nav.dropdown');

//Get Current config param info if pk exist else it's a new one
if($data['pk'] != ""){
    require_once NGEPATH_HELPERS . '/ngepartshelper.php'; 
    $part = NgePartsHelper::getPart('['.$data['pk'].']');
    $partName = $part->name;
}

require_once(NGEPATH_CLASSES.'/ngelibrarygalleryhelper.php');

NgeLibrarygalleryHelper::loadPacksLanguage();
$parts = NgeLibrarygalleryHelper::getPartsList($counterparts[$partName]);

?>
<script>
    <?php include NGEPATH_HELPERS  . '/forms/parts/preset_js.php'; ?>
submit = function(){
    console.log('VALID DANS TRANSFORM');
//	jQuery("#ngeinlinebody").hide();
	_params.submit(_params.element, oldItemId, currentItemId);	
    };
    
    cancel = function(){
	console.log('CANCEL DANS TRANSFORM');
//	jQuery("#ngeinlinebody").hide();
	_params.cancel(_params.element);
    };	
	
    </script>
<style>
    <?php include NGEPATH_HELPERS  . '/forms/parts/preset_css.php'; ?>
</style>
<?php
//    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? '.' : "";
    $form=array();
echo '<h3>Transform your widget into ...</h3>';
    		$form[] = '<div class="ngepresetlist">';
		$form[] = '<div id="thumbs_module_0" style="min-width:180px;height:200px;" class="ngepreset" data-id="0"><div>Remove widget<br/>and<br/>keep text</div></div>';
		foreach ($parts as $part){
		    $name    = htmlspecialchars($part->title);
		    $description    = htmlspecialchars($part->description);
		    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($part->description)), 200);
		    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($desc)), 90);
		    $form[] = '<div class="ngepreset" style="min-width:180px;height:200px;" data-id="'.$part->name.'"><div>';
		    $form[] =  JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name, null, false, true) ? JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name) : '<img src="'.JUri::root().'components/com_nge/assets/images/default_thumb.png" />';
		    $form[] = '<div>' . NGE::translate($description).'</div>';
		    $form[] = '<div class="ngebottomtitle"><h4>' . NGE::translate($name).'</h4></div>';
		    $form[] = '</div></div>';
		}
		$form[] = '</div>';
		$form[] = '<div style="float:right;margin-right:40px;"><button class="ngebottombtn"><span class="icomoon-magic-wand"></span>&nbsp;Transform</button></div>';
    
    echo '<form id="optionsform" class="ngeoptionsform">';
    echo implode($form);
    echo '</form>';