<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS . '/data/nge/presetsdriver.php');
$items = NgePresetsDriver::loadList('part', 'display');

?>
<script>
    <?php include NGEPATH_HELPERS  . '/forms/parts/preset_js.php'; ?>
    </script>
<style>
    <?php include NGEPATH_HELPERS  . '/forms/parts/preset_css.php'; ?>
</style>
<?php
//    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? '.' : "";
    $form=array();

    $form[] = '<div>';
    $form[] = '<ul id="tabs" class="nav nav-tabs headconfigbar" data-tabs="tabs">';
    $form[] = '    <li class="active"><a href="#tabdisplaydesigns" data-toggle="tab">'.NGE::translate('COM_NGE_DESIGNS').'</a></li>';
    $form[] = '    <li><a href="#tabdisplaycustom" data-toggle="tab">'.NGE::translate('COM_NGE_CUSTOM').'</a></li>';
    $form[] = '</ul>';
    $form[] = '<div class="tab-content">';
    $form[] = '    <div class="tab-pane active" id="tabdisplaydesigns">';
		$form[] = '<div class="ngepresetlist">';
		foreach ($items as $item){
		    $name    = htmlspecialchars($item->title);
		    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->description)), 200);
		    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($desc)), 90);
		    $form[] = '<div id="thumbs_module_'.$item->id.'" class="ngepreset" data-id="'.$item->id.'"><div>' . $item->thumbnail . ''.$name.'</div></div>';
		}
		$form[] = '</div>';
    $form[] = '    </div>';
    $form[] = '    <div class="tab-pane" id="tabdisplaycustom">';
    $form[] = '        <div class="tabbable tabs-left">'; 						
    $form[] = '            <ul class="nav nav-tabs" data-tabs="tabs">';
    $form[] = '                <li class="active"><a href="#tabwidth" data-toggle="tab">'.NGE::translate( 'COM_NGE_WIDTH' ).'</a></li>';			
    $form[] = '                <li><a href="#tabheight" data-toggle="tab">'.NGE::translate( 'COM_NGE_HEIGHT' ).'</a></li>';
    $form[] = '                <li><a href="#tabmargins" data-toggle="tab">'.NGE::translate( 'COM_NGE_MARGIN' ).'</a></li>';
    $form[] = '            </ul>';
    $form[] = '            <div class="tab-content">';
    $form[] = '                <div class="tab-pane active" id="tabwidth">';
    // align field
    $form[] =                   NgeFields::radio('size.align','COM_NGE_ALIGN','COM_NGE_DISPLAY_ALIGN_DESC','available', array(
                                    array('available','','data-target="#size_overflow"','icomoon-paragraph-justify'),
                                    array('left','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-left'),
                                    array('center','','data-target="#size_width"', 'icomoon-paragraph-center'), 
                                    array('right','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-right')                                    
                                ));
    $form[] = '                    <div id="size_width">';
    // width mode
    $form[] =                           NgeFields::radio('size.width.mode','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_DESC','content', array(
                                            array('content','COM_NGE_CONTENT'), 
                                            array('flexible','COM_NGE_DISPLAY_WIDTH_FLEXIBLE','data-target="field:size[width][flexible_value]"'),
                                            array('fixed','COM_NGE_DISPLAY_WIDTH_FIXED','data-target="field:size[width][fixed_value]"') 
                                        ));
    // flexible mode value
    $form[] =                           NgeFields::slider('size.width.flexible_value','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_FLEXIBLE_DESC','50', 'min="1" max="100" step="1"  suffix="%"');	
    // fixed mode value    
    $form[] =                           NgeFields::text('size.width.fixed_value', 'COM_NGE_WIDTH', 'COM_NGE_DISPLAY_WIDTH_FIXED_DESC', '', array('attributes' => 'class="span4"', 'suffix' => 'px'));
    
    	$form[] = '                    </div>';
            $form[] = '                    <div id="size_linebreak">';
// linebreak display
    $form[] =                           NgeFields::radio('size.display','COM_NGE_DISPLAY_LINEBREAK','COM_NGE_DISPLAY_LINEBREAK_DESC','block', array(
                                            array('block','JYES'), 
                                            array('inline','JNO') 
                                        ));
    $form[] = '                    </div>';
    $form[] = '                    <div id="size_overflow">';
    $form[] =                           NgeFields::radio('size.overflow.mode','COM_NGE_OVERFLOW','COM_NGE_OVERFLOW_DESC','none', array(
                                            array('none','COM_NGE_NONE'), 
                                            array('background','COM_NGE_OVERFLOW_BACKGROUND','data-target="field:size[overflow][direction] field:size[overflow][width]"'),
                                            array('all','COM_NGE_OVERFLOW_ALL','data-target="field:size[overflow][direction] field:size[overflow][width]"')
                                        ));
    $form[] =                           NgeFields::radio('size.overflow.direction','COM_NGE_OVERFLOW_DIRECTION','COM_NGE_OVERFLOW_DIRECTION_DESC','both', array(
                                            array('both','COM_NGE_OVERFLOW_BOTHSIDES'),
                                            array('left','COM_NGE_OVERFLOW_LEFT'),
			array('right','COM_NGE_OVERFLOW_RIGHT') 
                                        ));
    $form[] =                           NgeFields::slider('size.overflow.width','COM_NGE_OVERFLOW_WIDTH','COM_NGE_OVERFLOW_WIDTH_DESC','100', 'min="0" max="100" step="1"  suffix="%"');
    $form[] = '                    </div>';    
    $form[] = '                </div>';
    $form[] = '                <div class="tab-pane" id="tabheight">';
// height mode
    $form[] =                      NgeFields::radio('size.height.mode','COM_NGE_HEIGHT','','auto', array(
                                        array('auto','COM_NGE_AUTO'), 
                                        array('custom','COM_NGE_CUSTOM','data-target="#display_height_custom"')
                                    ));
    $form[] = '                <div id="display_height_custom">';
    // custom height value
    $form[] =                      NgeFields::text('size.height.value', 'COM_NGE_HEIGHT', '', '', array('attributes' => 'class="span3"', 'suffix' => 'px'));
    $form[] =		NgeFields::radio('size.height.overflow', 'COM_NGE_HEIGHT_OVERFLOW', 'COM_NGE_HEIGHT_OVERFLOW_DESC', 'scrollbar', array(
			array('scrollbar', 'COM_NGE_SCROLLBAR','data-target="#display_height_scrollbar"'),
			array('visible', 'COM_NGE_VISIBLE'),
			array('hidden', 'COM_NGE_HIDDEN')
			));
    $form[] = '                <div id="display_height_scrollbar">';
    $form[] =		//NgeFields::formLayout('parts.core.base', 'scrollbarDefault', 'scrollbar'); 
    $form[] = '                </div>';    
    $form[] = '                </div>';
    $form[] = '                <div class="tab-pane" id="tabmargins">';
    $form[] =                      NgeFields::text('size.margin.top', 'COM_NGE_MARGIN_TOP', 'COM_NGE_MARGIN_TOP_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text('size.margin.bottom', 'COM_NGE_MARGIN_BOTTOM', 'COM_NGE_MARGIN_BOTTOM_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text('size.margin.left', 'COM_NGE_MARGIN_LEFT', 'COM_NGE_MARGIN_LEFT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text('size.margin.right', 'COM_NGE_MARGIN_RIGHT', 'COM_NGE_MARGIN_RIGHT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] = '                </div>';
    $form[] = '            </div>';
    $form[] = '        </div>';
    $form[] = '    </div>';
    $form[] = '</div>';
    $form[] = '</div>';

    echo '<form id="optionsform" class="ngeoptionsform">';
    echo implode($form);
    echo '</form>';