<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

 /**
  * multipleThumbnailsContent()
  * used in panels.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleThumbnailsPattern($objectPrefix, $multiple=false, $multipleIndex=0){
    $form=array();
    //$form[] = $multipleIndex;
    $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '<div class="tab-pane tabs">
    		      <ul class="nav nav-tabs" data-tabs="tabs">
    			     <li class="active"><a href="#'.$tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT').'</a></li>
    			     <li><a href="#'.$tabPrefix . '_title" data-toggle="tab">'.NGE::translate('COM_NGE_TITLE').'</a></li>
    		      </ul>
    		      <div class="tab-content">
        			<div class="tab-pane active" id="'.$tabPrefix . '_content">';
    $form[] =             NgeFields::formlayout('patterns.content', 'panelPattern', $objectPrefix);
    $form[] = '		</div>
        			<div class="tab-pane" id="'.$tabPrefix . '_title">';
    $form[] =             NgeFields::formlayout('patterns.content', 'multiplePatternTitle', $objectPrefix, $multiple, $multipleIndex);
    $form[] = '		</div>    
    		      </div>
    		</div>';	
    
    return implode($form);
}

 /**
  * multipleThumbnailsContentMedia()
  * used in galleries.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleThumbnailsPatternMedia($objectPrefix, $multiple=false, $multipleIndex=0){
     $form=array();

     $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '
    <div class="tab-pane tabs">
        <ul class="nav nav-tabs" data-tabs="tabs">
            <li class="active"><a href="#' . $tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_IMAGE').'</a></li>
            <li><a href="#' . $tabPrefix . '_hover" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_CAPTION').'</a></li>			
            <li><a href="#' . $tabPrefix . '_title" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_TITLE').'</a></li>			
            <li><a href="#' . $tabPrefix . '_legend" data-toggle="tab">'.NGE::translate('COM_NGE_LEGEND').'</a></li>													
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="'.$tabPrefix . '_content">';    
	    $form[] = NgeFields::formlayout('parts.core.content', 'multipleContentImage', $objectPrefix);
    $form[] = '
            </div>
            <div class="tab-pane" id="'.$tabPrefix . '_hover">';
	$form[] = NgeFields::editor($objectPrefix . '.caption.html');
    $form[] = '
            </div>
            <div class="tab-pane" id="'.$tabPrefix . '_title">';
	$form[] = NgeFields::formlayout('parts.core.content', 'multipleContentTitle', $objectPrefix);
    $form[] = '
            </div>					
            <div class="tab-pane" id="'.$tabPrefix . '_legend">';
	$form[] = NgeFields::editor($objectPrefix .'.legend');
    $form[] = '
            </div>    
        </div>
    </div>';	
    
    return implode($form);
}